import { defineConfig } from 'astro/config';
import mdx from '@astrojs/mdx';
import node from '@astrojs/node';

export default defineConfig({
  output: 'server',
  adapter: node({
    mode: 'standalone',
  }),
  base: '',
  outDir: './dist',
  build: {
    assets: 'assets',
    assetsPrefix: '/',
  },
  vite: {
    build: {
      cssCodeSplit: false,
      rollupOptions: {
        output: {
          assetFileNames: 'assets/[name][extname]',
        },
      },
    },
    server: {
      proxy: {
        '/api': {
          target: process.env.PUBLIC_API_URL,
          changeOrigin: true,
          secure: false,
        },
      },
    },
  },
});
