import { e as createComponent, r as renderTemplate, m as maybeRenderHead, g as addAttribute, l as renderScript, h as createAstro } from './astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import 'clsx';

const $$Astro = createAstro();
const $$Pagination = createComponent(($$result, $$props, $$slots) => {
  const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
  Astro2.self = $$Pagination;
  const {
    id,
    currentPage = 1,
    totalPages = 1,
    showEllipsis = true,
    position = "end",
    size = "sm"
  } = Astro2.props;
  const positionClass = position === "start" ? "float-start" : position === "center" ? "justify-content-center" : "float-end";
  const sizeClass = size === "sm" ? "pagination-sm" : size === "lg" ? "pagination-lg" : "";
  return renderTemplate`${maybeRenderHead()}<ul${addAttribute(`pagination ${sizeClass} m-0 ${positionClass}`, "class")}${addAttribute(id, "id")}> <li${addAttribute(`page-item ${currentPage === 1 ? "disabled" : ""}`, "class")}> <a class="page-link" href="#" data-page="prev">&laquo;</a> </li> ${Array.from({ length: Math.min(5, totalPages) }, (_, i) => renderTemplate`<li${addAttribute(`page-item ${i + 1 === currentPage ? "active" : ""}`, "class")}> <a class="page-link" href="#"${addAttribute(i + 1, "data-page")}>${i + 1}</a> </li>`)} ${totalPages > 5 && showEllipsis && renderTemplate`<li class="page-item disabled"><a class="page-link" href="#">...</a></li>`} <li${addAttribute(`page-item ${currentPage === totalPages ? "disabled" : ""}`, "class")}> <a class="page-link" href="#" data-page="next">&raquo;</a> </li> </ul> ${renderScript($$result, "/Users/jin/Developments/work/ea/AdminLTE/src/html/components/common/_pagination.astro?astro&type=script&index=0&lang.ts")}`;
}, "/Users/jin/Developments/work/ea/AdminLTE/src/html/components/common/_pagination.astro", undefined);

export { $$Pagination as $ };
