import {
  e as createComponent,
  r as renderTemplate,
  m as maybeRenderHead,
  g as addAttribute,
  h as createAstro,
} from './astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import 'clsx';

const $$Footer = createComponent(
  ($$result, $$props, $$slots) => {
    const year = /* @__PURE__ */ new Date().getFullYear();
    return renderTemplate`<!--begin::Footer-->${maybeRenderHead()}<footer class="app-footer"> <!--begin::To the end--> <div class="float-end d-none d-sm-inline">Adimsayar</div> <!--end::To the end--> <!--begin::Copyright--> <strong>
Copyright &copy; ${year}&nbsp;
</strong>
All rights reserved.
<!--end::Copyright--> </footer> <!--end::Footer-->`;
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/html/components/dashboard/_footer.astro',
  undefined,
);

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) =>
  __freeze(__defProp(cooked, 'raw', { value: __freeze(cooked.slice()) }));
var _a;
const $$Topbar = createComponent(
  ($$result, $$props, $$slots) => {
    return renderTemplate(
      _a ||
        (_a = __template([
          '',
          `<nav class="app-header navbar navbar-expand bg-body"> <!--begin::Container--> <div class="container-fluid"> <!--begin::Start Navbar Links--> <ul class="navbar-nav"> <li class="nav-item"> <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button"> <i class="bi bi-list"></i> </a> </li> </ul> <!--end::Start Navbar Links--> <!--begin::End Navbar Links--> <ul class="navbar-nav ms-auto"> <!--begin::Fullscreen Toggle--> <li class="nav-item"> <a class="nav-link" href="#" data-lte-toggle="fullscreen"> <i data-lte-icon="maximize" class="bi bi-arrows-fullscreen"></i> <i data-lte-icon="minimize" class="bi bi-fullscreen-exit" style="display: none;"></i> </a> </li> <!--end::Fullscreen Toggle--> <!--begin::User Menu Dropdown--> <li class="nav-item dropdown user-menu"> <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown"> <span class="d-none d-md-inline">Administrator</span> </a> <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end"> <!--begin::Menu Footer--> <li class="user-footer"> <a href="/logout" class="btn btn-default btn-flat float-end">Sign out</a> </li> <!--end::Menu Footer--> </ul> </li> <!--end::User Menu Dropdown--> </ul> <!--end::End Navbar Links--> </div> <!--end::Container--> </nav> <!--end::Header--> <script>
  // \uB85C\uADF8\uC544\uC6C3 \uCC98\uB9AC
  document.addEventListener('DOMContentLoaded', function() {
    const logoutBtn = document.querySelector('.user-footer a[href="/logout"]');
    
    if (logoutBtn) {
      logoutBtn.addEventListener('click', function(e) {
        e.preventDefault();
        
        // \uCFE0\uD0A4\uC5D0\uC11C \uD1A0\uD070 \uC0AD\uC81C
        document.cookie = "auth_token=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
        
        // \uB85C\uCEEC \uC2A4\uD1A0\uB9AC\uC9C0\uC5D0\uC11C\uB3C4 \uD1A0\uD070 \uC0AD\uC81C (\uC788\uC744 \uACBD\uC6B0)
        localStorage.removeItem('auth_token');
        
        // \uB85C\uADF8\uC778 \uD398\uC774\uC9C0\uB85C \uB9AC\uB2E4\uC774\uB809\uD2B8
        window.location.href = '/';
      });
    }
  });
<\/script>`,
        ])),
      maybeRenderHead(),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/html/components/dashboard/_topbar.astro',
  undefined,
);

function convertPathToHtml(path) {
  let count = 0;
  let htmlPath = '';
  while (path.startsWith('../')) {
    count++;
    path = path.slice(3);
  }

  if (count === 2) {
    htmlPath = '.';
  }

  if (count === 3) {
    htmlPath = '..';
  }

  if (count === 4) {
    htmlPath = '../..';
  }

  if (count === 5) {
    htmlPath = '../../..';
  }

  return htmlPath;
}

const $$Astro = createAstro();
const $$Sidenav = createComponent(
  ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Sidenav;
    const { path, mainPage } = Astro2.props;
    const htmlPath = convertPathToHtml(path);
    return renderTemplate`<!--begin::Sidebar-->${maybeRenderHead()}<aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark"> <!--begin::Sidebar Brand--> <div class="sidebar-brand"> <!--begin::Brand Link--> <a${addAttribute(htmlPath + '/dashboard', 'href')} class="brand-link"> <!--begin::Brand Image--> <img${addAttribute(htmlPath + '/src/assets/img/logogreen.png', 'src')} alt="Adimsayar Logo" class="brand-image opacity-75 shadow"> <!--end::Brand Image--> <!--begin::Brand Text--> <span class="brand-text fw-light">Adimsayar</span> <!--end::Brand Text--> </a> <!--end::Brand Link--> </div> <!--end::Sidebar Brand--> <!--begin::Sidebar Wrapper--> <div class="sidebar-wrapper"> <nav class="mt-2"> <!--begin::Sidebar Menu--> <ul class="nav sidebar-menu flex-column" data-lte-toggle="treeview" role="menu" data-accordion="false"> <!-- Dashboard --> <li${addAttribute(['nav-item', mainPage === 'dashboard'], 'class:list')}> <a${addAttribute(htmlPath + '/dashboard', 'href')}${addAttribute(['nav-link', mainPage === 'dashboard'], 'class:list')}> <i class="nav-icon bi bi-speedometer"></i> <p>Dashboard</p> </a> </li> <!-- Users --> <li class="nav-header">Users Management</li> <li${addAttribute(['nav-item', mainPage === 'users'], 'class:list')}> <a${addAttribute(htmlPath + '/user-management', 'href')}${addAttribute(['nav-link', mainPage === 'users'], 'class:list')}> <i class="nav-icon bi bi-person-fill"></i> <p>Users</p> </a> </li> <li class="nav-header">Store Management</li> <!-- Categories --> <li${addAttribute(['nav-item', mainPage === 'categories'], 'class:list')}> <a${addAttribute(htmlPath + '/category-management', 'href')}${addAttribute(['nav-link', mainPage === 'categories'], 'class:list')}> <i class="nav-icon bi bi-tags-fill"></i> <p>Categories</p> </a> </li> <!-- Products --> <li${addAttribute(['nav-item', mainPage === 'products'], 'class:list')}> <a${addAttribute(htmlPath + '/product-management', 'href')}${addAttribute(['nav-link', mainPage === 'products'], 'class:list')}> <i class="nav-icon bi bi-box-seam-fill"></i> <p>Products</p> </a> </li> <!-- Orders --> <li${addAttribute(['nav-item', mainPage === 'orders'], 'class:list')}> <a${addAttribute(htmlPath + '/order-management', 'href')}${addAttribute(['nav-link', mainPage === 'orders'], 'class:list')}> <i class="nav-icon bi bi-clipboard-fill"></i> <p>Orders</p> </a> </li> <li class="nav-header">Advertisements Management</li> <!-- Advertisements --> <li${addAttribute(['nav-item', mainPage === 'advertisements'], 'class:list')}> <a${addAttribute(htmlPath + '/ad-management', 'href')}${addAttribute(['nav-link', mainPage === 'advertisements'], 'class:list')}> <i class="nav-icon bi bi-tv-fill"></i> <p>Advertisements</p> </a> </li> </ul> <!--end::Sidebar Menu--> </nav> </div> <!--end::Sidebar Wrapper--> </aside> <!--end::Sidebar-->`;
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/html/components/dashboard/_sidenav.astro',
  undefined,
);

export { $$Footer as $, $$Sidenav as a, $$Topbar as b };
