import 'kleur/colors';
import { n as decodeKey } from './chunks/astro/server_nEfbMHZV.mjs';
import 'clsx';
import 'cookie';
import { N as NOOP_MIDDLEWARE_FN } from './chunks/astro-designed-error-pages_CapCBYN2.mjs';
import 'es-module-lexer';

function sanitizeParams(params) {
  return Object.fromEntries(
    Object.entries(params).map(([key, value]) => {
      if (typeof value === "string") {
        return [key, value.normalize().replace(/#/g, "%23").replace(/\?/g, "%3F")];
      }
      return [key, value];
    })
  );
}
function getParameter(part, params) {
  if (part.spread) {
    return params[part.content.slice(3)] || "";
  }
  if (part.dynamic) {
    if (!params[part.content]) {
      throw new TypeError(`Missing parameter: ${part.content}`);
    }
    return params[part.content];
  }
  return part.content.normalize().replace(/\?/g, "%3F").replace(/#/g, "%23").replace(/%5B/g, "[").replace(/%5D/g, "]");
}
function getSegment(segment, params) {
  const segmentPath = segment.map((part) => getParameter(part, params)).join("");
  return segmentPath ? "/" + segmentPath : "";
}
function getRouteGenerator(segments, addTrailingSlash) {
  return (params) => {
    const sanitizedParams = sanitizeParams(params);
    let trailing = "";
    if (addTrailingSlash === "always" && segments.length) {
      trailing = "/";
    }
    const path = segments.map((segment) => getSegment(segment, sanitizedParams)).join("") + trailing;
    return path || "/";
  };
}

function deserializeRouteData(rawRouteData) {
  return {
    route: rawRouteData.route,
    type: rawRouteData.type,
    pattern: new RegExp(rawRouteData.pattern),
    params: rawRouteData.params,
    component: rawRouteData.component,
    generate: getRouteGenerator(rawRouteData.segments, rawRouteData._meta.trailingSlash),
    pathname: rawRouteData.pathname || undefined,
    segments: rawRouteData.segments,
    prerender: rawRouteData.prerender,
    redirect: rawRouteData.redirect,
    redirectRoute: rawRouteData.redirectRoute ? deserializeRouteData(rawRouteData.redirectRoute) : undefined,
    fallbackRoutes: rawRouteData.fallbackRoutes.map((fallback) => {
      return deserializeRouteData(fallback);
    }),
    isIndex: rawRouteData.isIndex,
    origin: rawRouteData.origin
  };
}

function deserializeManifest(serializedManifest) {
  const routes = [];
  for (const serializedRoute of serializedManifest.routes) {
    routes.push({
      ...serializedRoute,
      routeData: deserializeRouteData(serializedRoute.routeData)
    });
    const route = serializedRoute;
    route.routeData = deserializeRouteData(serializedRoute.routeData);
  }
  const assets = new Set(serializedManifest.assets);
  const componentMetadata = new Map(serializedManifest.componentMetadata);
  const inlinedScripts = new Map(serializedManifest.inlinedScripts);
  const clientDirectives = new Map(serializedManifest.clientDirectives);
  const serverIslandNameMap = new Map(serializedManifest.serverIslandNameMap);
  const key = decodeKey(serializedManifest.key);
  return {
    // in case user middleware exists, this no-op middleware will be reassigned (see plugin-ssr.ts)
    middleware() {
      return { onRequest: NOOP_MIDDLEWARE_FN };
    },
    ...serializedManifest,
    assets,
    componentMetadata,
    inlinedScripts,
    clientDirectives,
    routes,
    serverIslandNameMap,
    key
  };
}

const manifest = deserializeManifest({"hrefRoot":"file:///Users/jin/Developments/work/ea/AdminLTE/","cacheDir":"file:///Users/jin/Developments/work/ea/AdminLTE/node_modules/.astro/","outDir":"file:///Users/jin/Developments/work/ea/AdminLTE/dist/","srcDir":"file:///Users/jin/Developments/work/ea/AdminLTE/src/","publicDir":"file:///Users/jin/Developments/work/ea/AdminLTE/public/","buildClientDir":"file:///Users/jin/Developments/work/ea/AdminLTE/dist/client/","buildServerDir":"file:///Users/jin/Developments/work/ea/AdminLTE/dist/server/","adapterName":"@astrojs/node","routes":[{"file":"","links":[],"scripts":[],"styles":[],"routeData":{"type":"page","component":"_server-islands.astro","params":["name"],"segments":[[{"content":"_server-islands","dynamic":false,"spread":false}],[{"content":"name","dynamic":true,"spread":false}]],"pattern":"^\\/_server-islands\\/([^/]+?)\\/?$","prerender":false,"isIndex":false,"fallbackRoutes":[],"route":"/_server-islands/[name]","origin":"internal","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"type":"endpoint","isIndex":false,"route":"/_image","pattern":"^\\/_image\\/?$","segments":[[{"content":"_image","dynamic":false,"spread":false}]],"params":[],"component":"node_modules/astro/dist/assets/endpoint/node.js","pathname":"/_image","prerender":false,"fallbackRoutes":[],"origin":"internal","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"route":"/ad-management","isIndex":true,"type":"page","pattern":"^\\/ad-management\\/?$","segments":[[{"content":"ad-management","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/ad-management/index.astro","pathname":"/ad-management","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"route":"/category-management","isIndex":true,"type":"page","pattern":"^\\/category-management\\/?$","segments":[[{"content":"category-management","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/category-management/index.astro","pathname":"/category-management","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"route":"/dashboard","isIndex":true,"type":"page","pattern":"^\\/dashboard\\/?$","segments":[[{"content":"dashboard","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/dashboard/index.astro","pathname":"/dashboard","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"route":"/order-management","isIndex":true,"type":"page","pattern":"^\\/order-management\\/?$","segments":[[{"content":"order-management","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/order-management/index.astro","pathname":"/order-management","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"route":"/product-management","isIndex":true,"type":"page","pattern":"^\\/product-management\\/?$","segments":[[{"content":"product-management","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/product-management/index.astro","pathname":"/product-management","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"route":"/user-management","isIndex":true,"type":"page","pattern":"^\\/user-management\\/?$","segments":[[{"content":"user-management","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/user-management/index.astro","pathname":"/user-management","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"td[data-astro-cid-x44e7sok],td[data-astro-cid-user7c46],td[data-astro-cid-fea7qj55]{max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}\n"}],"routeData":{"route":"/","isIndex":true,"type":"page","pattern":"^\\/$","segments":[],"params":[],"component":"src/pages/index.astro","pathname":"/","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}}],"base":"/","trailingSlash":"ignore","compressHTML":true,"assetsPrefix":"/","componentMetadata":[["/Users/jin/Developments/work/ea/AdminLTE/src/pages/ad-management/index.astro",{"propagation":"none","containsHead":true}],["/Users/jin/Developments/work/ea/AdminLTE/src/pages/category-management/index.astro",{"propagation":"none","containsHead":true}],["/Users/jin/Developments/work/ea/AdminLTE/src/pages/dashboard/index.astro",{"propagation":"none","containsHead":true}],["/Users/jin/Developments/work/ea/AdminLTE/src/pages/order-management/index.astro",{"propagation":"none","containsHead":true}],["/Users/jin/Developments/work/ea/AdminLTE/src/pages/product-management/index.astro",{"propagation":"none","containsHead":true}],["/Users/jin/Developments/work/ea/AdminLTE/src/pages/user-management/index.astro",{"propagation":"none","containsHead":true}],["/Users/jin/Developments/work/ea/AdminLTE/src/pages/index.astro",{"propagation":"none","containsHead":true}]],"renderers":[],"clientDirectives":[["idle","(()=>{var l=(n,t)=>{let i=async()=>{await(await n())()},e=typeof t.value==\"object\"?t.value:void 0,s={timeout:e==null?void 0:e.timeout};\"requestIdleCallback\"in window?window.requestIdleCallback(i,s):setTimeout(i,s.timeout||200)};(self.Astro||(self.Astro={})).idle=l;window.dispatchEvent(new Event(\"astro:idle\"));})();"],["load","(()=>{var e=async t=>{await(await t())()};(self.Astro||(self.Astro={})).load=e;window.dispatchEvent(new Event(\"astro:load\"));})();"],["media","(()=>{var n=(a,t)=>{let i=async()=>{await(await a())()};if(t.value){let e=matchMedia(t.value);e.matches?i():e.addEventListener(\"change\",i,{once:!0})}};(self.Astro||(self.Astro={})).media=n;window.dispatchEvent(new Event(\"astro:media\"));})();"],["only","(()=>{var e=async t=>{await(await t())()};(self.Astro||(self.Astro={})).only=e;window.dispatchEvent(new Event(\"astro:only\"));})();"],["visible","(()=>{var a=(s,i,o)=>{let r=async()=>{await(await s())()},t=typeof i.value==\"object\"?i.value:void 0,c={rootMargin:t==null?void 0:t.rootMargin},n=new IntersectionObserver(e=>{for(let l of e)if(l.isIntersecting){n.disconnect(),r();break}},c);for(let e of o.children)n.observe(e)};(self.Astro||(self.Astro={})).visible=a;window.dispatchEvent(new Event(\"astro:visible\"));})();"]],"entryModules":{"\u0000noop-middleware":"_noop-middleware.mjs","\u0000@astro-page:src/pages/ad-management/index@_@astro":"pages/ad-management.astro.mjs","\u0000@astro-page:src/pages/category-management/index@_@astro":"pages/category-management.astro.mjs","\u0000@astro-page:src/pages/dashboard/index@_@astro":"pages/dashboard.astro.mjs","\u0000@astro-page:src/pages/order-management/index@_@astro":"pages/order-management.astro.mjs","\u0000@astro-page:src/pages/product-management/index@_@astro":"pages/product-management.astro.mjs","\u0000@astro-page:src/pages/user-management/index@_@astro":"pages/user-management.astro.mjs","\u0000@astro-page:src/pages/index@_@astro":"pages/index.astro.mjs","\u0000@astrojs-ssr-virtual-entry":"entry.mjs","\u0000@astro-renderers":"renderers.mjs","\u0000@astro-page:node_modules/astro/dist/assets/endpoint/node@_@js":"pages/_image.astro.mjs","\u0000noop-actions":"_noop-actions.mjs","\u0000@astrojs-ssr-adapter":"_@astrojs-ssr-adapter.mjs","\u0000@astrojs-manifest":"manifest_BXLEzdJ3.mjs","/Users/jin/Developments/work/ea/AdminLTE/node_modules/astro/dist/assets/services/sharp.js":"chunks/sharp_CyPB8tst.mjs","/Users/jin/Developments/work/ea/AdminLTE/src/pages/order-management/index.astro?astro&type=script&index=0&lang.ts":"assets/index.astro_astro_type_script_index_0_lang.DZT1nSej.js","/Users/jin/Developments/work/ea/AdminLTE/src/html/components/common/_pagination.astro?astro&type=script&index=0&lang.ts":"assets/_pagination.astro_astro_type_script_index_0_lang.k2FZ6d8A.js","/Users/jin/Developments/work/ea/AdminLTE/src/pages/product-management/index.astro?astro&type=script&index=0&lang.ts":"assets/index.astro_astro_type_script_index_0_lang.3nhwC7EI.js","astro:scripts/before-hydration.js":""},"inlinedScripts":[["/Users/jin/Developments/work/ea/AdminLTE/src/html/components/common/_pagination.astro?astro&type=script&index=0&lang.ts","window.initPagination=b=>{const{paginationId:f,tableId:h,dataArray:u,itemsPerPage:C,totalPages:i,renderItemCallback:L,afterPageChangeCallback:E}=b,n=document.getElementById(f),k=document.getElementById(h);if(!n||!k){console.error(`Pagination elements not found: pagination=${f}, table=${h}`);return}let l=1;const g=s=>{s<1&&(s=1),s>i&&(s=i),l=s;const c=k.querySelector(\"tbody\");if(!c){console.error(`No tbody found in table with id ${h}`);return}c.innerHTML=\"\";const d=(l-1)*C,p=Math.min(d+C,u.length);for(let r=d;r<p;r++){const m=u[r];if(L){const e=L(m,r);c.appendChild(e)}}N(),E&&E()},N=()=>{n.innerHTML=\"\";const s=document.createElement(\"li\");s.className=`page-item ${l===1?\"disabled\":\"\"}`;const c=document.createElement(\"a\");c.className=\"page-link\",c.href=\"#\",c.dataset.page=\"prev\",c.innerHTML=\"&laquo;\",s.appendChild(c),n.appendChild(s);let d=Math.max(1,l-2),p=Math.min(i,d+4);if(p-d<4&&i>4&&(d=Math.max(1,p-4)),d>1){const e=document.createElement(\"li\");e.className=\"page-item\";const t=document.createElement(\"a\");if(t.className=\"page-link\",t.href=\"#\",t.dataset.page=\"1\",t.textContent=\"1\",e.appendChild(t),n.appendChild(e),d>2){const a=document.createElement(\"li\");a.className=\"page-item disabled\";const o=document.createElement(\"a\");o.className=\"page-link\",o.href=\"#\",o.textContent=\"...\",a.appendChild(o),n.appendChild(a)}}for(let e=d;e<=p;e++){const t=document.createElement(\"li\");t.className=`page-item ${e===l?\"active\":\"\"}`;const a=document.createElement(\"a\");a.className=\"page-link\",a.href=\"#\",a.dataset.page=e,a.textContent=e,t.appendChild(a),n.appendChild(t)}if(p<i){if(p<i-1){const a=document.createElement(\"li\");a.className=\"page-item disabled\";const o=document.createElement(\"a\");o.className=\"page-link\",o.href=\"#\",o.textContent=\"...\",a.appendChild(o),n.appendChild(a)}const e=document.createElement(\"li\");e.className=\"page-item\";const t=document.createElement(\"a\");t.className=\"page-link\",t.href=\"#\",t.dataset.page=i,t.textContent=i,e.appendChild(t),n.appendChild(e)}const r=document.createElement(\"li\");r.className=`page-item ${l===i?\"disabled\":\"\"}`;const m=document.createElement(\"a\");m.className=\"page-link\",m.href=\"#\",m.dataset.page=\"next\",m.innerHTML=\"&raquo;\",r.appendChild(m),n.appendChild(r),n.querySelectorAll(\".page-link\").forEach(e=>{e.addEventListener(\"click\",function(t){if(t.preventDefault(),this.parentElement.classList.contains(\"disabled\"))return;const a=this.dataset.page;g(a===\"prev\"?l-1:a===\"next\"?l+1:parseInt(a))})})};return g(1),{changePage:g,updatePagination:N,getCurrentPage:()=>l}};"]],"assets":["/assets/index.astro_astro_type_script_index_0_lang.3nhwC7EI.js","/assets/index.astro_astro_type_script_index_0_lang.DZT1nSej.js","/css/adminlte.min.css"],"buildFormat":"directory","checkOrigin":true,"serverIslandNameMap":[],"key":"hkc4p68wVw2wi4jdm/97jWU74om//OjVTXwlzd8SSSg="});
if (manifest.sessionConfig) manifest.sessionConfig.driverModule = null;

export { manifest };
