import {
  e as createComponent,
  r as renderTemplate,
  i as defineScriptVars,
  j as renderComponent,
  g as addAttribute,
  k as renderHead,
  h as createAstro,
} from '../chunks/astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import { $ as $$Scripts, a as $$Head } from '../chunks/_scripts_P5Q6xZAb.mjs';
import { $ as $$Footer, a as $$Sidenav, b as $$Topbar } from '../chunks/_sidenav_BYv4xoan.mjs';
import { $ as $$Pagination } from '../chunks/_pagination_Cm6O4Y_1.mjs';
/* empty css                                      */
export { renderers } from '../renderers.mjs';

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) => __freeze(__defProp(cooked, 'raw', { value: __freeze(raw) }));
var _a;
const $$Astro = createAstro();
const prerender = false;
const $$Index = createComponent(
  async ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Index;
    const url = new URL(Astro2.request.url);
    let addSuccess = url.searchParams.get('addSuccess') === 'true';
    let addError = url.searchParams.get('addError');
    let deleteSuccess = url.searchParams.get('deleteSuccess') === 'true';
    let deleteError = url.searchParams.get('deleteError');
    let deletedAd = null;
    const deletedAdStr = url.searchParams.get('deletedAd');
    if (deletedAdStr) {
      try {
        deletedAd = JSON.parse(decodeURIComponent(deletedAdStr));
      } catch (error) {
        console.error('Silinmi\u015F reklam\u0131 ayr\u0131\u015Ft\u0131r\u0131rken hata:', error);
      }
    }
    if (Astro2.request.method === 'POST') {
      try {
        const formData = await Astro2.request.formData();
        const action = formData.get('action');
        if (action === 'add-ad') {
          const payload = {
            ad_url: formData.get('ad_url'),
            video_list_order: parseInt(formData.get('video_list_order')),
            ad_video_points: parseInt(formData.get('ad_video_points')),
          };
          console.log('Reklam ekleme y\xFCk\xFC:', payload);
          const addRes = await fetch('http://192.168.9.12:8000/api/v1/admin/advertisements', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json',
            },
            body: JSON.stringify(payload),
          });
          if (addRes.ok) {
            console.log('Reklam ba\u015Far\u0131yla eklendi');
            return Astro2.redirect('/ad-management?addSuccess=true');
          } else {
            const errorMsg = `Durumla ba\u015Far\u0131s\u0131z: ${addRes.status}`;
            console.error('Reklam ekleme ba\u015Far\u0131s\u0131z:', errorMsg);
            return Astro2.redirect(`/ad-management?addError=${encodeURIComponent(errorMsg)}`);
          }
        } else if (action === 'delete-ad') {
          const adId = formData.get('adId');
          console.log(`Reklam siliniyor, ID: ${adId}`);
          const deleteRes = await fetch(
            `http://192.168.9.12:8000/api/v1/admin/advertisements/${adId}`,
            {
              method: 'DELETE',
            },
          );
          if (deleteRes.ok) {
            const responseData = await deleteRes.json();
            console.log('Reklam ba\u015Far\u0131yla silindi:', responseData.deleted_ad);
            return Astro2.redirect(
              `/ad-management?deleteSuccess=true&deletedAd=${encodeURIComponent(JSON.stringify(responseData.deleted_ad || { id: adId }))}`,
            );
          } else {
            const errorMsg = `Durumla ba\u015Far\u0131s\u0131z: ${deleteRes.status}`;
            console.error('Reklam silme ba\u015Far\u0131s\u0131z:', errorMsg);
            return Astro2.redirect(`/ad-management?deleteError=${encodeURIComponent(errorMsg)}`);
          }
        }
      } catch (error) {
        const errorMsg = error.message || 'Bilinmeyen hata';
        console.error('\u0130stek i\u015Flenirken hata:', error);
        if (Astro2.request.formData && typeof Astro2.request.formData === 'function') {
          const formData = await Astro2.request.formData();
          const action = formData.get('action');
          if (action === 'add-ad') {
            return Astro2.redirect(`/ad-management?addError=${encodeURIComponent(errorMsg)}`);
          } else if (action === 'delete-ad') {
            return Astro2.redirect(`/ad-management?deleteError=${encodeURIComponent(errorMsg)}`);
          }
        }
        return Astro2.redirect(`/ad-management?error=${encodeURIComponent(errorMsg)}`);
      }
    }
    let advertisements = [];
    try {
      const response = await fetch('http://192.168.9.12:8000/api/v1/advertisements');
      advertisements = await response.json();
      console.log(
        'Sunucu taraf\u0131 kayd\u0131 - reklamlar al\u0131nd\u0131:',
        advertisements.length,
      );
    } catch (error) {
      console.error('Reklamlar\u0131 al\u0131rken hata:', error);
    }
    const adsPerPage = 10;
    const totalAds = advertisements.length;
    const totalPages = Math.ceil(totalAds / adsPerPage);
    const currentPage = 1;
    const title = 'AdminLTE | Dashboard v3';
    const path = '../../../dist';
    const mainPage = 'dashboard';
    const page = 'ad-management';
    return renderTemplate(
      _a ||
        (_a = __template(
          [
            '<html lang="tr" data-astro-cid-x44e7sok> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary" data-astro-cid-x44e7sok> <div class="app-wrapper" data-astro-cid-x44e7sok> ',
            ' ',
            ' <main class="app-main" data-astro-cid-x44e7sok> <div class="app-content-header" data-astro-cid-x44e7sok> <div class="container-fluid" data-astro-cid-x44e7sok> <div class="row align-items-center" data-astro-cid-x44e7sok> <div class="col-sm-6" data-astro-cid-x44e7sok> <h3 class="mb-0" data-astro-cid-x44e7sok>Reklam Y\xF6netimi</h3> </div> </div> <div class="row" data-astro-cid-x44e7sok> <div class="col-sm-12" data-astro-cid-x44e7sok> <ol class="breadcrumb float-sm-end" data-astro-cid-x44e7sok> <li class="breadcrumb-item" data-astro-cid-x44e7sok><a href="#" data-astro-cid-x44e7sok>Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page" data-astro-cid-x44e7sok>Reklam Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content" data-astro-cid-x44e7sok> <div class="container-fluid" data-astro-cid-x44e7sok> ',
            ' ',
            ' ',
            ' ',
            ` <div class="row" data-astro-cid-x44e7sok> <div class="col-12" data-astro-cid-x44e7sok> <div class="card mb-4" data-astro-cid-x44e7sok> <div class="card-header" data-astro-cid-x44e7sok> <div class="row align-items-center" data-astro-cid-x44e7sok> <div class="col" data-astro-cid-x44e7sok> <h3 class="card-title mb-0" data-astro-cid-x44e7sok>Reklamlar</h3> </div> <div class="col-auto" data-astro-cid-x44e7sok> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addAdModal" data-astro-cid-x44e7sok>
Reklam Ekle
</button> </div> </div> </div> <div class="card-body p-0" data-astro-cid-x44e7sok> <table class="table table-striped" id="adsTable" data-astro-cid-x44e7sok> <thead data-astro-cid-x44e7sok> <tr data-astro-cid-x44e7sok> <th style="width: 10px" data-astro-cid-x44e7sok>#</th> <th data-astro-cid-x44e7sok>Reklam URL'si</th> <th data-astro-cid-x44e7sok>S\u0131ra</th> <th data-astro-cid-x44e7sok>Puanlar</th> <th data-astro-cid-x44e7sok>\u0130\u015Flem</th> </tr> </thead> <tbody data-astro-cid-x44e7sok> `,
            ' </tbody> </table> </div> <div class="card-footer clearfix" data-astro-cid-x44e7sok> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ` <div class="modal fade" id="addAdModal" tabindex="-1" aria-labelledby="addAdModalLabel" aria-hidden="true" data-astro-cid-x44e7sok> <div class="modal-dialog" data-astro-cid-x44e7sok> <div class="modal-content" data-astro-cid-x44e7sok> <form id="addAdForm" method="POST" data-astro-cid-x44e7sok> <input type="hidden" name="action" value="add-ad" data-astro-cid-x44e7sok> <div class="modal-header" data-astro-cid-x44e7sok> <h5 class="modal-title" id="addAdModalLabel" data-astro-cid-x44e7sok>Reklam Ekle</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat" data-astro-cid-x44e7sok></button> </div> <div class="modal-body" data-astro-cid-x44e7sok> <div class="mb-3" data-astro-cid-x44e7sok> <label for="ad_url" class="form-label" data-astro-cid-x44e7sok>Reklam URL'si</label> <input type="url" class="form-control" id="ad_url" name="ad_url" required data-astro-cid-x44e7sok> </div> <div class="mb-3" data-astro-cid-x44e7sok> <label for="video_list_order" class="form-label" data-astro-cid-x44e7sok>S\u0131ra</label> <input type="number" class="form-control" id="video_list_order" name="video_list_order" min="1" required data-astro-cid-x44e7sok> </div> <div class="mb-3" data-astro-cid-x44e7sok> <label for="ad_video_points" class="form-label" data-astro-cid-x44e7sok>Puanlar</label> <input type="number" class="form-control" id="ad_video_points" name="ad_video_points" min="1" required data-astro-cid-x44e7sok> </div> </div> <div class="modal-footer" data-astro-cid-x44e7sok> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-astro-cid-x44e7sok>Kapat</button> <button type="submit" class="btn btn-primary" data-astro-cid-x44e7sok>Reklam\u0131 Kaydet</button> </div> </form> </div> </div> </div> <form id="deleteAdForm" method="POST" style="display: none;" data-astro-cid-x44e7sok> <input type="hidden" name="action" value="delete-ad" data-astro-cid-x44e7sok> <input type="hidden" name="adId" id="deleteAdId" data-astro-cid-x44e7sok> </form> <script>(function(){`,
            `
      document.addEventListener('DOMContentLoaded', () => {
        try {
          const addAdModal = document.getElementById('addAdModal');
          
          if (window.location.search) {
            const cleanUrl = window.location.pathname;
            window.history.replaceState({}, document.title, cleanUrl);
          }
          
          if (addSuccess) {
            const modal = bootstrap.Modal.getInstance(addAdModal);
            if (modal) {
              modal.hide();
            }
          }
          
          const deleteAdForm = document.getElementById('deleteAdForm');
          const deleteAdIdInput = document.getElementById('deleteAdId');
          
          const advertisementsData = JSON.parse(advertisements);
          
          window.initPagination({
            paginationId: 'pagination',
            tableId: 'adsTable',
            dataArray: advertisementsData,
            itemsPerPage: adsPerPage,
            totalPages: totalPages,
            renderItemCallback: (ad, index) => {
              const row = document.createElement('tr');
              row.className = 'align-middle';
              
              row.innerHTML = \`
                <td>\${index + 1}.</td>
                <td>
                  <a href="\${ad.ad_url}" target="_blank" rel="noopener noreferrer">
                    \${ad.ad_url.length > 50 ? ad.ad_url.substring(0, 50) + '...' : ad.ad_url}
                  </a>
                </td>
                <td>\${ad.video_list_order}</td>
                <td>\${ad.ad_video_points}</td>
                <td>
                  <a href="#" class="text-secondary me-2 delete-ad" data-ad-id="\${ad.id}" data-ad-url="\${ad.ad_url}">
                    <i class="bi bi-eraser"></i>
                  </a>
                </td>
              \`;
              
              return row;
            },
            afterPageChangeCallback: () => {
              document.querySelectorAll('.delete-ad').forEach(btn => {
                btn.addEventListener('click', function(e) {
                  e.preventDefault();
                  const adId = this.getAttribute('data-ad-id');
                  const adUrl = this.getAttribute('data-ad-url');
                  
                  if (confirm(\`"\${adUrl}" URL'sine sahip reklam\u0131 silmek istedi\u011Finize emin misiniz?\`)) {
                    deleteAdIdInput.value = adId;
                    deleteAdForm.submit();
                  }
                });
              });
            }
          });
          
          document.querySelectorAll('.delete-ad').forEach(btn => {
            btn.addEventListener('click', function(e) {
              e.preventDefault();
              const adId = this.getAttribute('data-ad-id');
              const adUrl = this.getAttribute('data-ad-url');
              
              if (confirm(\`"\${adUrl}" URL'sine sahip reklam\u0131 silmek istedi\u011Finize emin misiniz?\`)) {
                deleteAdIdInput.value = adId;
                deleteAdForm.submit();
              }
            });
          });
          
        } catch (error) {
          console.error('Sayfa numaraland\u0131rmas\u0131n\u0131 ba\u015Flat\u0131rken hata:', error);
        }
      });
    })();<\/script> </body> </html>`,
          ],
          [
            '<html lang="tr" data-astro-cid-x44e7sok> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary" data-astro-cid-x44e7sok> <div class="app-wrapper" data-astro-cid-x44e7sok> ',
            ' ',
            ' <main class="app-main" data-astro-cid-x44e7sok> <div class="app-content-header" data-astro-cid-x44e7sok> <div class="container-fluid" data-astro-cid-x44e7sok> <div class="row align-items-center" data-astro-cid-x44e7sok> <div class="col-sm-6" data-astro-cid-x44e7sok> <h3 class="mb-0" data-astro-cid-x44e7sok>Reklam Y\xF6netimi</h3> </div> </div> <div class="row" data-astro-cid-x44e7sok> <div class="col-sm-12" data-astro-cid-x44e7sok> <ol class="breadcrumb float-sm-end" data-astro-cid-x44e7sok> <li class="breadcrumb-item" data-astro-cid-x44e7sok><a href="#" data-astro-cid-x44e7sok>Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page" data-astro-cid-x44e7sok>Reklam Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content" data-astro-cid-x44e7sok> <div class="container-fluid" data-astro-cid-x44e7sok> ',
            ' ',
            ' ',
            ' ',
            ` <div class="row" data-astro-cid-x44e7sok> <div class="col-12" data-astro-cid-x44e7sok> <div class="card mb-4" data-astro-cid-x44e7sok> <div class="card-header" data-astro-cid-x44e7sok> <div class="row align-items-center" data-astro-cid-x44e7sok> <div class="col" data-astro-cid-x44e7sok> <h3 class="card-title mb-0" data-astro-cid-x44e7sok>Reklamlar</h3> </div> <div class="col-auto" data-astro-cid-x44e7sok> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addAdModal" data-astro-cid-x44e7sok>
Reklam Ekle
</button> </div> </div> </div> <div class="card-body p-0" data-astro-cid-x44e7sok> <table class="table table-striped" id="adsTable" data-astro-cid-x44e7sok> <thead data-astro-cid-x44e7sok> <tr data-astro-cid-x44e7sok> <th style="width: 10px" data-astro-cid-x44e7sok>#</th> <th data-astro-cid-x44e7sok>Reklam URL'si</th> <th data-astro-cid-x44e7sok>S\u0131ra</th> <th data-astro-cid-x44e7sok>Puanlar</th> <th data-astro-cid-x44e7sok>\u0130\u015Flem</th> </tr> </thead> <tbody data-astro-cid-x44e7sok> `,
            ' </tbody> </table> </div> <div class="card-footer clearfix" data-astro-cid-x44e7sok> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ` <div class="modal fade" id="addAdModal" tabindex="-1" aria-labelledby="addAdModalLabel" aria-hidden="true" data-astro-cid-x44e7sok> <div class="modal-dialog" data-astro-cid-x44e7sok> <div class="modal-content" data-astro-cid-x44e7sok> <form id="addAdForm" method="POST" data-astro-cid-x44e7sok> <input type="hidden" name="action" value="add-ad" data-astro-cid-x44e7sok> <div class="modal-header" data-astro-cid-x44e7sok> <h5 class="modal-title" id="addAdModalLabel" data-astro-cid-x44e7sok>Reklam Ekle</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat" data-astro-cid-x44e7sok></button> </div> <div class="modal-body" data-astro-cid-x44e7sok> <div class="mb-3" data-astro-cid-x44e7sok> <label for="ad_url" class="form-label" data-astro-cid-x44e7sok>Reklam URL'si</label> <input type="url" class="form-control" id="ad_url" name="ad_url" required data-astro-cid-x44e7sok> </div> <div class="mb-3" data-astro-cid-x44e7sok> <label for="video_list_order" class="form-label" data-astro-cid-x44e7sok>S\u0131ra</label> <input type="number" class="form-control" id="video_list_order" name="video_list_order" min="1" required data-astro-cid-x44e7sok> </div> <div class="mb-3" data-astro-cid-x44e7sok> <label for="ad_video_points" class="form-label" data-astro-cid-x44e7sok>Puanlar</label> <input type="number" class="form-control" id="ad_video_points" name="ad_video_points" min="1" required data-astro-cid-x44e7sok> </div> </div> <div class="modal-footer" data-astro-cid-x44e7sok> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-astro-cid-x44e7sok>Kapat</button> <button type="submit" class="btn btn-primary" data-astro-cid-x44e7sok>Reklam\u0131 Kaydet</button> </div> </form> </div> </div> </div> <form id="deleteAdForm" method="POST" style="display: none;" data-astro-cid-x44e7sok> <input type="hidden" name="action" value="delete-ad" data-astro-cid-x44e7sok> <input type="hidden" name="adId" id="deleteAdId" data-astro-cid-x44e7sok> </form> <script>(function(){`,
            `
      document.addEventListener('DOMContentLoaded', () => {
        try {
          const addAdModal = document.getElementById('addAdModal');
          
          if (window.location.search) {
            const cleanUrl = window.location.pathname;
            window.history.replaceState({}, document.title, cleanUrl);
          }
          
          if (addSuccess) {
            const modal = bootstrap.Modal.getInstance(addAdModal);
            if (modal) {
              modal.hide();
            }
          }
          
          const deleteAdForm = document.getElementById('deleteAdForm');
          const deleteAdIdInput = document.getElementById('deleteAdId');
          
          const advertisementsData = JSON.parse(advertisements);
          
          window.initPagination({
            paginationId: 'pagination',
            tableId: 'adsTable',
            dataArray: advertisementsData,
            itemsPerPage: adsPerPage,
            totalPages: totalPages,
            renderItemCallback: (ad, index) => {
              const row = document.createElement('tr');
              row.className = 'align-middle';
              
              row.innerHTML = \\\`
                <td>\\\${index + 1}.</td>
                <td>
                  <a href="\\\${ad.ad_url}" target="_blank" rel="noopener noreferrer">
                    \\\${ad.ad_url.length > 50 ? ad.ad_url.substring(0, 50) + '...' : ad.ad_url}
                  </a>
                </td>
                <td>\\\${ad.video_list_order}</td>
                <td>\\\${ad.ad_video_points}</td>
                <td>
                  <a href="#" class="text-secondary me-2 delete-ad" data-ad-id="\\\${ad.id}" data-ad-url="\\\${ad.ad_url}">
                    <i class="bi bi-eraser"></i>
                  </a>
                </td>
              \\\`;
              
              return row;
            },
            afterPageChangeCallback: () => {
              document.querySelectorAll('.delete-ad').forEach(btn => {
                btn.addEventListener('click', function(e) {
                  e.preventDefault();
                  const adId = this.getAttribute('data-ad-id');
                  const adUrl = this.getAttribute('data-ad-url');
                  
                  if (confirm(\\\`"\\\${adUrl}" URL'sine sahip reklam\u0131 silmek istedi\u011Finize emin misiniz?\\\`)) {
                    deleteAdIdInput.value = adId;
                    deleteAdForm.submit();
                  }
                });
              });
            }
          });
          
          document.querySelectorAll('.delete-ad').forEach(btn => {
            btn.addEventListener('click', function(e) {
              e.preventDefault();
              const adId = this.getAttribute('data-ad-id');
              const adUrl = this.getAttribute('data-ad-url');
              
              if (confirm(\\\`"\\\${adUrl}" URL'sine sahip reklam\u0131 silmek istedi\u011Finize emin misiniz?\\\`)) {
                deleteAdIdInput.value = adId;
                deleteAdForm.submit();
              }
            });
          });
          
        } catch (error) {
          console.error('Sayfa numaraland\u0131rmas\u0131n\u0131 ba\u015Flat\u0131rken hata:', error);
        }
      });
    })();<\/script> </body> </html>`,
          ],
        )),
      renderComponent($$result, 'Head', $$Head, {
        title: title,
        path: path,
        'data-astro-cid-x44e7sok': true,
      }),
      renderHead(),
      renderComponent($$result, 'Topbar', $$Topbar, {
        path: path,
        'data-astro-cid-x44e7sok': true,
      }),
      renderComponent($$result, 'Sidenav', $$Sidenav, {
        path: path,
        mainPage: mainPage,
        page: page,
        'data-astro-cid-x44e7sok': true,
      }),
      addSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert" data-astro-cid-x44e7sok>
Reklam başarıyla eklendi!
<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-x44e7sok></button> </div>`,
      addError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert" data-astro-cid-x44e7sok>
Reklam eklerken hata: ${addError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-x44e7sok></button> </div>`,
      deleteSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert" data-astro-cid-x44e7sok>
Reklam başarıyla silindi! ${deletedAd ? `Silinen reklam URL'si: ${deletedAd.ad_url}` : ''} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-x44e7sok></button> </div>`,
      deleteError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert" data-astro-cid-x44e7sok>
Reklam silerken hata: ${deleteError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-x44e7sok></button> </div>`,
      advertisements
        .slice(0, adsPerPage)
        .map(
          (ad, index) =>
            renderTemplate`<tr class="align-middle" data-astro-cid-x44e7sok> <td data-astro-cid-x44e7sok>${index + 1}.</td> <td data-astro-cid-x44e7sok> <a${addAttribute(ad.ad_url, 'href')} target="_blank" rel="noopener noreferrer" data-astro-cid-x44e7sok> ${ad.ad_url.length > 50 ? `${ad.ad_url.substring(0, 50)}...` : ad.ad_url} </a> </td> <td data-astro-cid-x44e7sok>${ad.video_list_order}</td> <td data-astro-cid-x44e7sok>${ad.ad_video_points}</td> <td data-astro-cid-x44e7sok> <a href="#" class="text-secondary me-2 delete-ad"${addAttribute(ad.id, 'data-ad-id')}${addAttribute(ad.ad_url, 'data-ad-url')} data-astro-cid-x44e7sok> <i class="bi bi-eraser" data-astro-cid-x44e7sok></i> </a> </td> </tr>`,
        ),
      renderComponent($$result, 'Pagination', $$Pagination, {
        id: 'pagination',
        currentPage: currentPage,
        totalPages: totalPages,
        size: 'sm',
        'data-astro-cid-x44e7sok': true,
      }),
      renderComponent($$result, 'Footer', $$Footer, { 'data-astro-cid-x44e7sok': true }),
      renderComponent($$result, 'Scripts', $$Scripts, {
        path: path,
        'data-astro-cid-x44e7sok': true,
      }),
      defineScriptVars({
        advertisements: JSON.stringify(advertisements),
        adsPerPage,
        totalPages,
        addSuccess,
        deleteSuccess,
        deletedAd,
      }),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/pages/ad-management/index.astro',
  undefined,
);

const $$file = '/Users/jin/Developments/work/ea/AdminLTE/src/pages/ad-management/index.astro';
const $$url = '/ad-management';

const _page = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      default: $$Index,
      file: $$file,
      prerender,
      url: $$url,
    },
    Symbol.toStringTag,
    { value: 'Module' },
  ),
);

const page = () => _page;

export { page };
