import {
  e as createComponent,
  r as renderTemplate,
  i as defineScriptVars,
  j as renderComponent,
  g as addAttribute,
  k as renderHead,
  h as createAstro,
} from '../chunks/astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import { $ as $$Scripts, a as $$Head } from '../chunks/_scripts_P5Q6xZAb.mjs';
import { $ as $$Footer, a as $$Sidenav, b as $$Topbar } from '../chunks/_sidenav_BYv4xoan.mjs';
import { $ as $$Pagination } from '../chunks/_pagination_Cm6O4Y_1.mjs';
/* empty css                                            */
export { renderers } from '../renderers.mjs';

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) => __freeze(__defProp(cooked, 'raw', { value: __freeze(raw) }));
var _a;
const $$Astro = createAstro();
const prerender = false;
const $$Index = createComponent(
  async ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Index;
    const url = new URL(Astro2.request.url);
    let addSuccess = url.searchParams.get('addSuccess') === 'true';
    let addError = url.searchParams.get('addError');
    let deleteSuccess = url.searchParams.get('deleteSuccess') === 'true';
    let deleteError = url.searchParams.get('deleteError');
    let deletedCategory = null;
    const deletedCategoryStr = url.searchParams.get('deletedCategory');
    if (deletedCategoryStr) {
      try {
        deletedCategory = JSON.parse(decodeURIComponent(deletedCategoryStr));
      } catch (error) {
        console.error('Silinen kategori hatas\u0131:', error);
      }
    }
    if (Astro2.request.method === 'POST') {
      try {
        const formData = await Astro2.request.formData();
        const action = formData.get('action');
        if (action === 'add-category') {
          const payload = {
            code: formData.get('code'),
            name: formData.get('name'),
            description: formData.get('description'),
          };
          console.log('Kategori ekleme y\xFCk\xFC:', payload);
          const addRes = await fetch('http://192.168.9.12:8000/api/v1/categories', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json',
            },
            body: JSON.stringify(payload),
          });
          if (addRes.ok) {
            console.log('Kategori ba\u015Far\u0131yla eklendi');
            return Astro2.redirect('/category-management?addSuccess=true');
          } else {
            const errorMsg = `Ba\u015Far\u0131s\u0131z, durum: ${addRes.status}`;
            console.error('Kategori ekleme ba\u015Far\u0131s\u0131z:', errorMsg);
            return Astro2.redirect(`/category-management?addError=${encodeURIComponent(errorMsg)}`);
          }
        } else if (action === 'delete-category') {
          const categoryId = formData.get('categoryId');
          console.log(`Kategori siliniyor, ID: ${categoryId}`);
          const deleteRes = await fetch(
            `http://192.168.9.12:8000/api/v1/admin/product-categories/${categoryId}`,
            {
              method: 'DELETE',
            },
          );
          if (deleteRes.ok) {
            const responseData = await deleteRes.json();
            console.log('Kategori ba\u015Far\u0131yla silindi:', responseData.deleted_category);
            return Astro2.redirect(
              `/category-management?deleteSuccess=true&deletedCategory=${encodeURIComponent(JSON.stringify(responseData.deleted_category))}`,
            );
          } else {
            const errorMsg = `Ba\u015Far\u0131s\u0131z, durum: ${deleteRes.status}`;
            console.error('Kategori silme ba\u015Far\u0131s\u0131z:', errorMsg);
            return Astro2.redirect(
              `/category-management?deleteError=${encodeURIComponent(errorMsg)}`,
            );
          }
        }
      } catch (error) {
        console.error('\u0130stek i\u015Fleme hatas\u0131:', error);
        const formData = await Astro2.request.formData();
        const action = formData.get('action');
        if (action === 'add-category') {
          return Astro2.redirect(
            `/category-management?addError=${encodeURIComponent(error.message || 'Bilinmeyen hata')}`,
          );
        } else if (action === 'delete-category') {
          return Astro2.redirect(
            `/category-management?deleteError=${encodeURIComponent(error.message || 'Bilinmeyen hata')}`,
          );
        }
        return Astro2.redirect(
          `/category-management?error=${encodeURIComponent(error.message || 'Bilinmeyen hata')}`,
        );
      }
    }
    let categories = [];
    try {
      const response = await fetch('http://192.168.9.12:8000/api/v1/categories');
      categories = await response.json();
    } catch (error) {
      console.error('Kategorileri alma hatas\u0131:', error);
    }
    const categoriesPerPage = 10;
    const totalCategories = categories.length;
    const totalPages = Math.ceil(totalCategories / categoriesPerPage);
    const currentPage = 1;
    const title = 'AdminLTE | Dashboard v3';
    const path = '../../../dist';
    const mainPage = 'dashboard';
    const page = 'category-management';
    return renderTemplate(
      _a ||
        (_a = __template(
          [
            '<html lang="tr" data-astro-cid-user7c46> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary" data-astro-cid-user7c46> <div class="app-wrapper" data-astro-cid-user7c46> ',
            ' ',
            ' <main class="app-main" data-astro-cid-user7c46> <div class="app-content-header" data-astro-cid-user7c46> <div class="container-fluid" data-astro-cid-user7c46> <div class="row align-items-center" data-astro-cid-user7c46> <div class="col-sm-6" data-astro-cid-user7c46> <h3 class="mb-0" data-astro-cid-user7c46>Kategori Y\xF6netimi</h3> </div> </div> <div class="row" data-astro-cid-user7c46> <div class="col-sm-12" data-astro-cid-user7c46> <ol class="breadcrumb float-sm-end" data-astro-cid-user7c46> <li class="breadcrumb-item" data-astro-cid-user7c46><a href="#" data-astro-cid-user7c46>Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page" data-astro-cid-user7c46>Kategori Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content" data-astro-cid-user7c46> <div class="container-fluid" data-astro-cid-user7c46> ',
            ' ',
            ' ',
            ' ',
            ' <div class="row" data-astro-cid-user7c46> <div class="col-12" data-astro-cid-user7c46> <div class="card mb-4" data-astro-cid-user7c46> <div class="card-header" data-astro-cid-user7c46> <div class="row align-items-center" data-astro-cid-user7c46> <div class="col" data-astro-cid-user7c46> <h3 class="card-title mb-0" data-astro-cid-user7c46>Kategoriler</h3> </div> <div class="col-auto" data-astro-cid-user7c46> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal" data-astro-cid-user7c46>\nKategori Ekle\n</button> </div> </div> </div> <div class="card-body p-0" data-astro-cid-user7c46> <table class="table table-striped" id="categoriesTable" data-astro-cid-user7c46> <thead data-astro-cid-user7c46> <tr data-astro-cid-user7c46> <th style="width: 10px" data-astro-cid-user7c46>#</th> <th data-astro-cid-user7c46>Kod</th> <th data-astro-cid-user7c46>Kategori Ad\u0131</th> <th data-astro-cid-user7c46>A\xE7\u0131klama</th> <th data-astro-cid-user7c46>\u0130\u015Flem</th> </tr> </thead> <tbody data-astro-cid-user7c46> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix" data-astro-cid-user7c46> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ' <div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true" data-astro-cid-user7c46> <div class="modal-dialog" data-astro-cid-user7c46> <div class="modal-content" data-astro-cid-user7c46> <form id="addCategoryForm" method="POST" data-astro-cid-user7c46> <input type="hidden" name="action" value="add-category" data-astro-cid-user7c46> <div class="modal-header" data-astro-cid-user7c46> <h5 class="modal-title" id="addCategoryModalLabel" data-astro-cid-user7c46>Kategori Ekle</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat" data-astro-cid-user7c46></button> </div> <div class="modal-body" data-astro-cid-user7c46> <div class="mb-3" data-astro-cid-user7c46> <label for="code" class="form-label" data-astro-cid-user7c46>Kod</label> <input type="text" class="form-control" id="code" name="code" required data-astro-cid-user7c46> </div> <div class="mb-3" data-astro-cid-user7c46> <label for="name" class="form-label" data-astro-cid-user7c46>Kategori Ad\u0131</label> <input type="text" class="form-control" id="name" name="name" required data-astro-cid-user7c46> </div> <div class="mb-3" data-astro-cid-user7c46> <label for="description" class="form-label" data-astro-cid-user7c46>A\xE7\u0131klama</label> <textarea class="form-control" id="description" name="description" rows="3" required data-astro-cid-user7c46></textarea> </div> </div> <div class="modal-footer" data-astro-cid-user7c46> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-astro-cid-user7c46>Kapat</button> <button type="submit" class="btn btn-primary" data-astro-cid-user7c46>Kategori Kaydet</button> </div> </form> </div> </div> </div> <form id="deleteCategoryForm" method="POST" style="display: none;" data-astro-cid-user7c46> <input type="hidden" name="action" value="delete-category" data-astro-cid-user7c46> <input type="hidden" name="categoryId" id="deleteCategoryId" data-astro-cid-user7c46> </form> <script>(function(){',
            "\n      document.addEventListener('DOMContentLoaded', () => {\n        try {\n          const addCategoryModal = document.getElementById('addCategoryModal');\n          \n          if (window.location.search) {\n            const cleanUrl = window.location.pathname;\n            window.history.replaceState({}, document.title, cleanUrl);\n          }\n          \n          if (addSuccess) {\n            const modal = bootstrap.Modal.getInstance(addCategoryModal);\n            if (modal) {\n              modal.hide();\n            }\n          }\n          \n          const deleteCategoryForm = document.getElementById('deleteCategoryForm');\n          const deleteCategoryIdInput = document.getElementById('deleteCategoryId');\n          \n          const categoriesData = JSON.parse(categories);\n          \n          window.initPagination({\n            paginationId: 'pagination',\n            tableId: 'categoriesTable',\n            dataArray: categoriesData,\n            itemsPerPage: categoriesPerPage,\n            totalPages: totalPages,\n            renderItemCallback: (category, index) => {\n              const row = document.createElement('tr');\n              row.className = 'align-middle';\n              \n              row.innerHTML = `\n                <td>${index + 1}.</td>\n                <td>${category.code}</td>\n                <td>${category.name}</td>\n                <td>${category.description && category.description.length > 50 \n                  ? category.description.substring(0, 50) + '...' \n                  : category.description || ''}</td>\n                <td>\n                  <a href=\"#\" class=\"text-secondary me-2 delete-category\" data-category-id=\"${category.id}\" data-category-name=\"${category.name}\">\n                    <i class=\"bi bi-eraser\"></i>\n                  </a>\n                </td>\n              `;\n              \n              return row;\n            },\n            afterPageChangeCallback: () => {\n              document.querySelectorAll('.delete-category').forEach(btn => {\n                btn.addEventListener('click', function(e) {\n                  e.preventDefault();\n                  const categoryId = this.getAttribute('data-category-id');\n                  const categoryName = this.getAttribute('data-category-name');\n                  \n                  if (confirm(`\"${categoryName}\" kategorisini silmek istedi\u011Finize emin misiniz?`)) {\n                    deleteCategoryIdInput.value = categoryId;\n                    deleteCategoryForm.submit();\n                  }\n                });\n              });\n            }\n          });\n          \n          document.querySelectorAll('.delete-category').forEach(btn => {\n            btn.addEventListener('click', function(e) {\n              e.preventDefault();\n              const categoryId = this.getAttribute('data-category-id');\n              const categoryName = this.getAttribute('data-category-name');\n              \n              if (confirm(`\"${categoryName}\" kategorisini silmek istedi\u011Finize emin misiniz?`)) {\n                deleteCategoryIdInput.value = categoryId;\n                deleteCategoryForm.submit();\n              }\n            });\n          });\n          \n        } catch (error) {\n          console.error('Sayfa numaraland\u0131rma ba\u015Flatma hatas\u0131:', error);\n        }\n      });\n    })();<\/script> </body> </html>",
          ],
          [
            '<html lang="tr" data-astro-cid-user7c46> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary" data-astro-cid-user7c46> <div class="app-wrapper" data-astro-cid-user7c46> ',
            ' ',
            ' <main class="app-main" data-astro-cid-user7c46> <div class="app-content-header" data-astro-cid-user7c46> <div class="container-fluid" data-astro-cid-user7c46> <div class="row align-items-center" data-astro-cid-user7c46> <div class="col-sm-6" data-astro-cid-user7c46> <h3 class="mb-0" data-astro-cid-user7c46>Kategori Y\xF6netimi</h3> </div> </div> <div class="row" data-astro-cid-user7c46> <div class="col-sm-12" data-astro-cid-user7c46> <ol class="breadcrumb float-sm-end" data-astro-cid-user7c46> <li class="breadcrumb-item" data-astro-cid-user7c46><a href="#" data-astro-cid-user7c46>Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page" data-astro-cid-user7c46>Kategori Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content" data-astro-cid-user7c46> <div class="container-fluid" data-astro-cid-user7c46> ',
            ' ',
            ' ',
            ' ',
            ' <div class="row" data-astro-cid-user7c46> <div class="col-12" data-astro-cid-user7c46> <div class="card mb-4" data-astro-cid-user7c46> <div class="card-header" data-astro-cid-user7c46> <div class="row align-items-center" data-astro-cid-user7c46> <div class="col" data-astro-cid-user7c46> <h3 class="card-title mb-0" data-astro-cid-user7c46>Kategoriler</h3> </div> <div class="col-auto" data-astro-cid-user7c46> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal" data-astro-cid-user7c46>\nKategori Ekle\n</button> </div> </div> </div> <div class="card-body p-0" data-astro-cid-user7c46> <table class="table table-striped" id="categoriesTable" data-astro-cid-user7c46> <thead data-astro-cid-user7c46> <tr data-astro-cid-user7c46> <th style="width: 10px" data-astro-cid-user7c46>#</th> <th data-astro-cid-user7c46>Kod</th> <th data-astro-cid-user7c46>Kategori Ad\u0131</th> <th data-astro-cid-user7c46>A\xE7\u0131klama</th> <th data-astro-cid-user7c46>\u0130\u015Flem</th> </tr> </thead> <tbody data-astro-cid-user7c46> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix" data-astro-cid-user7c46> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ' <div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true" data-astro-cid-user7c46> <div class="modal-dialog" data-astro-cid-user7c46> <div class="modal-content" data-astro-cid-user7c46> <form id="addCategoryForm" method="POST" data-astro-cid-user7c46> <input type="hidden" name="action" value="add-category" data-astro-cid-user7c46> <div class="modal-header" data-astro-cid-user7c46> <h5 class="modal-title" id="addCategoryModalLabel" data-astro-cid-user7c46>Kategori Ekle</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat" data-astro-cid-user7c46></button> </div> <div class="modal-body" data-astro-cid-user7c46> <div class="mb-3" data-astro-cid-user7c46> <label for="code" class="form-label" data-astro-cid-user7c46>Kod</label> <input type="text" class="form-control" id="code" name="code" required data-astro-cid-user7c46> </div> <div class="mb-3" data-astro-cid-user7c46> <label for="name" class="form-label" data-astro-cid-user7c46>Kategori Ad\u0131</label> <input type="text" class="form-control" id="name" name="name" required data-astro-cid-user7c46> </div> <div class="mb-3" data-astro-cid-user7c46> <label for="description" class="form-label" data-astro-cid-user7c46>A\xE7\u0131klama</label> <textarea class="form-control" id="description" name="description" rows="3" required data-astro-cid-user7c46></textarea> </div> </div> <div class="modal-footer" data-astro-cid-user7c46> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-astro-cid-user7c46>Kapat</button> <button type="submit" class="btn btn-primary" data-astro-cid-user7c46>Kategori Kaydet</button> </div> </form> </div> </div> </div> <form id="deleteCategoryForm" method="POST" style="display: none;" data-astro-cid-user7c46> <input type="hidden" name="action" value="delete-category" data-astro-cid-user7c46> <input type="hidden" name="categoryId" id="deleteCategoryId" data-astro-cid-user7c46> </form> <script>(function(){',
            "\n      document.addEventListener('DOMContentLoaded', () => {\n        try {\n          const addCategoryModal = document.getElementById('addCategoryModal');\n          \n          if (window.location.search) {\n            const cleanUrl = window.location.pathname;\n            window.history.replaceState({}, document.title, cleanUrl);\n          }\n          \n          if (addSuccess) {\n            const modal = bootstrap.Modal.getInstance(addCategoryModal);\n            if (modal) {\n              modal.hide();\n            }\n          }\n          \n          const deleteCategoryForm = document.getElementById('deleteCategoryForm');\n          const deleteCategoryIdInput = document.getElementById('deleteCategoryId');\n          \n          const categoriesData = JSON.parse(categories);\n          \n          window.initPagination({\n            paginationId: 'pagination',\n            tableId: 'categoriesTable',\n            dataArray: categoriesData,\n            itemsPerPage: categoriesPerPage,\n            totalPages: totalPages,\n            renderItemCallback: (category, index) => {\n              const row = document.createElement('tr');\n              row.className = 'align-middle';\n              \n              row.innerHTML = \\`\n                <td>\\${index + 1}.</td>\n                <td>\\${category.code}</td>\n                <td>\\${category.name}</td>\n                <td>\\${category.description && category.description.length > 50 \n                  ? category.description.substring(0, 50) + '...' \n                  : category.description || ''}</td>\n                <td>\n                  <a href=\"#\" class=\"text-secondary me-2 delete-category\" data-category-id=\"\\${category.id}\" data-category-name=\"\\${category.name}\">\n                    <i class=\"bi bi-eraser\"></i>\n                  </a>\n                </td>\n              \\`;\n              \n              return row;\n            },\n            afterPageChangeCallback: () => {\n              document.querySelectorAll('.delete-category').forEach(btn => {\n                btn.addEventListener('click', function(e) {\n                  e.preventDefault();\n                  const categoryId = this.getAttribute('data-category-id');\n                  const categoryName = this.getAttribute('data-category-name');\n                  \n                  if (confirm(\\`\"\\${categoryName}\" kategorisini silmek istedi\u011Finize emin misiniz?\\`)) {\n                    deleteCategoryIdInput.value = categoryId;\n                    deleteCategoryForm.submit();\n                  }\n                });\n              });\n            }\n          });\n          \n          document.querySelectorAll('.delete-category').forEach(btn => {\n            btn.addEventListener('click', function(e) {\n              e.preventDefault();\n              const categoryId = this.getAttribute('data-category-id');\n              const categoryName = this.getAttribute('data-category-name');\n              \n              if (confirm(\\`\"\\${categoryName}\" kategorisini silmek istedi\u011Finize emin misiniz?\\`)) {\n                deleteCategoryIdInput.value = categoryId;\n                deleteCategoryForm.submit();\n              }\n            });\n          });\n          \n        } catch (error) {\n          console.error('Sayfa numaraland\u0131rma ba\u015Flatma hatas\u0131:', error);\n        }\n      });\n    })();<\/script> </body> </html>",
          ],
        )),
      renderComponent($$result, 'Head', $$Head, {
        title: title,
        path: path,
        'data-astro-cid-user7c46': true,
      }),
      renderHead(),
      renderComponent($$result, 'Topbar', $$Topbar, {
        path: path,
        'data-astro-cid-user7c46': true,
      }),
      renderComponent($$result, 'Sidenav', $$Sidenav, {
        path: path,
        mainPage: mainPage,
        page: page,
        'data-astro-cid-user7c46': true,
      }),
      addSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert" data-astro-cid-user7c46>
Kategori başarıyla eklendi!
<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-user7c46></button> </div>`,
      addError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert" data-astro-cid-user7c46>
Kategori eklerken hata: ${addError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-user7c46></button> </div>`,
      deleteSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert" data-astro-cid-user7c46>
Kategori "${deletedCategory.name}" (Kod: ${deletedCategory.code}) başarıyla silindi!
<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-user7c46></button> </div>`,
      deleteError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert" data-astro-cid-user7c46>
Kategori silerken hata: ${deleteError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-user7c46></button> </div>`,
      categories
        .slice(0, categoriesPerPage)
        .map(
          (category, index) =>
            renderTemplate`<tr class="align-middle" data-astro-cid-user7c46> <td data-astro-cid-user7c46>${index + 1}.</td> <td data-astro-cid-user7c46>${category.code}</td> <td data-astro-cid-user7c46>${category.name}</td> <td data-astro-cid-user7c46> ${category.description && category.description.length > 50 ? `${category.description.substring(0, 50)}...` : category.description || ''} </td> <td data-astro-cid-user7c46> <a href="#" class="text-secondary me-2 delete-category"${addAttribute(category.id, 'data-category-id')}${addAttribute(category.name, 'data-category-name')} data-astro-cid-user7c46> <i class="bi bi-eraser" data-astro-cid-user7c46></i> </a> </td> </tr>`,
        ),
      renderComponent($$result, 'Pagination', $$Pagination, {
        id: 'pagination',
        currentPage: currentPage,
        totalPages: totalPages,
        size: 'sm',
        'data-astro-cid-user7c46': true,
      }),
      renderComponent($$result, 'Footer', $$Footer, { 'data-astro-cid-user7c46': true }),
      renderComponent($$result, 'Scripts', $$Scripts, {
        path: path,
        'data-astro-cid-user7c46': true,
      }),
      defineScriptVars({
        categories: JSON.stringify(categories),
        categoriesPerPage,
        totalPages,
        addSuccess,
      }),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/pages/category-management/index.astro',
  undefined,
);

const $$file = '/Users/jin/Developments/work/ea/AdminLTE/src/pages/category-management/index.astro';
const $$url = '/category-management';

const _page = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      default: $$Index,
      file: $$file,
      prerender,
      url: $$url,
    },
    Symbol.toStringTag,
    { value: 'Module' },
  ),
);

const page = () => _page;

export { page };
