import {
  e as createComponent,
  r as renderTemplate,
  i as defineScriptVars,
  j as renderComponent,
  g as addAttribute,
  k as renderHead,
  h as createAstro,
} from '../chunks/astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import { $ as $$Scripts, a as $$Head } from '../chunks/_scripts_P5Q6xZAb.mjs';
import { $ as $$Footer, a as $$Sidenav, b as $$Topbar } from '../chunks/_sidenav_BYv4xoan.mjs';
export { renderers } from '../renderers.mjs';

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) =>
  __freeze(__defProp(cooked, 'raw', { value: __freeze(cooked.slice()) }));
var _a;
const $$Astro = createAstro();
const prerender = false;
const $$Index = createComponent(
  async ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Index;
    const title = 'AdminLTE | Dashboard v3';
    const path = '../../../dist';
    const mainPage = 'dashboard';
    const page = 'index3';
    const response = await fetch('http://192.168.9.12:8000/api/v1/users/');
    const users = await response.json();
    const totalUsers = users.length;
    const currentDate = /* @__PURE__ */ new Date();
    const oneWeekAgo = new Date(currentDate);
    oneWeekAgo.setDate(oneWeekAgo.getDate() - 7);
    const twoWeeksAgo = new Date(oneWeekAgo);
    twoWeeksAgo.setDate(twoWeeksAgo.getDate() - 7);
    const currentWeekUsers = users.filter((user) => new Date(user.created_at) >= oneWeekAgo).length;
    const previousWeekUsers = users.filter(
      (user) => new Date(user.created_at) >= twoWeeksAgo && new Date(user.created_at) < oneWeekAgo,
    ).length;
    const percentChange =
      previousWeekUsers > 0
        ? (((currentWeekUsers - previousWeekUsers) / previousWeekUsers) * 100).toFixed(1)
        : 100;
    const isIncrease = Number(percentChange) >= 0;
    const last7Days = Array.from({ length: 7 }, (_, i) => {
      const date = new Date(currentDate);
      date.setDate(date.getDate() - i);
      return date.toISOString().split('T')[0];
    }).reverse();
    const previous7Days = Array.from({ length: 7 }, (_, i) => {
      const date = new Date(oneWeekAgo);
      date.setDate(date.getDate() - i);
      return date.toISOString().split('T')[0];
    }).reverse();
    const currentWeekData = last7Days.map(
      (day) => users.filter((user) => user.created_at.startsWith(day)).length,
    );
    const previousWeekData = previous7Days.map(
      (day) => users.filter((user) => user.created_at.startsWith(day)).length,
    );
    const dayLabels = last7Days.map((day) => {
      const date = new Date(day);
      const dayOfMonth = date.getDate();
      const suffix = ['th', 'st', 'nd', 'rd'][
        dayOfMonth % 10 > 3 ? 0 : (dayOfMonth % 100) - (dayOfMonth % 10) != 10 ? dayOfMonth % 10 : 0
      ];
      return `${dayOfMonth}${suffix}`;
    });
    const weeklySalesData = [];
    const salesWeekLabels = [];
    let totalSalesPoints = 0;
    let totalSalesOrders = 0;
    let salesPercentChange = 0;
    let products = [];
    try {
      const productsResponse = await fetch('http://192.168.9.12:8000/api/v1/products');
      products = await productsResponse.json();
      console.log('\xDCr\xFCnler al\u0131nd\u0131:', products.length);
    } catch (error) {
      console.error('\xDCr\xFCnleri al\u0131rken hata:', error);
    }
    const todayDate = /* @__PURE__ */ new Date();
    const weekDates = [];
    for (let i = 0; i < 6; i++) {
      const date = new Date(todayDate);
      date.setDate(date.getDate() - i * 7);
      weekDates.push(date.toISOString().split('T')[0]);
    }
    const uniqueSalesUserIds = /* @__PURE__ */ new Set();
    for (const date of weekDates) {
      try {
        const salesResponse = await fetch(
          `http://192.168.9.12:8000/api/v1/orders/summary/weekly?date=${date}`,
        );
        const salesData = await salesResponse.json();
        weeklySalesData.push(salesData);
        const startDate = new Date(salesData.start_date);
        const endDate = new Date(salesData.end_date);
        const startMonth = startDate.toLocaleString('default', { month: 'short' });
        const startDay = startDate.getDate();
        const endDay = endDate.getDate();
        salesWeekLabels.push(`${startMonth} ${startDay}-${endDay}`);
        totalSalesPoints += salesData.total_points;
        totalSalesOrders += salesData.order_count;
        if (salesData.unique_users_count > 0) {
          uniqueSalesUserIds.add(salesData.unique_users_count);
        }
      } catch (error) {
        console.error(`Tarih ${date} i\xE7in sat\u0131\u015F verilerini al\u0131rken hata:`, error);
        weeklySalesData.push({
          unique_users_count: 0,
          order_count: 0,
          total_points: 0,
          start_date: new Date(date).toISOString(),
          end_date: new Date(date).toISOString(),
        });
        salesWeekLabels.push(`Hafta ${date}`);
      }
    }
    weeklySalesData.reverse();
    salesWeekLabels.reverse();
    const totalSalesUsers = 3;
    const salesPointsData = weeklySalesData.map((week) => week.total_points);
    const salesOrdersData = weeklySalesData.map((week) => week.order_count);
    const salesUsersData = weeklySalesData.map((week) => week.unique_users_count);
    let settings = [];
    if (Astro2.cookies.has('auth_token')) {
      try {
        const token = Astro2.cookies.get('auth_token').value;
        const settingsResponse = await fetch('http://192.168.9.12:8000/api/v1/admin/settings', {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        });
        if (!settingsResponse.ok) {
          throw new Error(`HTTP hatas\u0131! durum: ${settingsResponse.status}`);
        }
        const data = await settingsResponse.json();
        settings = Array.isArray(data) ? data : [];
        console.log('Ayarlar al\u0131nd\u0131:', settings.length);
      } catch (error) {
        console.error('Ayarlar\u0131 al\u0131rken hata:', error);
        settings = [];
      }
    } else {
      console.log('Hi\xE7bir kimlik do\u011Frulama belirteci bulunamad\u0131');
    }
    let updateMessage = null;
    let updateSuccess = false;
    if (Astro2.request.method === 'POST') {
      try {
        const formData = await Astro2.request.formData();
        const settingId = formData.get('setting_id');
        const settingName = formData.get('setting_name');
        const settingValue = formData.get('setting_value');
        if (settingId && settingValue) {
          const token = Astro2.cookies.get('auth_token')?.value;
          if (!token) {
            throw new Error('Kimlik do\u011Frulama belirteci bulunamad\u0131');
          }
          const updateResponse = await fetch(
            `http://192.168.9.12:8000/api/v1/admin/settings/${settingName}`,
            {
              method: 'PUT',
              headers: {
                'Content-Type': 'application/json',
                Authorization: `Bearer ${token}`,
              },
              body: JSON.stringify({
                setting_name: settingName,
                setting_value: settingValue,
              }),
            },
          );
          if (updateResponse.ok) {
            updateSuccess = true;
            updateMessage = `Ayar "${settingName}" ba\u015Far\u0131yla g\xFCncellendi!`;
            const settingsResponse = await fetch('http://192.168.9.12:8000/api/v1/admin/settings', {
              headers: {
                Authorization: `Bearer ${token}`,
              },
            });
            if (settingsResponse.ok) {
              const data = await settingsResponse.json();
              settings = Array.isArray(data) ? data : [];
            }
          } else {
            const errorData = await updateResponse.json();
            updateSuccess = false;
            updateMessage = `Ayar\u0131 g\xFCncellerken hata: ${errorData.message || 'Bilinmeyen hata'}`;
          }
        }
      } catch (error) {
        console.error('Ayar\u0131 g\xFCncellerken hata:', error);
        updateSuccess = false;
        updateMessage = 'Ayar\u0131 g\xFCncellerken bir hata olu\u015Ftu.';
      }
    }
    return renderTemplate(
      _a ||
        (_a = __template([
          '<html lang="tr"> <head>',
          '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.css" integrity="sha256-4MX+61mt9NVvvuPjUWdUdyfZfxSB1/Rf9WtqRHgG5S0=" crossorigin="anonymous">',
          '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary"> <div class="app-wrapper"> ',
          ' ',
          ' <main class="app-main"> <div class="app-content-header"> <div class="container-fluid"> <div class="row"> <div class="col-lg-6"> <div class="card mb-4"> <div class="card-header border-0"> <div class="d-flex justify-content-between"> <h3 class="card-title">Kay\u0131tl\u0131 Kullan\u0131c\u0131lar</h3> </div> </div> <div class="card-body"> <div class="d-flex"> <p class="d-flex flex-column"> <span>Toplam</span> <span class="fw-bold fs-5">',
          '</span> </p> <p class="ms-auto d-flex flex-column text-end"> <span',
          '> <i',
          '></i> ',
          '%\n</span> <span class="text-secondary">Ge\xE7en haftadan beri</span> </p> </div> <div class="position-relative mb-4"> <div id="visitors-chart"></div> </div> <div class="d-flex flex-row justify-content-end"> <span class="me-2"> <i class="bi bi-square-fill text-primary"></i> Bu Hafta\n</span> <span> <i class="bi bi-square-fill text-secondary"></i> Ge\xE7en Hafta\n</span> </div> </div> </div> </div> <div class="col-lg-6"> <div class="card mb-4"> <div class="card-header border-0"> <div class="d-flex justify-content-between"> <h3 class="card-title">Sat\u0131\u015Flar</h3> </div> </div> <div class="card-body"> <div class="d-flex"> <p class="d-flex flex-column"> <span class="fw-bold fs-5">',
          ' Puan</span> <span>Sipari\u015Fler: ',
          ' | Kullan\u0131c\u0131lar: ',
          '</span> </p> <p class="ms-auto d-flex flex-column text-end"> <span',
          '> <i',
          '></i> ',
          '%\n</span> <span class="text-secondary">Ge\xE7en Haftadan Beri</span> </p> </div> <div class="position-relative mb-4"> <div id="sales-chart"></div> </div> <div class="d-flex flex-row justify-content-end"> <span class="me-2"> <i class="bi bi-square-fill text-primary"></i> Puanlar\n</span> <span class="me-2"> <i class="bi bi-square-fill text-success"></i> Sipari\u015Fler\n</span> <span> <i class="bi bi-square-fill text-warning"></i> Kullan\u0131c\u0131lar\n</span> </div> </div> </div> </div> </div> </div> </div> <div class="app-content"> <div class="container-fluid"> <div class="row"> <div class="col-lg-12"> <div class="card mb-4"> <div class="card-header border-0"> <h3 class="card-title">\xDCr\xFCnler</h3> </div> <div class="card-body table-responsive p-0"> <table class="table table-striped align-middle"> <thead> <tr> <th>\xDCr\xFCn Ad\u0131</th> <th>Puanlar</th> <th>Stok</th> <th>Durum</th> </tr> </thead> <tbody> ',
          ' </tbody> </table> </div> </div> </div> </div> <div class="row"> <div class="col-lg-12"> <div class="card mb-4"></div> <div class="card mb-4"> <div class="card-header border-0"> <h3 class="card-title">Sistem Ayarlar\u0131</h3> ',
          ' </div> <div class="card-body table-responsive p-0"> <table class="table table-striped align-middle"> <thead> <tr> <th>Ayar Ad\u0131</th> <th>De\u011Fer</th> <th>Son G\xFCncelleme</th> <th>\u0130\u015Flem</th> </tr> </thead> <tbody> ',
          ' </tbody> </table> </div> </div> </div> </div> </div> </div> </main> ',
          ' </div> ',
          ' <script src="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.min.js" integrity="sha256-+vh8GkaU7C9/wbSLIcwq82tQ2wTf44aOHA8HlBMwRI8=" crossorigin="anonymous"><\/script> <script>(function(){',
          `
      
      console.log('Grafik Verisi:', {
        salesPointsData,
        salesOrdersData,
        salesUsersData,
        salesWeekLabels
      });

      const safePointsData = Array.isArray(salesPointsData) ? salesPointsData : [];
      const safeOrdersData = Array.isArray(salesOrdersData) ? salesOrdersData : [];
      const safeUsersData = Array.isArray(salesUsersData) ? salesUsersData : [];
      const safeWeekLabels = Array.isArray(salesWeekLabels) ? salesWeekLabels : [];

      const visitors_chart_options = {
        series: [
          {
            name: "Bu Hafta",
            data: currentWeekData,
          },
          {
            name: "Ge\xE7en Hafta",
            data: previousWeekData,
          },
        ],
        chart: {
          height: 200,
          type: "line",
          toolbar: {
            show: false,
          },
        },
        colors: ["#0d6efd", "#adb5bd"],
        stroke: {
          curve: "smooth",
        },
        grid: {
          borderColor: "#e7e7e7",
          row: {
            colors: ["#f3f3f3", "transparent"],
            opacity: 0.5,
          },
        },
        legend: {
          show: false,
        },
        markers: {
          size: 1,
        },
        xaxis: {
          categories: dayLabels,
        },
        tooltip: {
          y: {
            formatter: function (val) {
              return val + " kullan\u0131c\u0131";
            }
          }
        }
      };

      const visitors_chart = new ApexCharts(
        document.querySelector("#visitors-chart"),
        visitors_chart_options
      );
      visitors_chart.render();

      const sales_chart_options = {
        series: [
          {
            name: "Puanlar",
            type: "column",
            data: safePointsData.map(p => Number(p) || 0)
          },
          {
            name: "Sipari\u015Fler",
            type: "column",
            data: safeOrdersData.map(o => Number(o) || 0)
          },
          {
            name: "Kullan\u0131c\u0131lar",
            type: "column",
            data: safeUsersData.map(u => Number(u) || 0)
          },
        ],
        chart: {
          height: 200,
          type: "bar",
          toolbar: {
            show: false,
          },
        },
        plotOptions: {
          bar: {
            columnWidth: "55%",
            endingShape: "rounded",
          },
        },
        legend: {
          show: false,
        },
        colors: ["#0d6efd", "#20c997", "#ffc107"],
        dataLabels: {
          enabled: false,
        },
        stroke: {
          width: [0, 2, 2],
          curve: "smooth"
        },
        xaxis: {
          categories: safeWeekLabels,
        },
        yaxis: [
          {
            title: {
              text: "Puanlar",
              style: {
                color: "#0d6efd"
              }
            },
            labels: {
              formatter: function(val) {
                return val.toFixed(0);
              }
            }
          },
          {
            opposite: true,
            title: {
              text: "Sipari\u015Fler & Kullan\u0131c\u0131lar",
              style: {
                color: "#20c997"
              }
            },
            labels: {
              formatter: function(val) {
                return val.toFixed(0);
              }
            },
            min: 0
          }
        ],
        tooltip: {
          y: {
            formatter: function (val, { seriesIndex }) {
              if (seriesIndex === 0) return val + " puan";
              if (seriesIndex === 1) return val + " sipari\u015F";
              return val + " kullan\u0131c\u0131";
            },
          },
        },
      };

      document.addEventListener('DOMContentLoaded', function() {
        setTimeout(() => {
          const sales_chart = new ApexCharts(
            document.querySelector("#sales-chart"),
            sales_chart_options
          );
          sales_chart.render();
          console.log('Sat\u0131\u015F grafi\u011Fi olu\u015Fturuldu');
        }, 100);
      });

      document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.update-setting').forEach(button => {
          button.addEventListener('click', function(e) {
            e.preventDefault();
            const formId = this.getAttribute('form');
            const form = document.getElementById(formId);
            if (form) {
              form.submit();
            }
          });
        });
      });
    })();<\/script> </body> </html>`,
        ])),
      renderComponent($$result, 'Head', $$Head, { title: title, path: path }),
      renderHead(),
      renderComponent($$result, 'Topbar', $$Topbar, { path: path }),
      renderComponent($$result, 'Sidenav', $$Sidenav, {
        path: path,
        mainPage: mainPage,
        page: page,
      }),
      totalUsers,
      addAttribute(isIncrease ? 'text-success' : 'text-danger', 'class'),
      addAttribute(`bi bi-arrow-${isIncrease ? 'up' : 'down'}`, 'class'),
      Math.abs(Number(percentChange)),
      totalSalesPoints,
      totalSalesOrders,
      totalSalesUsers,
      addAttribute('text-success', 'class'),
      addAttribute(`bi bi-arrow-${'up'}`, 'class'),
      Math.abs(salesPercentChange),
      products.slice(0, 5).map(
        (
          product,
        ) => renderTemplate`<tr> <td> <img${addAttribute(product.thumbnail || path + '/assets/img/default-150x150.png', 'src')}${addAttribute(product.name, 'alt')} class="rounded-circle img-size-32 me-2"${addAttribute(`this.onerror=null; this.src='${path}/assets/img/default-150x150.png'`, 'onerror')}> ${product.name.length > 30 ? product.name.substring(0, 50) + '...' : product.name} </td> <td>${product.points_required} Puan</td> <td> ${
          product.stock > 0
            ? renderTemplate`<small class="text-success me-1"> <i class="bi bi-check-circle"></i>
Stokta
</small>`
            : renderTemplate`<small class="text-danger me-1"> <i class="bi bi-x-circle"></i>
Stokta Yok
</small>`
        } ${product.stock} Mevcut
</td> <td> ${product.status === 1 ? renderTemplate`<span class="badge text-bg-success">Aktif</span>` : renderTemplate`<span class="badge text-bg-danger">Pasif</span>`} </td> </tr>`,
      ),
      updateMessage &&
        renderTemplate`<div${addAttribute(`alert alert-${updateSuccess ? 'success' : 'danger'} alert-dismissible fade show mt-3`, 'class')} role="alert"> ${updateMessage} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button> </div>`,
      settings.length > 0
        ? settings.map(
            (
              setting,
            ) => renderTemplate`<tr> <td>${setting.setting_name}</td> <td> <form method="POST" class="setting-form"${addAttribute(`form-${setting.id}`, 'id')}> <input type="hidden" name="setting_id"${addAttribute(setting.id, 'value')}> <input type="hidden" name="setting_name"${addAttribute(setting.setting_name, 'value')}> <input type="text" class="form-control" name="setting_value"${addAttribute(setting.setting_value, 'value')}> </form> </td> <td>${new Date(setting.updated_at).toLocaleString()}</td> <td> <button class="btn btn-primary btn-sm update-setting"${addAttribute(`form-${setting.id}`, 'form')} type="submit">
Güncelle
</button> </td> </tr>`,
          )
        : renderTemplate`<tr> <td colspan="4" class="text-center"> ${Astro2.cookies.has('auth_token') ? 'Ayar verisi mevcut de\u011Fil' : 'Ayarlar\u0131 g\xF6r\xFCnt\xFClemek i\xE7in l\xFCtfen giri\u015F yap\u0131n'} </td> </tr>`,
      renderComponent($$result, 'Footer', $$Footer, {}),
      renderComponent($$result, 'Scripts', $$Scripts, { path: path }),
      defineScriptVars({
        currentWeekData,
        previousWeekData,
        dayLabels,
        salesPointsData,
        salesOrdersData,
        salesUsersData,
        salesWeekLabels,
      }),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/pages/dashboard/index.astro',
  undefined,
);

const $$file = '/Users/jin/Developments/work/ea/AdminLTE/src/pages/dashboard/index.astro';
const $$url = '/dashboard';

const _page = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      default: $$Index,
      file: $$file,
      prerender,
      url: $$url,
    },
    Symbol.toStringTag,
    { value: 'Module' },
  ),
);

const page = () => _page;

export { page };
