import {
  e as createComponent,
  r as renderTemplate,
  j as renderComponent,
  g as addAttribute,
  k as renderHead,
  h as createAstro,
} from '../chunks/astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import { $ as $$Scripts, a as $$Head } from '../chunks/_scripts_P5Q6xZAb.mjs';
export { renderers } from '../renderers.mjs';

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) =>
  __freeze(__defProp(cooked, 'raw', { value: __freeze(cooked.slice()) }));
var _a;
const $$Astro = createAstro();
const prerender = false;
const $$Index = createComponent(
  async ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Index;
    const title = 'Adimsayar Admin';
    const path = '../../../dist';
    const htmlPath = '';
    let loginError = null;
    if (Astro2.request.method === 'POST') {
      try {
        const data = await Astro2.request.json();
        const username = data.email;
        const password = data.password;
        const response = await fetch('http://192.168.9.12:8000/api/v1/admin/login', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
          },
          body: JSON.stringify({
            username,
            password,
          }),
        });
        const responseData = await response.json();
        console.log('Login response:', responseData);
        if (response.ok && responseData.access_token) {
          Astro2.cookies.set('auth_token', responseData.access_token, {
            path: '/',
            maxAge: 60 * 60 * 24,
          });
          return Astro2.redirect('/dashboard');
        } else {
          loginError = responseData.message || 'Login failed! Please check your credentials.';
        }
      } catch (error) {
        console.error('Server-side login error:', error);
        loginError = 'An error occurred while trying to log in. Please try again.';
      }
    }
    return renderTemplate(
      _a ||
        (_a = __template([
          '<html lang="en"> <!--begin::Head--> <head>',
          '',
          '</head> <!--end::Head--> <!--begin::Body--> <body class="login-page bg-body-secondary"> <div class="login-box"> <div class="login-logo"> <a',
          '><b>Adimsayar</b> Admin</a> </div> <!-- /.login-logo --> <div class="card"> <div class="card-body login-card-body"> <p class="login-box-msg">Oturumunuzu ba\u015Flatmak i\xE7in giri\u015F yap\u0131n</p> ',
          ' <form id="login-form" method="post"> <div class="input-group mb-3"> <input type="email" id="email" name="email" class="form-control" placeholder="E-posta" value="jinhyuk@eabilisim.net.tr"> <div class="input-group-text"> <span class="bi bi-envelope"></span> </div> </div> <div class="input-group mb-3"> <input type="password" id="password" name="password" class="form-control" placeholder="\u015Eifre" value="asdf1234"> <div class="input-group-text"> <span class="bi bi-lock-fill"></span> </div> </div> <!--begin::Row--> <div class="row"> <div class="col-8"> <div class="form-check"> <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault"> <label class="form-check-label" for="flexCheckDefault">\nBeni Hat\u0131rla\n</label> </div> </div> <!-- /.col --> <div class="col-4"> <div class="d-grid gap-2"> <button type="submit" class="btn btn-primary">Giri\u015F Yap</button> </div> </div> <!-- /.col --> </div> <!--end::Row--> </form> <!-- /.social-auth-links --> <p class="mb-1"> <a href="forgot-password.html">\u015Eifremi unuttum</a> </p> </div> <!-- /.login-card-body --> </div> </div> <!-- /.login-box --> ',
          " <script>\n      document.getElementById('login-form').addEventListener('submit', async (e) => {\n        e.preventDefault();\n        \n        const email = document.getElementById('email').value;\n        const password = document.getElementById('password').value;\n        \n        try {\n          const response = await fetch('', {\n            method: 'POST',\n            headers: {\n              'Content-Type': 'application/json'\n            },\n            body: JSON.stringify({\n              email,\n              password\n            })\n          });\n          \n          if (response.redirected) {\n            window.location.href = response.url;\n          } else {\n            const data = await response.json();\n            if (data.error) {\n              alert(data.error);\n            }\n          }\n        } catch (error) {\n          console.error('Login error:', error);\n          alert('An error occurred while trying to log in. Please try again.');\n        }\n      });\n    <\/script> </body> </html>",
        ])),
      renderComponent($$result, 'Head', $$Head, { title: title, path: path }),
      renderHead(),
      addAttribute(htmlPath + '/dashboard', 'href'),
      loginError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert"> ${loginError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button> </div>`,
      renderComponent($$result, 'Scripts', $$Scripts, { path: path }),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/pages/index.astro',
  undefined,
);

const $$file = '/Users/jin/Developments/work/ea/AdminLTE/src/pages/index.astro';
const $$url = '';

const _page = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      default: $$Index,
      file: $$file,
      prerender,
      url: $$url,
    },
    Symbol.toStringTag,
    { value: 'Module' },
  ),
);

const page = () => _page;

export { page };
