import {
  e as createComponent,
  r as renderTemplate,
  i as defineScriptVars,
  l as renderScript,
  j as renderComponent,
  g as addAttribute,
  k as renderHead,
  h as createAstro,
} from '../chunks/astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import { $ as $$Scripts, a as $$Head } from '../chunks/_scripts_P5Q6xZAb.mjs';
import { $ as $$Footer, a as $$Sidenav, b as $$Topbar } from '../chunks/_sidenav_BYv4xoan.mjs';
import { $ as $$Pagination } from '../chunks/_pagination_Cm6O4Y_1.mjs';
/* empty css                                         */
export { renderers } from '../renderers.mjs';

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) => __freeze(__defProp(cooked, 'raw', { value: __freeze(raw) }));
var _a;
const $$Astro = createAstro();
const prerender = false;
const $$Index = createComponent(
  async ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Index;
    const url = new URL(Astro2.request.url);
    let updateStatusSuccess = url.searchParams.get('updateStatusSuccess') === 'true';
    let updateStatusError = url.searchParams.get('updateStatusError');
    let updatedOrderId = url.searchParams.get('updatedOrderId');
    let updatedStatus = url.searchParams.get('updatedStatus');
    let orders = [];
    try {
      const response = await fetch('http://192.168.9.12:8000/api/v1/admin/orders');
      orders = await response.json();
      console.log(
        'Sunucu taraf\u0131 g\xFCnl\xFC\u011F\xFC - sipari\u015Fler al\u0131nd\u0131:',
        orders.length,
      );
    } catch (error) {
      console.error('Sipari\u015Fleri al\u0131rken hata:', error);
    }
    if (Astro2.request.method === 'POST') {
      try {
        const formData = await Astro2.request.formData();
        const action = formData.get('action');
        if (action === 'updateStatus') {
          const orderId = formData.get('orderId');
          const newStatus = formData.get('newStatus');
          console.log(
            `Sunucu taraf\u0131: Sipari\u015F durumu g\xFCncelleniyor ID ${orderId} i\xE7in ${newStatus} olarak`,
          );
          const response = await fetch(
            `http://192.168.9.12:8000/api/v1/admin/orders/${orderId}/status`,
            {
              method: 'PUT',
              headers: {
                'Content-Type': 'application/json',
              },
              body: JSON.stringify({ status: newStatus }),
            },
          );
          if (!response.ok) {
            throw new Error(`Sipari\u015F durumu g\xFCncellenemedi: ${response.status}`);
          }
          console.log(
            `Sunucu taraf\u0131: Sipari\u015F ${orderId} durumu ba\u015Far\u0131yla g\xFCncellendi ${newStatus} olarak`,
          );
          return Astro2.redirect(
            `/order-management?updateStatusSuccess=true&updatedOrderId=${orderId}&updatedStatus=${newStatus}`,
          );
        }
      } catch (error) {
        console.error('\u0130ste\u011Fi i\u015Flerken hata:', error);
        const errorMsg = error.message || 'Bilinmeyen hata';
        const formData = await Astro2.request.formData();
        const orderId = formData.get('orderId');
        return Astro2.redirect(
          `/order-management?updateStatusError=${encodeURIComponent(errorMsg)}&updatedOrderId=${orderId}`,
        );
      }
    }
    const ordersPerPage = 10;
    const totalOrders = orders.length;
    const totalPages = Math.ceil(totalOrders / ordersPerPage);
    const currentPage = 1;
    const title = 'AdminLTE | Dashboard v3';
    const path = '../../../dist';
    const mainPage = 'dashboard';
    const page = 'order-management';
    function formatDate(dateString) {
      const date = new Date(dateString);
      return date.toLocaleDateString('tr-TR', {
        year: 'numeric',
        month: '2-digit',
        day: '2-digit',
        hour: '2-digit',
        minute: '2-digit',
      });
    }
    return renderTemplate(
      _a ||
        (_a = __template(
          [
            '<html lang="tr" data-astro-cid-fea7qj55> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary" data-astro-cid-fea7qj55> <div class="app-wrapper" data-astro-cid-fea7qj55> ',
            ' ',
            ' <main class="app-main" data-astro-cid-fea7qj55> <div class="app-content-header" data-astro-cid-fea7qj55> <div class="container-fluid" data-astro-cid-fea7qj55> <div class="row align-items-center" data-astro-cid-fea7qj55> <div class="col-sm-6" data-astro-cid-fea7qj55> <h3 class="mb-0" data-astro-cid-fea7qj55>Sipari\u015F Y\xF6netimi</h3> </div> </div> <div class="row" data-astro-cid-fea7qj55> <div class="col-sm-12" data-astro-cid-fea7qj55> <ol class="breadcrumb float-sm-end" data-astro-cid-fea7qj55> <li class="breadcrumb-item" data-astro-cid-fea7qj55><a href="#" data-astro-cid-fea7qj55>Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page" data-astro-cid-fea7qj55>Sipari\u015F Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content" data-astro-cid-fea7qj55> <div class="container-fluid" data-astro-cid-fea7qj55>  ',
            ' ',
            ' <div class="row" data-astro-cid-fea7qj55> <div class="col-12" data-astro-cid-fea7qj55> <div class="card mb-4" data-astro-cid-fea7qj55> <div class="card-header" data-astro-cid-fea7qj55> <div class="row align-items-center" data-astro-cid-fea7qj55> <div class="col" data-astro-cid-fea7qj55> <h3 class="card-title mb-0" data-astro-cid-fea7qj55>Sipari\u015Fler</h3> </div> </div> </div> <div class="card-body p-0" data-astro-cid-fea7qj55> <table class="table table-striped" id="ordersTable" data-astro-cid-fea7qj55> <thead data-astro-cid-fea7qj55> <tr data-astro-cid-fea7qj55> <th style="width: 10px" data-astro-cid-fea7qj55>#</th> <th data-astro-cid-fea7qj55>Sipari\u015F Numaras\u0131</th> <th data-astro-cid-fea7qj55>Durum</th> <th data-astro-cid-fea7qj55>\xDCr\xFCn</th> <th data-astro-cid-fea7qj55>Miktar</th> <th data-astro-cid-fea7qj55>Sipari\u015F Tarihi</th> <th data-astro-cid-fea7qj55>Ayr\u0131nt\u0131lar</th> </tr> </thead> <tbody data-astro-cid-fea7qj55> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix" data-astro-cid-fea7qj55> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ' <!-- Bootstrap \uC2A4\uD06C\uB9BD\uD2B8 \uCD94\uAC00 --> ',
            ' <div class="modal fade" id="orderDetailModal" tabindex="-1" aria-labelledby="orderDetailModalLabel" aria-hidden="true" data-astro-cid-fea7qj55> <div class="modal-dialog modal-lg" data-astro-cid-fea7qj55> <div class="modal-content" data-astro-cid-fea7qj55> <div class="modal-header" data-astro-cid-fea7qj55> <h5 class="modal-title" id="orderDetailModalLabel" data-astro-cid-fea7qj55>Sipari\u015F Ayr\u0131nt\u0131lar\u0131</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat" data-astro-cid-fea7qj55></button> </div> <div class="modal-body" id="orderDetailContent" data-astro-cid-fea7qj55></div> <div class="modal-footer" data-astro-cid-fea7qj55> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-astro-cid-fea7qj55>Kapat</button> </div> </div> </div> </div> <form id="updateStatusForm" method="POST" style="display: none;" data-astro-cid-fea7qj55> <input type="hidden" name="action" value="updateStatus" data-astro-cid-fea7qj55> <input type="hidden" name="orderId" id="updateOrderId" data-astro-cid-fea7qj55> <input type="hidden" name="newStatus" id="updateNewStatus" data-astro-cid-fea7qj55> </form> <script>(function(){',
            `
      function formatDate(dateString) {
        const date = new Date(dateString);
        return date.toLocaleString('tr-TR', {
          year: 'numeric',
          month: '2-digit',
          day: '2-digit',
          hour: '2-digit',
          minute: '2-digit'
        });
      }
      
      function getStatusBadgeClass(status) {
        status = status.toLowerCase();
        switch(status) {
          case 'pending': return 'text-bg-warning';
          case 'delivered': return 'text-bg-success';
          case 'cancelled': return 'text-bg-danger';
          case 'processing': return 'text-bg-info';
          default: return 'text-bg-secondary';
        }
      }
      
      function showOrderDetail(order) {
        const orderDetailModal = document.getElementById('orderDetailModal');
        const orderDetailContent = document.getElementById('orderDetailContent');
        
        let html = \`
          <div class="row mb-3">
            <div class="col-md-6">
              <h6>Sipari\u015F Bilgileri</h6>
              <p><strong>Sipari\u015F Numaras\u0131:</strong> \${order.order_number}</p>
              <p>
                <strong>Durum:</strong> 
                <span class="badge \${getStatusBadgeClass(order.status)}">\${order.status}</span>
              </p>
              <div class="form-group mt-3">
                <label class="mb-2">Durumu De\u011Fi\u015Ftir:</label>
                <div class="d-flex flex-column gap-2">
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusPending" value="PENDING" \${order.status === 'PENDING' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusPending">BEKLEMEDE</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusProcessing" value="PROCESSING" \${order.status === 'PROCESSING' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusProcessing">\u0130\u015ELEN\u0130YOR</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusDelivered" value="DELIVERED" \${order.status === 'DELIVERED' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusDelivered">TESL\u0130M ED\u0130LD\u0130</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusCancelled" value="CANCELLED" \${order.status === 'CANCELLED' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusCancelled">\u0130PTAL ED\u0130LD\u0130</label>
                  </div>
                </div>
                <button class="btn btn-primary btn-sm mt-3" id="updateStatusBtn">Durumu G\xFCncelle</button>
              </div>
              <p><strong>Tarih:</strong> \${formatDate(order.created_at)}</p>
              <p><strong>Toplam Puan:</strong> \${order.total_points}</p>
            </div>
            <div class="col-md-6">
              <h6>G\xF6nderim Bilgileri</h6>
              <p><strong>Ad:</strong> \${order.shipping_details?.name || 'Yok'}</p>
              <p><strong>Telefon:</strong> \${order.shipping_details?.phone || 'Yok'}</p>
              <p><strong>Adres:</strong> \${order.shipping_details?.address || 'Yok'}</p>
              <p><strong>\u015Eehir:</strong> \${order.shipping_details?.city || 'Yok'}</p>
              <p><strong>Posta Kodu:</strong> \${order.shipping_details?.postal_code || 'Yok'}</p>
              <p><strong>\xDClke:</strong> \${order.shipping_details?.country || 'Yok'}</p>
            </div>
          </div>
          <h6>Sipari\u015F \xDCr\xFCnleri</h6>
          <table class="table table-striped">
            <thead>
              <tr>
                <th>\xDCr\xFCn</th>
                <th>Resim</th>
                <th>Miktar</th>
                <th>\xDCr\xFCn Ba\u015F\u0131na Puan</th>
                <th>Toplam Puan</th>
              </tr>
            </thead>
            <tbody>
        \`;
        
        if (order.items && order.items.length > 0) {
          order.items.forEach(item => {
            html += \`
              <tr>
                <td>\${item.product_name}</td>
                <td>
                  <img src="\${item.product_image}" alt="\${item.product_name}" 
                       class="img-thumbnail" style="width: 50px; height: auto;" 
                       onerror="this.onerror=null; this.src='\${window.location.origin}/dist/assets/img/default-150x150.png'">
                </td>
                <td>\${item.quantity}</td>
                <td>\${item.points_per_item}</td>
                <td>\${item.total_points}</td>
              </tr>
            \`;
          });
        } else {
          html += \`
            <tr>
              <td colspan="5" class="text-center">\xDCr\xFCn bulunamad\u0131</td>
            </tr>
          \`;
        }
        
        html += \`
            </tbody>
          </table>
        \`;
        
        orderDetailContent.innerHTML = html;
        
        document.getElementById('updateStatusBtn').addEventListener('click', function() {
          const selectedRadio = document.querySelector('input[name="orderStatus"]:checked');
          const newStatus = selectedRadio ? selectedRadio.value : null;
          const currentStatus = order.status;
          
          if (newStatus && newStatus !== currentStatus) {
            if (confirm(\`\${currentStatus} durumunu \${newStatus} olarak de\u011Fi\u015Ftirmek istedi\u011Finize emin misiniz?\`)) {
              document.getElementById('updateOrderId').value = order.id;
              document.getElementById('updateNewStatus').value = newStatus;
              document.getElementById('updateStatusForm').submit();
            }
          } else if (newStatus === currentStatus) {
            alert('Durum zaten ' + newStatus + ' olarak ayarland\u0131');
          } else {
            alert('L\xFCtfen bir durum se\xE7in');
          }
        });
        
        const modal = new bootstrap.Modal(orderDetailModal);
        modal.show();

        orderDetailModal.addEventListener('hidden.bs.modal', function () {
          document.body.classList.remove('modal-open');
          const backdrop = document.querySelector('.modal-backdrop');
          if (backdrop) {
            backdrop.remove();
          }
        });
      }
      
      function setupOrderDetailButtons(ordersData) {
        document.querySelectorAll('.view-order').forEach(btn => {
          btn.addEventListener('click', function(e) {
            e.preventDefault();
            const orderId = this.getAttribute('data-order-id');
            const order = ordersData.find(o => o.id.toString() === orderId);
            
            if (order) {
              showOrderDetail(order);
            }
          });
        });
      }

      document.addEventListener('DOMContentLoaded', () => {
        try {
          const ordersData = JSON.parse(orders);
          
          // URL \uB9E4\uAC1C\uBCC0\uC218\uB97C \uC0AC\uC6A9\uD55C \uD6C4 \uAE68\uB057\uD55C URL\uB85C \uAD50\uCCB4
          if (window.location.search) {
            const cleanUrl = window.location.pathname;
            window.history.replaceState({}, document.title, cleanUrl);
          }
          
          window.initPagination({
            paginationId: 'pagination',
            tableId: 'ordersTable',
            dataArray: ordersData,
            itemsPerPage: ordersPerPage,
            totalPages: totalPages,
            renderItemCallback: (order, index) => {
              const row = document.createElement('tr');
              row.className = 'align-middle';
              
              const productInfo = order.items && order.items.length > 0 
                ? order.items[0].product_name + (order.items.length > 1 ? \` (+\${order.items.length - 1} daha)\` : '')
                : '\xDCr\xFCn yok';
                
              const quantity = order.items && order.items.length > 0 
                ? order.items[0].quantity
                : '0';
              
              row.innerHTML = \`
                <td>\${index + 1}.</td>
                <td>\${order.order_number}</td>
                <td>
                  <span class="badge \${getStatusBadgeClass(order.status)}">
                    \${order.status}
                  </span>
                </td>
                <td>\${productInfo}</td>
                <td>\${quantity}</td>
                <td>\${formatDate(order.created_at)}</td>
                <td>
                  <a href="#" class="text-primary view-order" data-order-id="\${order.id}">
                    <i class="bi bi-eye"></i>
                  </a>
                </td>
              \`;
              
              return row;
            },
            afterPageChangeCallback: () => {
              setupOrderDetailButtons(ordersData);
            }
          });
          
          setupOrderDetailButtons(ordersData);
          
        } catch (error) {
          console.error('Sayfalama ba\u015Flat\u0131l\u0131rken hata:', error);
        }
      });
    })();<\/script> </body> </html>`,
          ],
          [
            '<html lang="tr" data-astro-cid-fea7qj55> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary" data-astro-cid-fea7qj55> <div class="app-wrapper" data-astro-cid-fea7qj55> ',
            ' ',
            ' <main class="app-main" data-astro-cid-fea7qj55> <div class="app-content-header" data-astro-cid-fea7qj55> <div class="container-fluid" data-astro-cid-fea7qj55> <div class="row align-items-center" data-astro-cid-fea7qj55> <div class="col-sm-6" data-astro-cid-fea7qj55> <h3 class="mb-0" data-astro-cid-fea7qj55>Sipari\u015F Y\xF6netimi</h3> </div> </div> <div class="row" data-astro-cid-fea7qj55> <div class="col-sm-12" data-astro-cid-fea7qj55> <ol class="breadcrumb float-sm-end" data-astro-cid-fea7qj55> <li class="breadcrumb-item" data-astro-cid-fea7qj55><a href="#" data-astro-cid-fea7qj55>Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page" data-astro-cid-fea7qj55>Sipari\u015F Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content" data-astro-cid-fea7qj55> <div class="container-fluid" data-astro-cid-fea7qj55>  ',
            ' ',
            ' <div class="row" data-astro-cid-fea7qj55> <div class="col-12" data-astro-cid-fea7qj55> <div class="card mb-4" data-astro-cid-fea7qj55> <div class="card-header" data-astro-cid-fea7qj55> <div class="row align-items-center" data-astro-cid-fea7qj55> <div class="col" data-astro-cid-fea7qj55> <h3 class="card-title mb-0" data-astro-cid-fea7qj55>Sipari\u015Fler</h3> </div> </div> </div> <div class="card-body p-0" data-astro-cid-fea7qj55> <table class="table table-striped" id="ordersTable" data-astro-cid-fea7qj55> <thead data-astro-cid-fea7qj55> <tr data-astro-cid-fea7qj55> <th style="width: 10px" data-astro-cid-fea7qj55>#</th> <th data-astro-cid-fea7qj55>Sipari\u015F Numaras\u0131</th> <th data-astro-cid-fea7qj55>Durum</th> <th data-astro-cid-fea7qj55>\xDCr\xFCn</th> <th data-astro-cid-fea7qj55>Miktar</th> <th data-astro-cid-fea7qj55>Sipari\u015F Tarihi</th> <th data-astro-cid-fea7qj55>Ayr\u0131nt\u0131lar</th> </tr> </thead> <tbody data-astro-cid-fea7qj55> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix" data-astro-cid-fea7qj55> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ' <!-- Bootstrap \uC2A4\uD06C\uB9BD\uD2B8 \uCD94\uAC00 --> ',
            ' <div class="modal fade" id="orderDetailModal" tabindex="-1" aria-labelledby="orderDetailModalLabel" aria-hidden="true" data-astro-cid-fea7qj55> <div class="modal-dialog modal-lg" data-astro-cid-fea7qj55> <div class="modal-content" data-astro-cid-fea7qj55> <div class="modal-header" data-astro-cid-fea7qj55> <h5 class="modal-title" id="orderDetailModalLabel" data-astro-cid-fea7qj55>Sipari\u015F Ayr\u0131nt\u0131lar\u0131</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat" data-astro-cid-fea7qj55></button> </div> <div class="modal-body" id="orderDetailContent" data-astro-cid-fea7qj55></div> <div class="modal-footer" data-astro-cid-fea7qj55> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-astro-cid-fea7qj55>Kapat</button> </div> </div> </div> </div> <form id="updateStatusForm" method="POST" style="display: none;" data-astro-cid-fea7qj55> <input type="hidden" name="action" value="updateStatus" data-astro-cid-fea7qj55> <input type="hidden" name="orderId" id="updateOrderId" data-astro-cid-fea7qj55> <input type="hidden" name="newStatus" id="updateNewStatus" data-astro-cid-fea7qj55> </form> <script>(function(){',
            `
      function formatDate(dateString) {
        const date = new Date(dateString);
        return date.toLocaleString('tr-TR', {
          year: 'numeric',
          month: '2-digit',
          day: '2-digit',
          hour: '2-digit',
          minute: '2-digit'
        });
      }
      
      function getStatusBadgeClass(status) {
        status = status.toLowerCase();
        switch(status) {
          case 'pending': return 'text-bg-warning';
          case 'delivered': return 'text-bg-success';
          case 'cancelled': return 'text-bg-danger';
          case 'processing': return 'text-bg-info';
          default: return 'text-bg-secondary';
        }
      }
      
      function showOrderDetail(order) {
        const orderDetailModal = document.getElementById('orderDetailModal');
        const orderDetailContent = document.getElementById('orderDetailContent');
        
        let html = \\\`
          <div class="row mb-3">
            <div class="col-md-6">
              <h6>Sipari\u015F Bilgileri</h6>
              <p><strong>Sipari\u015F Numaras\u0131:</strong> \\\${order.order_number}</p>
              <p>
                <strong>Durum:</strong> 
                <span class="badge \\\${getStatusBadgeClass(order.status)}">\\\${order.status}</span>
              </p>
              <div class="form-group mt-3">
                <label class="mb-2">Durumu De\u011Fi\u015Ftir:</label>
                <div class="d-flex flex-column gap-2">
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusPending" value="PENDING" \\\${order.status === 'PENDING' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusPending">BEKLEMEDE</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusProcessing" value="PROCESSING" \\\${order.status === 'PROCESSING' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusProcessing">\u0130\u015ELEN\u0130YOR</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusDelivered" value="DELIVERED" \\\${order.status === 'DELIVERED' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusDelivered">TESL\u0130M ED\u0130LD\u0130</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="orderStatus" id="statusCancelled" value="CANCELLED" \\\${order.status === 'CANCELLED' ? 'checked' : ''}>
                    <label class="form-check-label" for="statusCancelled">\u0130PTAL ED\u0130LD\u0130</label>
                  </div>
                </div>
                <button class="btn btn-primary btn-sm mt-3" id="updateStatusBtn">Durumu G\xFCncelle</button>
              </div>
              <p><strong>Tarih:</strong> \\\${formatDate(order.created_at)}</p>
              <p><strong>Toplam Puan:</strong> \\\${order.total_points}</p>
            </div>
            <div class="col-md-6">
              <h6>G\xF6nderim Bilgileri</h6>
              <p><strong>Ad:</strong> \\\${order.shipping_details?.name || 'Yok'}</p>
              <p><strong>Telefon:</strong> \\\${order.shipping_details?.phone || 'Yok'}</p>
              <p><strong>Adres:</strong> \\\${order.shipping_details?.address || 'Yok'}</p>
              <p><strong>\u015Eehir:</strong> \\\${order.shipping_details?.city || 'Yok'}</p>
              <p><strong>Posta Kodu:</strong> \\\${order.shipping_details?.postal_code || 'Yok'}</p>
              <p><strong>\xDClke:</strong> \\\${order.shipping_details?.country || 'Yok'}</p>
            </div>
          </div>
          <h6>Sipari\u015F \xDCr\xFCnleri</h6>
          <table class="table table-striped">
            <thead>
              <tr>
                <th>\xDCr\xFCn</th>
                <th>Resim</th>
                <th>Miktar</th>
                <th>\xDCr\xFCn Ba\u015F\u0131na Puan</th>
                <th>Toplam Puan</th>
              </tr>
            </thead>
            <tbody>
        \\\`;
        
        if (order.items && order.items.length > 0) {
          order.items.forEach(item => {
            html += \\\`
              <tr>
                <td>\\\${item.product_name}</td>
                <td>
                  <img src="\\\${item.product_image}" alt="\\\${item.product_name}" 
                       class="img-thumbnail" style="width: 50px; height: auto;" 
                       onerror="this.onerror=null; this.src='\\\${window.location.origin}/dist/assets/img/default-150x150.png'">
                </td>
                <td>\\\${item.quantity}</td>
                <td>\\\${item.points_per_item}</td>
                <td>\\\${item.total_points}</td>
              </tr>
            \\\`;
          });
        } else {
          html += \\\`
            <tr>
              <td colspan="5" class="text-center">\xDCr\xFCn bulunamad\u0131</td>
            </tr>
          \\\`;
        }
        
        html += \\\`
            </tbody>
          </table>
        \\\`;
        
        orderDetailContent.innerHTML = html;
        
        document.getElementById('updateStatusBtn').addEventListener('click', function() {
          const selectedRadio = document.querySelector('input[name="orderStatus"]:checked');
          const newStatus = selectedRadio ? selectedRadio.value : null;
          const currentStatus = order.status;
          
          if (newStatus && newStatus !== currentStatus) {
            if (confirm(\\\`\\\${currentStatus} durumunu \\\${newStatus} olarak de\u011Fi\u015Ftirmek istedi\u011Finize emin misiniz?\\\`)) {
              document.getElementById('updateOrderId').value = order.id;
              document.getElementById('updateNewStatus').value = newStatus;
              document.getElementById('updateStatusForm').submit();
            }
          } else if (newStatus === currentStatus) {
            alert('Durum zaten ' + newStatus + ' olarak ayarland\u0131');
          } else {
            alert('L\xFCtfen bir durum se\xE7in');
          }
        });
        
        const modal = new bootstrap.Modal(orderDetailModal);
        modal.show();

        orderDetailModal.addEventListener('hidden.bs.modal', function () {
          document.body.classList.remove('modal-open');
          const backdrop = document.querySelector('.modal-backdrop');
          if (backdrop) {
            backdrop.remove();
          }
        });
      }
      
      function setupOrderDetailButtons(ordersData) {
        document.querySelectorAll('.view-order').forEach(btn => {
          btn.addEventListener('click', function(e) {
            e.preventDefault();
            const orderId = this.getAttribute('data-order-id');
            const order = ordersData.find(o => o.id.toString() === orderId);
            
            if (order) {
              showOrderDetail(order);
            }
          });
        });
      }

      document.addEventListener('DOMContentLoaded', () => {
        try {
          const ordersData = JSON.parse(orders);
          
          // URL \uB9E4\uAC1C\uBCC0\uC218\uB97C \uC0AC\uC6A9\uD55C \uD6C4 \uAE68\uB057\uD55C URL\uB85C \uAD50\uCCB4
          if (window.location.search) {
            const cleanUrl = window.location.pathname;
            window.history.replaceState({}, document.title, cleanUrl);
          }
          
          window.initPagination({
            paginationId: 'pagination',
            tableId: 'ordersTable',
            dataArray: ordersData,
            itemsPerPage: ordersPerPage,
            totalPages: totalPages,
            renderItemCallback: (order, index) => {
              const row = document.createElement('tr');
              row.className = 'align-middle';
              
              const productInfo = order.items && order.items.length > 0 
                ? order.items[0].product_name + (order.items.length > 1 ? \\\` (+\\\${order.items.length - 1} daha)\\\` : '')
                : '\xDCr\xFCn yok';
                
              const quantity = order.items && order.items.length > 0 
                ? order.items[0].quantity
                : '0';
              
              row.innerHTML = \\\`
                <td>\\\${index + 1}.</td>
                <td>\\\${order.order_number}</td>
                <td>
                  <span class="badge \\\${getStatusBadgeClass(order.status)}">
                    \\\${order.status}
                  </span>
                </td>
                <td>\\\${productInfo}</td>
                <td>\\\${quantity}</td>
                <td>\\\${formatDate(order.created_at)}</td>
                <td>
                  <a href="#" class="text-primary view-order" data-order-id="\\\${order.id}">
                    <i class="bi bi-eye"></i>
                  </a>
                </td>
              \\\`;
              
              return row;
            },
            afterPageChangeCallback: () => {
              setupOrderDetailButtons(ordersData);
            }
          });
          
          setupOrderDetailButtons(ordersData);
          
        } catch (error) {
          console.error('Sayfalama ba\u015Flat\u0131l\u0131rken hata:', error);
        }
      });
    })();<\/script> </body> </html>`,
          ],
        )),
      renderComponent($$result, 'Head', $$Head, {
        title: title,
        path: path,
        'data-astro-cid-fea7qj55': true,
      }),
      renderHead(),
      renderComponent($$result, 'Topbar', $$Topbar, {
        path: path,
        'data-astro-cid-fea7qj55': true,
      }),
      renderComponent($$result, 'Sidenav', $$Sidenav, {
        path: path,
        mainPage: mainPage,
        page: page,
        'data-astro-cid-fea7qj55': true,
      }),
      updateStatusSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert" data-astro-cid-fea7qj55>
Sipariş durumu başarıyla güncellendi! Sipariş ID: ${updatedOrderId}, Yeni Durum: ${updatedStatus} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-fea7qj55></button> </div>`,
      updateStatusError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert" data-astro-cid-fea7qj55>
Sipariş durumu güncellenirken hata: ${updateStatusError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat" data-astro-cid-fea7qj55></button> </div>`,
      orders
        .slice(0, ordersPerPage)
        .map(
          (order, index) =>
            renderTemplate`<tr class="align-middle" data-astro-cid-fea7qj55> <td data-astro-cid-fea7qj55>${index + 1}.</td> <td data-astro-cid-fea7qj55>${order.order_number}</td> <td data-astro-cid-fea7qj55> <span${addAttribute(`badge ${order.status.toLowerCase() === 'pending' ? 'text-bg-warning' : order.status.toLowerCase() === 'delivered' ? 'text-bg-success' : order.status.toLowerCase() === 'cancelled' ? 'text-bg-danger' : order.status.toLowerCase() === 'processing' ? 'text-bg-info' : 'text-bg-secondary'}`, 'class')} data-astro-cid-fea7qj55> ${order.status} </span> </td> <td data-astro-cid-fea7qj55> ${order.items && order.items.length > 0 ? order.items[0].product_name + (order.items.length > 1 ? ` (+${order.items.length - 1} daha)` : '') : '\xDCr\xFCn yok'} </td> <td data-astro-cid-fea7qj55> ${order.items && order.items.length > 0 ? order.items[0].quantity : '0'} </td> <td data-astro-cid-fea7qj55>${formatDate(order.created_at)}</td> <td data-astro-cid-fea7qj55> <a href="#" class="text-primary view-order"${addAttribute(order.id, 'data-order-id')} data-astro-cid-fea7qj55> <i class="bi bi-eye" data-astro-cid-fea7qj55></i> </a> </td> </tr>`,
        ),
      renderComponent($$result, 'Pagination', $$Pagination, {
        id: 'pagination',
        currentPage: currentPage,
        totalPages: totalPages,
        size: 'sm',
        'data-astro-cid-fea7qj55': true,
      }),
      renderComponent($$result, 'Footer', $$Footer, { 'data-astro-cid-fea7qj55': true }),
      renderComponent($$result, 'Scripts', $$Scripts, {
        path: path,
        'data-astro-cid-fea7qj55': true,
      }),
      renderScript(
        $$result,
        '/Users/jin/Developments/work/ea/AdminLTE/src/pages/order-management/index.astro?astro&type=script&index=0&lang.ts',
      ),
      defineScriptVars({
        orders: JSON.stringify(orders),
        ordersPerPage,
        totalPages,
        updateStatusSuccess,
        updateStatusError,
        updatedOrderId,
        updatedStatus,
      }),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/pages/order-management/index.astro',
  undefined,
);

const $$file = '/Users/jin/Developments/work/ea/AdminLTE/src/pages/order-management/index.astro';
const $$url = '/order-management';

const _page = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      default: $$Index,
      file: $$file,
      prerender,
      url: $$url,
    },
    Symbol.toStringTag,
    { value: 'Module' },
  ),
);

const page = () => _page;

export { page };
