import {
  e as createComponent,
  r as renderTemplate,
  i as defineScriptVars,
  g as addAttribute,
  l as renderScript,
  j as renderComponent,
  k as renderHead,
  h as createAstro,
} from '../chunks/astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import { $ as $$Scripts, a as $$Head } from '../chunks/_scripts_P5Q6xZAb.mjs';
import { $ as $$Footer, a as $$Sidenav, b as $$Topbar } from '../chunks/_sidenav_BYv4xoan.mjs';
import { $ as $$Pagination } from '../chunks/_pagination_Cm6O4Y_1.mjs';
export { renderers } from '../renderers.mjs';

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) => __freeze(__defProp(cooked, 'raw', { value: __freeze(raw) }));
var _a;
const $$Astro = createAstro();
const prerender = false;
const $$Index = createComponent(
  async ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Index;
    let addSuccess = false;
    let addError = null;
    let deleteSuccess = false;
    let deleteError = null;
    let updateSuccess = false;
    let updateError = null;
    if (Astro2.request.method === 'POST') {
      const formData = await Astro2.request.formData();
      if (formData.get('_method') === 'DELETE') {
        try {
          const url2 = new URL(Astro2.request.url);
          const productId = url2.searchParams.get('id');
          if (!productId) {
            throw new Error("\xDCr\xFCn ID'si gereklidir");
          }
          console.log('\xDCr\xFCn siliniyor:', productId);
          const deleteRes = await fetch(`http://192.168.9.12:8000/api/v1/products/${productId}`, {
            method: 'DELETE',
          });
          if (deleteRes.ok) {
            deleteSuccess = true;
            console.log('\xDCr\xFCn ba\u015Far\u0131yla silindi');
            return Astro2.redirect('/product-management?deleteSuccess=true');
          } else {
            let errorMessage = `Ba\u015Far\u0131s\u0131z, durum: ${deleteRes.status}.`;
            try {
              const errorData = await deleteRes.json();
              errorMessage += ` ${errorData.message || ''}`;
            } catch (e) {
              console.error('Error while processing delete response:', e);
            }
            deleteError = errorMessage;
            console.error('\xDCr\xFCn silme ba\u015Far\u0131s\u0131z:', deleteError);
            return Astro2.redirect(
              `/product-management?deleteError=${encodeURIComponent(deleteError)}`,
            );
          }
        } catch (error) {
          deleteError = error.message || 'Bilinmeyen hata';
          console.error('\xDCr\xFCn silme iste\u011Fi i\u015Flenirken hata:', error);
          return Astro2.redirect(
            `/product-management?deleteError=${encodeURIComponent(deleteError)}`,
          );
        }
      } else if (formData.get('_method') === 'PUT') {
        try {
          const productId = formData.get('productId');
          if (!productId) {
            throw new Error("\xDCr\xFCn ID'si gereklidir");
          }
          const productData = {
            name: formData.get('productName'),
            description: formData.get('productDescription'),
            category_id: formData.get('productCategory'),
            points_required: parseInt(formData.get('productPoints')) || 0,
            stock: parseInt(formData.get('productStock')) || 0,
            status: parseInt(formData.get('productStatus')) || 0,
          };
          console.log('\xDCr\xFCn g\xFCncelleniyor:', productId, productData);
          const apiFormData = new FormData();
          apiFormData.append('product_in', JSON.stringify(productData));
          const images = formData.getAll('images');
          for (const image of images) {
            if (image instanceof File && image.size > 0) {
              apiFormData.append('images', image);
            }
          }
          const updateRes = await fetch(`http://192.168.9.12:8000/api/v1/products/${productId}`, {
            method: 'PUT',
            body: apiFormData,
          });
          if (updateRes.ok) {
            updateSuccess = true;
            console.log('\xDCr\xFCn ba\u015Far\u0131yla g\xFCncellendi');
            return Astro2.redirect('/product-management?updateSuccess=true');
          } else {
            let errorMessage = `Ba\u015Far\u0131s\u0131z, durum: ${updateRes.status}.`;
            try {
              const errorData = await updateRes.json();
              errorMessage += ` ${errorData.message || ''}`;
            } catch (e) {
              console.error('Error while processing update response:', e);
            }
            updateError = errorMessage;
            console.error('\xDCr\xFCn g\xFCncelleme ba\u015Far\u0131s\u0131z:', updateError);
            return Astro2.redirect(
              `/product-management?updateError=${encodeURIComponent(updateError)}`,
            );
          }
        } catch (error) {
          updateError = error.message || 'Bilinmeyen hata';
          console.error('\xDCr\xFCn g\xFCncelleme iste\u011Fi i\u015Flenirken hata:', error);
          return Astro2.redirect(
            `/product-management?updateError=${encodeURIComponent(updateError)}`,
          );
        }
      } else {
        try {
          const productData = {
            name: formData.get('productName'),
            description: formData.get('productDescription'),
            category_id: formData.get('productCategory'),
            points_required: parseInt(formData.get('productPoints')) || 0,
            stock: parseInt(formData.get('productStock')) || 0,
            status: parseInt(formData.get('productStatus')) || 0,
          };
          console.log('\xDCr\xFCn ekleniyor:', productData);
          const apiFormData = new FormData();
          apiFormData.append('product_in', JSON.stringify(productData));
          const images = formData.getAll('images');
          for (const image of images) {
            if (image instanceof File) {
              apiFormData.append('images', image);
            }
          }
          const addRes = await fetch('http://192.168.9.12:8000/api/v1/products/', {
            method: 'POST',
            body: apiFormData,
          });
          if (addRes.ok) {
            addSuccess = true;
            console.log('\xDCr\xFCn ba\u015Far\u0131yla eklendi');
            return Astro2.redirect('/product-management?success=true');
          } else {
            let errorMessage = `Ba\u015Far\u0131s\u0131z, durum: ${addRes.status}.`;
            try {
              const errorData = await addRes.json();
              errorMessage += ` ${errorData.message || ''}`;
            } catch (e) {
              console.error('Error while processing add response:', e);
            }
            addError = errorMessage;
            console.error('\xDCr\xFCn ekleme ba\u015Far\u0131s\u0131z:', addError);
          }
        } catch (error) {
          addError = error.message || 'Bilinmeyen hata';
          console.error('\xDCr\xFCn ekleme iste\u011Fi i\u015Flenirken hata:', error);
        }
      }
    }
    const url = new URL(Astro2.request.url);
    const success = url.searchParams.get('success');
    if (success === 'true') {
      addSuccess = true;
    }
    const deleteSuccessParam = url.searchParams.get('deleteSuccess');
    if (deleteSuccessParam === 'true') {
      deleteSuccess = true;
    }
    const deleteErrorParam = url.searchParams.get('deleteError');
    if (deleteErrorParam) {
      deleteError = decodeURIComponent(deleteErrorParam);
    }
    const updateSuccessParam = url.searchParams.get('updateSuccess');
    if (updateSuccessParam === 'true') {
      updateSuccess = true;
    }
    const updateErrorParam = url.searchParams.get('updateError');
    if (updateErrorParam) {
      updateError = decodeURIComponent(updateErrorParam);
    }
    let products = [];
    try {
      const response = await fetch('http://192.168.9.12:8000/api/v1/products/');
      products = await response.json();
      console.log('Sunucu taraf\u0131 - \xFCr\xFCnler al\u0131nd\u0131:', products.length);
    } catch (error) {
      console.error('\xDCr\xFCnleri al\u0131rken hata:', error);
    }
    let categories = [];
    try {
      const response = await fetch('http://192.168.9.12:8000/api/v1/categories');
      categories = await response.json();
    } catch (error) {
      console.error('Kategorileri al\u0131rken hata:', error);
    }
    const productsPerPage = 10;
    const totalProducts = products.length;
    const totalPages = Math.ceil(totalProducts / productsPerPage);
    const currentPage = 1;
    const title = 'AdminLTE | Dashboard v3';
    const path = '../../../dist';
    const mainPage = 'dashboard';
    const page = 'product-management';
    return renderTemplate(
      _a ||
        (_a = __template(
          [
            '<html lang="tr"> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary"> <div class="app-wrapper"> ',
            ' ',
            ' <main class="app-main"> <div class="app-content-header"> <div class="container-fluid"> <div class="row"> <div class="col-sm-6"> <h3 class="mb-0">\xDCr\xFCn Y\xF6netimi</h3> </div> <div class="col-sm-6"> <ol class="breadcrumb float-sm-end"> <li class="breadcrumb-item"><a href="#">Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page">\xDCr\xFCn Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content"> <div class="container-fluid"> ',
            ' ',
            ' ',
            ' ',
            ' ',
            ' ',
            ' <div class="row"> <div class="col-12"> <div class="card mb-4"> <div class="card-header"> <div class="row align-items-center"> <div class="col"> <h3 class="card-title mb-0">\xDCr\xFCnler</h3> </div> <div class="col-auto"> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#productModal">\n\xDCr\xFCn Ekle\n</button> </div> </div> </div> <div class="card-body p-0"> <table class="table table-striped" id="productsTable"> <thead> <tr> <th style="width: 10px">#</th> <th>Resim</th> <th>\xDCr\xFCn Ad\u0131</th> <th>Stok</th> <th>Durum</th> <th>D\xFCzenle</th> <th>Sil</th> </tr> </thead> <tbody> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix"> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ' <!-- Include Bootstrap JavaScript --> ',
            ' <div class="modal fade" id="productModal" tabindex="-1" aria-labelledby="productModalLabel" aria-hidden="true"> <div class="modal-dialog modal-lg"> <div class="modal-content"> <form id="productForm" method="POST" enctype="multipart/form-data"> <input type="hidden" id="productId" name="productId" value=""> <input type="hidden" id="methodType" name="_method" value=""> <div class="modal-header"> <h5 class="modal-title" id="productModalLabel">\xDCr\xFCn Ekle</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button> </div> <div class="modal-body"> <div id="formFeedback" class="alert d-none" role="alert"></div> <div class="mb-3"> <label for="productName" class="form-label">\xDCr\xFCn Ad\u0131</label> <input type="text" class="form-control" id="productName" name="productName" required> </div> <div class="mb-3"> <label for="productDescription" class="form-label">A\xE7\u0131klama</label> <textarea class="form-control" id="productDescription" name="productDescription" rows="3" required></textarea> </div> <div class="row"> <div class="col-md-6 mb-3"> <label for="productCategory" class="form-label">Kategori</label> <select class="form-select" id="productCategory" name="productCategory" required> <option value="">Kategori Se\xE7in</option> ',
            ' </select> </div> <div class="col-md-6 mb-3"> <label for="productPoints" class="form-label">Gerekli Puanlar</label> <input type="number" class="form-control" id="productPoints" name="productPoints" min="0" required> </div> </div> <div class="row"> <div class="col-md-6 mb-3"> <label for="productStock" class="form-label">Stok</label> <input type="number" class="form-control" id="productStock" name="productStock" min="0" required> </div> <div class="col-md-6 mb-3"> <label for="productStatus" class="form-label">Durum</label> <select class="form-select" id="productStatus" name="productStatus" required> <option value="1">Aktif</option> <option value="0">Pasif</option> </select> </div> </div> <div class="mb-3"> <label for="productImages" class="form-label">\xDCr\xFCn Resimleri</label> <input type="file" class="form-control" id="productImages" name="images" accept="image/webp,image/jpeg,image/jpg,image/png" multiple> <div class="form-text" id="imagesHelp">\nDesteklenen formatlar: WEBP, JPEG, JPG, PNG. Birden fazla resim se\xE7ebilirsiniz.\n</div> </div> <div id="imagePreview" class="row mt-3"></div> <div id="currentImages" class="row mt-3 d-none"> <h6>Mevcut Resimler</h6> </div> </div> <div class="modal-footer"> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button> <button type="submit" class="btn btn-primary" id="saveButton">\xDCr\xFCn\xFC Kaydet</button> </div> </form> </div> </div> </div> <script>(function(){',
            `
      document.addEventListener('DOMContentLoaded', () => {
        const productModal = document.getElementById('productModal');
        const productForm = document.getElementById('productForm');
        const productModalLabel = document.getElementById('productModalLabel');
        const productId = document.getElementById('productId');
        const methodType = document.getElementById('methodType');
        const saveButton = document.getElementById('saveButton');
        const imagePreviewContainer = document.getElementById('imagePreview');
        const currentImagesContainer = document.getElementById('currentImages');
        const imagesInput = document.getElementById('productImages');
        const imagesHelp = document.getElementById('imagesHelp');
        const productCategorySelect = document.getElementById('productCategory');
        
        const productsData = JSON.parse(products);
        const categoriesData = JSON.parse(categories);
        
        function initializeAddModal() {
          productModalLabel.textContent = '\xDCr\xFCn Ekle';
          saveButton.textContent = '\xDCr\xFCn\xFC Kaydet';
          productId.value = '';
          methodType.value = '';
          productForm.reset();
          imagePreviewContainer.innerHTML = '';
          currentImagesContainer.classList.add('d-none');
          currentImagesContainer.innerHTML = '<h6>Mevcut Resimler</h6>';
          imagesInput.required = true;
          imagesHelp.textContent = 'Desteklenen formatlar: WEBP, JPEG, JPG, PNG. Birden fazla resim se\xE7ebilirsiniz.';
        }
        
        function initializeEditModal(product) {
          productModalLabel.textContent = '\xDCr\xFCn\xFC D\xFCzenle';
          saveButton.textContent = '\xDCr\xFCn\xFC G\xFCncelle';
          productId.value = product.id;
          methodType.value = 'PUT';
          
          document.getElementById('productName').value = product.name;
          document.getElementById('productDescription').value = product.description;
          document.getElementById('productCategory').value = product.category_id;
          document.getElementById('productPoints').value = product.points_required;
          document.getElementById('productStock').value = product.stock;
          document.getElementById('productStatus').value = product.status;
          
          imagesInput.required = false;
          imagesHelp.textContent = 'Mevcut resimleri de\u011Fi\u015Ftirmek i\xE7in yeni resimler y\xFCkleyin (iste\u011Fe ba\u011Fl\u0131).';
          
          if (product.images && product.images.length > 0) {
            currentImagesContainer.classList.remove('d-none');
            const imagesRow = document.createElement('div');
            imagesRow.className = 'row mt-2';
            
            product.images.forEach(image => {
              const col = document.createElement('div');
              col.className = 'col-md-3 mb-2';
              
              const imgContainer = document.createElement('div');
              imgContainer.className = 'img-thumbnail';
              imgContainer.style.height = '150px';
              imgContainer.style.display = 'flex';
              imgContainer.style.alignItems = 'center';
              imgContainer.style.justifyContent = 'center';
              
              const img = document.createElement('img');
              img.src = image;
              img.alt = \`\xDCr\xFCn resmi\`;
              img.className = 'img-fluid';
              img.style.maxHeight = '130px';
              img.style.maxWidth = '90%';
              
              imgContainer.appendChild(img);
              col.appendChild(imgContainer);
              imagesRow.appendChild(col);
            });
            
            currentImagesContainer.appendChild(imagesRow);
          } else {
            currentImagesContainer.classList.add('d-none');
          }
        }
        
        if (window.location.search.includes('success=true') || 
            window.location.search.includes('deleteSuccess=true') ||
            window.location.search.includes('deleteError=') ||
            window.location.search.includes('updateSuccess=true') ||
            window.location.search.includes('updateError=')) {
          const cleanUrl = window.location.pathname;
          window.history.replaceState({}, document.title, cleanUrl);
        }
        
        productModal.addEventListener('show.bs.modal', function (event) {
          const button = event.relatedTarget;
          
          const productIdValue = button.getAttribute('data-product-id');
          
          if (productIdValue) {
            const product = productsData.find(p => p.id.toString() === productIdValue);
            if (product) {
              initializeEditModal(product);
            } else {
              console.error('\xDCr\xFCn bulunamad\u0131:', productIdValue);
              const modal = bootstrap.Modal.getInstance(productModal);
              if (modal) modal.hide();
            }
          } else {
            initializeAddModal();
          }
        });
        
        productModal.addEventListener('hidden.bs.modal', function () {
          productForm.reset();
          imagePreviewContainer.innerHTML = '';
          currentImagesContainer.classList.add('d-none');
          currentImagesContainer.innerHTML = '<h6>Mevcut Resimler</h6>';
        });
        
        imagesInput.addEventListener('change', function(e) {
          imagePreviewContainer.innerHTML = '';
          
          const files = e.target.files;
          for (let i = 0; i < files.length; i++) {
            const file = files[i];
            
            if (!file.type.match('image.*')) {
              continue;
            }
            
            const reader = new FileReader();
            
            reader.onload = function(e) {
              const col = document.createElement('div');
              col.className = 'col-md-3 mb-2';
              
              const imgContainer = document.createElement('div');
              imgContainer.className = 'img-thumbnail';
              imgContainer.style.height = '150px';
              imgContainer.style.display = 'flex';
              imgContainer.style.alignItems = 'center';
              imgContainer.style.justifyContent = 'center';
              imgContainer.style.position = 'relative';
              
              const img = document.createElement('img');
              img.src = e.target.result;
              img.className = 'img-fluid';
              img.style.maxHeight = '130px';
              img.style.maxWidth = '90%';
              
              const removeBtn = document.createElement('div');
              removeBtn.innerHTML = '\xD7';
              removeBtn.style.position = 'absolute';
              removeBtn.style.top = '5px';
              removeBtn.style.right = '5px';
              removeBtn.style.backgroundColor = 'rgba(255, 255, 255, 0.7)';
              removeBtn.style.width = '20px';
              removeBtn.style.height = '20px';
              removeBtn.style.borderRadius = '50%';
              removeBtn.style.textAlign = 'center';
              removeBtn.style.lineHeight = '18px';
              removeBtn.style.cursor = 'pointer';
              
              removeBtn.addEventListener('click', function() {
                col.remove();
              });
              
              imgContainer.appendChild(img);
              imgContainer.appendChild(removeBtn);
              col.appendChild(imgContainer);
              imagePreviewContainer.appendChild(col);
            };
            
            reader.readAsDataURL(file);
          }
        });
        
        document.addEventListener('click', function(e) {
          const deleteBtn = e.target.closest('.delete-product');
          if (deleteBtn) {
            e.preventDefault();
            
            const productId = deleteBtn.getAttribute('data-product-id');
            if (!productId) return;
            
            if (confirm('Bu \xFCr\xFCn\xFC silmek istedi\u011Finize emin misiniz? Bu i\u015Flem geri al\u0131namaz.')) {
              const form = document.createElement('form');
              form.method = 'POST';
              form.action = \`?id=\${productId}\`;
              
              const methodInput = document.createElement('input');
              methodInput.type = 'hidden';
              methodInput.name = '_method';
              methodInput.value = 'DELETE';
              form.appendChild(methodInput);
              
              document.body.appendChild(form);
              form.submit();
            }
          }
        });
        
        window.initPagination({
          paginationId: 'pagination',
          tableId: 'productsTable',
          dataArray: productsData,
          itemsPerPage: productsPerPage,
          totalPages: totalPages,
          renderItemCallback: (product, index) => {
            const row = document.createElement('tr');
            row.className = 'align-middle';
            row.innerHTML = \`
              <td>\${index + 1}.</td>
              <td>
                <img 
                  src="\${product.thumbnail}" 
                  alt="\${product.name}" 
                  class="img-thumbnail" 
                  style="width: 50px; height: auto;" 
                  onerror="this.onerror=null; this.src='\${window.location.origin}/dist/assets/img/default-150x150.png'"
                />
              </td>
              <td>\${product.name}</td>
              <td>\${product.stock}</td>
              <td>
                \${product.status === 1 ? 
                  '<span class="badge text-bg-success">Aktif</span>' : 
                  '<span class="badge text-bg-danger">Pasif</span>'}
              </td>
              <td>
                <a href="#" class="text-primary me-2 edit-product" data-bs-toggle="modal" data-bs-target="#productModal" data-product-id="\${product.id}">
                  <i class="bi bi-pencil-square"></i>
                </a>
              </td>
              <td>
                <a href="#" class="text-danger me-2 delete-product" data-product-id="\${product.id}">
                  <i class="bi bi-eraser"></i>
                  </a>
              </td>
                \`;
            
            return row;
          },
          afterPageChangeCallback: () => {
          }
        });

        categoriesData.forEach(category => {
          const option = document.createElement('option');
          option.value = category.code;
          option.textContent = category.name;
          productCategorySelect.appendChild(option);
        });

        // Example usage of addSuccess
        if (addSuccess) {
          alert('\xDCr\xFCn ba\u015Far\u0131yla eklendi!');
        }

        // Example usage of deleteSuccess
        if (deleteSuccess) {
          alert('\xDCr\xFCn ba\u015Far\u0131yla silindi!');
        }

        // Example usage of updateSuccess
        if (updateSuccess) {
          alert('\xDCr\xFCn ba\u015Far\u0131yla g\xFCncellendi!');
        }
      });
    })();<\/script> </body> </html>`,
          ],
          [
            '<html lang="tr"> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary"> <div class="app-wrapper"> ',
            ' ',
            ' <main class="app-main"> <div class="app-content-header"> <div class="container-fluid"> <div class="row"> <div class="col-sm-6"> <h3 class="mb-0">\xDCr\xFCn Y\xF6netimi</h3> </div> <div class="col-sm-6"> <ol class="breadcrumb float-sm-end"> <li class="breadcrumb-item"><a href="#">Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page">\xDCr\xFCn Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content"> <div class="container-fluid"> ',
            ' ',
            ' ',
            ' ',
            ' ',
            ' ',
            ' <div class="row"> <div class="col-12"> <div class="card mb-4"> <div class="card-header"> <div class="row align-items-center"> <div class="col"> <h3 class="card-title mb-0">\xDCr\xFCnler</h3> </div> <div class="col-auto"> <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#productModal">\n\xDCr\xFCn Ekle\n</button> </div> </div> </div> <div class="card-body p-0"> <table class="table table-striped" id="productsTable"> <thead> <tr> <th style="width: 10px">#</th> <th>Resim</th> <th>\xDCr\xFCn Ad\u0131</th> <th>Stok</th> <th>Durum</th> <th>D\xFCzenle</th> <th>Sil</th> </tr> </thead> <tbody> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix"> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> ',
            ' <!-- Include Bootstrap JavaScript --> ',
            ' <div class="modal fade" id="productModal" tabindex="-1" aria-labelledby="productModalLabel" aria-hidden="true"> <div class="modal-dialog modal-lg"> <div class="modal-content"> <form id="productForm" method="POST" enctype="multipart/form-data"> <input type="hidden" id="productId" name="productId" value=""> <input type="hidden" id="methodType" name="_method" value=""> <div class="modal-header"> <h5 class="modal-title" id="productModalLabel">\xDCr\xFCn Ekle</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button> </div> <div class="modal-body"> <div id="formFeedback" class="alert d-none" role="alert"></div> <div class="mb-3"> <label for="productName" class="form-label">\xDCr\xFCn Ad\u0131</label> <input type="text" class="form-control" id="productName" name="productName" required> </div> <div class="mb-3"> <label for="productDescription" class="form-label">A\xE7\u0131klama</label> <textarea class="form-control" id="productDescription" name="productDescription" rows="3" required></textarea> </div> <div class="row"> <div class="col-md-6 mb-3"> <label for="productCategory" class="form-label">Kategori</label> <select class="form-select" id="productCategory" name="productCategory" required> <option value="">Kategori Se\xE7in</option> ',
            ' </select> </div> <div class="col-md-6 mb-3"> <label for="productPoints" class="form-label">Gerekli Puanlar</label> <input type="number" class="form-control" id="productPoints" name="productPoints" min="0" required> </div> </div> <div class="row"> <div class="col-md-6 mb-3"> <label for="productStock" class="form-label">Stok</label> <input type="number" class="form-control" id="productStock" name="productStock" min="0" required> </div> <div class="col-md-6 mb-3"> <label for="productStatus" class="form-label">Durum</label> <select class="form-select" id="productStatus" name="productStatus" required> <option value="1">Aktif</option> <option value="0">Pasif</option> </select> </div> </div> <div class="mb-3"> <label for="productImages" class="form-label">\xDCr\xFCn Resimleri</label> <input type="file" class="form-control" id="productImages" name="images" accept="image/webp,image/jpeg,image/jpg,image/png" multiple> <div class="form-text" id="imagesHelp">\nDesteklenen formatlar: WEBP, JPEG, JPG, PNG. Birden fazla resim se\xE7ebilirsiniz.\n</div> </div> <div id="imagePreview" class="row mt-3"></div> <div id="currentImages" class="row mt-3 d-none"> <h6>Mevcut Resimler</h6> </div> </div> <div class="modal-footer"> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button> <button type="submit" class="btn btn-primary" id="saveButton">\xDCr\xFCn\xFC Kaydet</button> </div> </form> </div> </div> </div> <script>(function(){',
            `
      document.addEventListener('DOMContentLoaded', () => {
        const productModal = document.getElementById('productModal');
        const productForm = document.getElementById('productForm');
        const productModalLabel = document.getElementById('productModalLabel');
        const productId = document.getElementById('productId');
        const methodType = document.getElementById('methodType');
        const saveButton = document.getElementById('saveButton');
        const imagePreviewContainer = document.getElementById('imagePreview');
        const currentImagesContainer = document.getElementById('currentImages');
        const imagesInput = document.getElementById('productImages');
        const imagesHelp = document.getElementById('imagesHelp');
        const productCategorySelect = document.getElementById('productCategory');
        
        const productsData = JSON.parse(products);
        const categoriesData = JSON.parse(categories);
        
        function initializeAddModal() {
          productModalLabel.textContent = '\xDCr\xFCn Ekle';
          saveButton.textContent = '\xDCr\xFCn\xFC Kaydet';
          productId.value = '';
          methodType.value = '';
          productForm.reset();
          imagePreviewContainer.innerHTML = '';
          currentImagesContainer.classList.add('d-none');
          currentImagesContainer.innerHTML = '<h6>Mevcut Resimler</h6>';
          imagesInput.required = true;
          imagesHelp.textContent = 'Desteklenen formatlar: WEBP, JPEG, JPG, PNG. Birden fazla resim se\xE7ebilirsiniz.';
        }
        
        function initializeEditModal(product) {
          productModalLabel.textContent = '\xDCr\xFCn\xFC D\xFCzenle';
          saveButton.textContent = '\xDCr\xFCn\xFC G\xFCncelle';
          productId.value = product.id;
          methodType.value = 'PUT';
          
          document.getElementById('productName').value = product.name;
          document.getElementById('productDescription').value = product.description;
          document.getElementById('productCategory').value = product.category_id;
          document.getElementById('productPoints').value = product.points_required;
          document.getElementById('productStock').value = product.stock;
          document.getElementById('productStatus').value = product.status;
          
          imagesInput.required = false;
          imagesHelp.textContent = 'Mevcut resimleri de\u011Fi\u015Ftirmek i\xE7in yeni resimler y\xFCkleyin (iste\u011Fe ba\u011Fl\u0131).';
          
          if (product.images && product.images.length > 0) {
            currentImagesContainer.classList.remove('d-none');
            const imagesRow = document.createElement('div');
            imagesRow.className = 'row mt-2';
            
            product.images.forEach(image => {
              const col = document.createElement('div');
              col.className = 'col-md-3 mb-2';
              
              const imgContainer = document.createElement('div');
              imgContainer.className = 'img-thumbnail';
              imgContainer.style.height = '150px';
              imgContainer.style.display = 'flex';
              imgContainer.style.alignItems = 'center';
              imgContainer.style.justifyContent = 'center';
              
              const img = document.createElement('img');
              img.src = image;
              img.alt = \\\`\xDCr\xFCn resmi\\\`;
              img.className = 'img-fluid';
              img.style.maxHeight = '130px';
              img.style.maxWidth = '90%';
              
              imgContainer.appendChild(img);
              col.appendChild(imgContainer);
              imagesRow.appendChild(col);
            });
            
            currentImagesContainer.appendChild(imagesRow);
          } else {
            currentImagesContainer.classList.add('d-none');
          }
        }
        
        if (window.location.search.includes('success=true') || 
            window.location.search.includes('deleteSuccess=true') ||
            window.location.search.includes('deleteError=') ||
            window.location.search.includes('updateSuccess=true') ||
            window.location.search.includes('updateError=')) {
          const cleanUrl = window.location.pathname;
          window.history.replaceState({}, document.title, cleanUrl);
        }
        
        productModal.addEventListener('show.bs.modal', function (event) {
          const button = event.relatedTarget;
          
          const productIdValue = button.getAttribute('data-product-id');
          
          if (productIdValue) {
            const product = productsData.find(p => p.id.toString() === productIdValue);
            if (product) {
              initializeEditModal(product);
            } else {
              console.error('\xDCr\xFCn bulunamad\u0131:', productIdValue);
              const modal = bootstrap.Modal.getInstance(productModal);
              if (modal) modal.hide();
            }
          } else {
            initializeAddModal();
          }
        });
        
        productModal.addEventListener('hidden.bs.modal', function () {
          productForm.reset();
          imagePreviewContainer.innerHTML = '';
          currentImagesContainer.classList.add('d-none');
          currentImagesContainer.innerHTML = '<h6>Mevcut Resimler</h6>';
        });
        
        imagesInput.addEventListener('change', function(e) {
          imagePreviewContainer.innerHTML = '';
          
          const files = e.target.files;
          for (let i = 0; i < files.length; i++) {
            const file = files[i];
            
            if (!file.type.match('image.*')) {
              continue;
            }
            
            const reader = new FileReader();
            
            reader.onload = function(e) {
              const col = document.createElement('div');
              col.className = 'col-md-3 mb-2';
              
              const imgContainer = document.createElement('div');
              imgContainer.className = 'img-thumbnail';
              imgContainer.style.height = '150px';
              imgContainer.style.display = 'flex';
              imgContainer.style.alignItems = 'center';
              imgContainer.style.justifyContent = 'center';
              imgContainer.style.position = 'relative';
              
              const img = document.createElement('img');
              img.src = e.target.result;
              img.className = 'img-fluid';
              img.style.maxHeight = '130px';
              img.style.maxWidth = '90%';
              
              const removeBtn = document.createElement('div');
              removeBtn.innerHTML = '\xD7';
              removeBtn.style.position = 'absolute';
              removeBtn.style.top = '5px';
              removeBtn.style.right = '5px';
              removeBtn.style.backgroundColor = 'rgba(255, 255, 255, 0.7)';
              removeBtn.style.width = '20px';
              removeBtn.style.height = '20px';
              removeBtn.style.borderRadius = '50%';
              removeBtn.style.textAlign = 'center';
              removeBtn.style.lineHeight = '18px';
              removeBtn.style.cursor = 'pointer';
              
              removeBtn.addEventListener('click', function() {
                col.remove();
              });
              
              imgContainer.appendChild(img);
              imgContainer.appendChild(removeBtn);
              col.appendChild(imgContainer);
              imagePreviewContainer.appendChild(col);
            };
            
            reader.readAsDataURL(file);
          }
        });
        
        document.addEventListener('click', function(e) {
          const deleteBtn = e.target.closest('.delete-product');
          if (deleteBtn) {
            e.preventDefault();
            
            const productId = deleteBtn.getAttribute('data-product-id');
            if (!productId) return;
            
            if (confirm('Bu \xFCr\xFCn\xFC silmek istedi\u011Finize emin misiniz? Bu i\u015Flem geri al\u0131namaz.')) {
              const form = document.createElement('form');
              form.method = 'POST';
              form.action = \\\`?id=\\\${productId}\\\`;
              
              const methodInput = document.createElement('input');
              methodInput.type = 'hidden';
              methodInput.name = '_method';
              methodInput.value = 'DELETE';
              form.appendChild(methodInput);
              
              document.body.appendChild(form);
              form.submit();
            }
          }
        });
        
        window.initPagination({
          paginationId: 'pagination',
          tableId: 'productsTable',
          dataArray: productsData,
          itemsPerPage: productsPerPage,
          totalPages: totalPages,
          renderItemCallback: (product, index) => {
            const row = document.createElement('tr');
            row.className = 'align-middle';
            row.innerHTML = \\\`
              <td>\\\${index + 1}.</td>
              <td>
                <img 
                  src="\\\${product.thumbnail}" 
                  alt="\\\${product.name}" 
                  class="img-thumbnail" 
                  style="width: 50px; height: auto;" 
                  onerror="this.onerror=null; this.src='\\\${window.location.origin}/dist/assets/img/default-150x150.png'"
                />
              </td>
              <td>\\\${product.name}</td>
              <td>\\\${product.stock}</td>
              <td>
                \\\${product.status === 1 ? 
                  '<span class="badge text-bg-success">Aktif</span>' : 
                  '<span class="badge text-bg-danger">Pasif</span>'}
              </td>
              <td>
                <a href="#" class="text-primary me-2 edit-product" data-bs-toggle="modal" data-bs-target="#productModal" data-product-id="\\\${product.id}">
                  <i class="bi bi-pencil-square"></i>
                </a>
              </td>
              <td>
                <a href="#" class="text-danger me-2 delete-product" data-product-id="\\\${product.id}">
                  <i class="bi bi-eraser"></i>
                  </a>
              </td>
                \\\`;
            
            return row;
          },
          afterPageChangeCallback: () => {
          }
        });

        categoriesData.forEach(category => {
          const option = document.createElement('option');
          option.value = category.code;
          option.textContent = category.name;
          productCategorySelect.appendChild(option);
        });

        // Example usage of addSuccess
        if (addSuccess) {
          alert('\xDCr\xFCn ba\u015Far\u0131yla eklendi!');
        }

        // Example usage of deleteSuccess
        if (deleteSuccess) {
          alert('\xDCr\xFCn ba\u015Far\u0131yla silindi!');
        }

        // Example usage of updateSuccess
        if (updateSuccess) {
          alert('\xDCr\xFCn ba\u015Far\u0131yla g\xFCncellendi!');
        }
      });
    })();<\/script> </body> </html>`,
          ],
        )),
      renderComponent($$result, 'Head', $$Head, { title: title, path: path }),
      renderHead(),
      renderComponent($$result, 'Topbar', $$Topbar, { path: path }),
      renderComponent($$result, 'Sidenav', $$Sidenav, {
        path: path,
        mainPage: mainPage,
        page: page,
      }),
      addSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert">
Ürün başarıyla eklendi!
<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button> </div>`,
      addError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert">
Ürün eklerken hata: ${addError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button> </div>`,
      deleteSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert">
Ürün başarıyla silindi!
<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button> </div>`,
      deleteError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert">
Ürün silerken hata: ${deleteError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button> </div>`,
      updateSuccess &&
        renderTemplate`<div class="alert alert-success alert-dismissible fade show" role="alert">
Ürün başarıyla güncellendi!
<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button> </div>`,
      updateError &&
        renderTemplate`<div class="alert alert-danger alert-dismissible fade show" role="alert">
Ürün güncellerken hata: ${updateError} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button> </div>`,
      products
        .slice(0, productsPerPage)
        .map(
          (product, index) =>
            renderTemplate`<tr class="align-middle"> <td>${index + 1}.</td> <td> <img${addAttribute(product.thumbnail, 'src')}${addAttribute(product.name, 'alt')} class="img-thumbnail" style="width: 50px; height: auto;"${addAttribute(`this.onerror=null; this.src='${path}/assets/img/default-150x150.png'`, 'onerror')}> </td> <td>${product.name}</td> <td>${product.stock}</td> <td> ${product.status === 1 ? renderTemplate`<span class="badge text-bg-success">Aktif</span>` : renderTemplate`<span class="badge text-bg-danger">Pasif</span>`} </td> <td> <a href="#" class="text-primary me-2 edit-product" data-bs-toggle="modal" data-bs-target="#productModal"${addAttribute(product.id, 'data-product-id')}> <i class="bi bi-pencil-square"></i> </a> </td> <td> <a href="#" class="text-danger me-2 delete-product"${addAttribute(product.id, 'data-product-id')}> <i class="bi bi-eraser"></i> </a> </td> </tr>`,
        ),
      renderComponent($$result, 'Pagination', $$Pagination, {
        id: 'pagination',
        currentPage: currentPage,
        totalPages: totalPages,
        size: 'sm',
      }),
      renderComponent($$result, 'Footer', $$Footer, {}),
      renderComponent($$result, 'Scripts', $$Scripts, { path: path }),
      renderScript(
        $$result,
        '/Users/jin/Developments/work/ea/AdminLTE/src/pages/product-management/index.astro?astro&type=script&index=0&lang.ts',
      ),
      categories.map(
        (category) =>
          renderTemplate`<option${addAttribute(category.code, 'value')}>${category.name}</option>`,
      ),
      defineScriptVars({
        categories: JSON.stringify(categories),
        products: JSON.stringify(products),
        productsPerPage,
        totalPages,
        addSuccess,
        deleteSuccess,
        updateSuccess,
      }),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/pages/product-management/index.astro',
  undefined,
);

const $$file = '/Users/jin/Developments/work/ea/AdminLTE/src/pages/product-management/index.astro';
const $$url = '/product-management';

const _page = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      default: $$Index,
      file: $$file,
      prerender,
      url: $$url,
    },
    Symbol.toStringTag,
    { value: 'Module' },
  ),
);

const page = () => _page;

export { page };
