import {
  e as createComponent,
  r as renderTemplate,
  i as defineScriptVars,
  j as renderComponent,
  g as addAttribute,
  k as renderHead,
  h as createAstro,
} from '../chunks/astro/server_nEfbMHZV.mjs';
import 'kleur/colors';
import { $ as $$Scripts, a as $$Head } from '../chunks/_scripts_P5Q6xZAb.mjs';
import { $ as $$Footer, a as $$Sidenav, b as $$Topbar } from '../chunks/_sidenav_BYv4xoan.mjs';
import { $ as $$Pagination } from '../chunks/_pagination_Cm6O4Y_1.mjs';
export { renderers } from '../renderers.mjs';

// src/utils/imageUtils.js
const getUserProfileImage = (user) => {
  const baseUrl = 'https://s3.eu-central-1.amazonaws.com/adimsayar/'; // 기본 URL
  const defaultAvatar = `${baseUrl}profile/default_avatar.png`; // 기본 아바타 이미지 URL

  if (user.profile_image) {
    // 프로필 이미지가 있는 경우
    if (user.profile_image.startsWith('http')) {
      // 이미지가 이미 완전한 URL인 경우
      return user.profile_image;
    } else {
      // 상대 경로인 경우
      return `${baseUrl}${user.profile_image}`;
    }
  } else {
    // 프로필 이미지가 없는 경우 기본 아바타 사용
    return defaultAvatar;
  }
};

var __freeze = Object.freeze;
var __defProp = Object.defineProperty;
var __template = (cooked, raw) => __freeze(__defProp(cooked, 'raw', { value: __freeze(raw) }));
var _a;
const $$Astro = createAstro();
const prerender = false;
const $$Index = createComponent(
  async ($$result, $$props, $$slots) => {
    const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
    Astro2.self = $$Index;
    let users = [];
    let usersDetails = {};
    let deleteSuccess = false;
    let deletedUserId = null;
    let updateSuccess = false;
    let updatedUserId = null;
    if (Astro2.request.method === 'POST') {
      try {
        const formData = await Astro2.request.formData();
        const action = formData.get('action');
        if (action === 'delete') {
          const userId = formData.get('userId');
          deletedUserId = userId;
          console.log(`Sunucu taraf\u0131: Kullan\u0131c\u0131 siliniyor, ID ${userId}`);
          const response = await fetch(`http://192.168.9.12:8000/api/v1/users/${userId}`, {
            method: 'DELETE',
          });
          if (!response.ok) {
            throw new Error(`Kullan\u0131c\u0131 silinemedi: ${response.status}`);
          }
          deleteSuccess = true;
          console.log(
            `Sunucu taraf\u0131: Kullan\u0131c\u0131 ${userId} ba\u015Far\u0131yla silindi`,
          );
        } else if (action === 'update') {
          const userId = formData.get('userId');
          updatedUserId = userId;
          const userData = {
            first_name: formData.get('first_name'),
            last_name: formData.get('last_name'),
            email: formData.get('email'),
            phone_code: formData.get('phone_code'),
            phone: formData.get('phone'),
            gender: formData.get('gender'),
            birth_date: formData.get('birth_date'),
            daily_step_goal: formData.get('daily_step_goal'),
            status: Number(formData.get('status')),
          };
          console.log(`Sunucu taraf\u0131: Kullan\u0131c\u0131 g\xFCncelleniyor, ID ${userId}`);
          console.log('G\xFCncelleme y\xFCk\xFC:', userData);
          const response = await fetch(`http://192.168.9.12:8000/api/v1/admin/users/${userId}`, {
            method: 'PUT',
            headers: {
              'Content-Type': 'application/json',
            },
            body: JSON.stringify(userData),
          });
          if (!response.ok) {
            throw new Error(`Kullan\u0131c\u0131 g\xFCncellenemedi: ${response.status}`);
          }
          updateSuccess = true;
          console.log(
            `Sunucu taraf\u0131: Kullan\u0131c\u0131 ${userId} ba\u015Far\u0131yla g\xFCncellendi`,
          );
        }
      } catch (error) {
        console.error('\u0130stek i\u015Flenirken hata:', error);
      }
    }
    try {
      const response = await fetch('http://192.168.9.12:8000/api/v1/users');
      users = await response.json();
      console.log(
        'Sunucu taraf\u0131 kayd\u0131 - Kullan\u0131c\u0131lar al\u0131nd\u0131:',
        users.length,
      );
      for (const user of users) {
        try {
          const detailResponse = await fetch(`http://192.168.9.12:8000/api/v1/users/${user.id}`);
          if (detailResponse.ok) {
            const userData = await detailResponse.json();
            usersDetails[user.id] = userData;
          }
        } catch (detailError) {
          console.error(
            `Kullan\u0131c\u0131 ${user.id} i\xE7in detaylar al\u0131n\u0131rken hata:`,
            detailError,
          );
        }
      }
      console.log(
        'Sunucu taraf\u0131 kayd\u0131 - T\xFCm kullan\u0131c\u0131lar i\xE7in detaylar al\u0131nd\u0131',
      );
    } catch (error) {
      console.error('Kullan\u0131c\u0131lar al\u0131n\u0131rken hata:', error);
    }
    const usersWithImages = users.map((user) => ({
      ...user,
      profileImage: getUserProfileImage(user),
    }));
    const usersPerPage = 10;
    const totalUsers = users.length;
    const totalPages = Math.ceil(totalUsers / usersPerPage);
    const currentPage = 1;
    const title = 'AdminLTE | Dashboard v3';
    const path = '../../../dist';
    const mainPage = 'dashboard';
    const page = 'user-management';
    return renderTemplate(
      _a ||
        (_a = __template(
          [
            '<html lang="tr"> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary"> <div class="app-wrapper"> ',
            ' ',
            ' <main class="app-main"> <div class="app-content-header"> <div class="container-fluid"> <div class="row"> <div class="col-sm-6"> <h3 class="mb-0">Kullan\u0131c\u0131 Y\xF6netimi</h3> </div> <div class="col-sm-6"> <ol class="breadcrumb float-sm-end"> <li class="breadcrumb-item"><a href="#">Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page">Kullan\u0131c\u0131 Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content"> <div class="container-fluid"> <div class="row"> <div class="col-12"> <div class="card mb-4"> <div class="card-header"> <h3 class="card-title">Kullan\u0131c\u0131lar</h3> </div> <div class="card-body p-0"> <table class="table table-striped" id="usersTable"> <thead> <tr> <th style="width: 10px">#</th> <th>Kullan\u0131c\u0131</th> <th>Telefon</th> <th>Do\u011Fum Tarihi</th> <th>D\xFCzenle/Sil</th> </tr> </thead> <tbody> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix"> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> <form id="deleteUserForm" method="POST" style="display: none;"> <input type="hidden" name="action" value="delete"> <input type="hidden" name="userId" id="deleteUserId"> </form> <div class="modal fade" id="userDetailModal" tabindex="-1" aria-labelledby="userDetailModalLabel" aria-hidden="true"> <div class="modal-dialog modal-lg"> <div class="modal-content"> <div class="modal-header"> <h5 class="modal-title" id="userDetailModalLabel">Kullan\u0131c\u0131 Detaylar\u0131</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button> </div> <div class="modal-body"> <div id="modal-loading" class="text-center"> <div class="spinner-border text-primary" role="status"> <span class="visually-hidden">Y\xFCkleniyor...</span> </div> <p class="mt-2">Kullan\u0131c\u0131 verileri y\xFCkleniyor...</p> </div> <div id="modal-error" class="alert alert-danger d-none" role="alert">\nKullan\u0131c\u0131 verileri y\xFCklenirken hata olu\u015Ftu. L\xFCtfen tekrar deneyin.\n</div> <form id="userDetailForm" class="d-none" method="POST"> <input type="hidden" name="action" value="update"> <input type="hidden" name="userId" id="updateUserId"> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">Ad</label> <input type="text" class="form-control" id="firstName" name="first_name"> </div> <div class="col-md-6"> <label class="form-label">Soyad</label> <input type="text" class="form-control" id="lastName" name="last_name"> </div> </div> <div class="row mb-3"> <div class="col-md-12"> <label class="form-label">E-posta</label> <input type="email" class="form-control" id="email" name="email"> </div> </div> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">Telefon Kodu</label> <input type="text" class="form-control" id="phoneCode" name="phone_code"> </div> <div class="col-md-6"> <label class="form-label">Telefon</label> <input type="text" class="form-control" id="phone" name="phone"> </div> </div> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">Cinsiyet</label> <select class="form-select" id="gender" name="gender"> <option value="M">Erkek</option> <option value="F">Kad\u0131n</option> </select> </div> <div class="col-md-6"> <label class="form-label">Do\u011Fum Tarihi</label> <input type="date" class="form-control" id="birthDate" name="birth_date"> </div> </div> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">G\xFCnl\xFCk Ad\u0131m Hedefi</label> <input type="number" class="form-control" id="dailyStepGoal" name="daily_step_goal"> </div> <div class="col-md-6"> <label class="form-label">Durum</label> <select class="form-select" id="status" name="status"> <option value="1">Aktif</option> <option value="0">Pasif</option> </select> </div> </div> </form> </div> <div class="modal-footer"> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button> <button type="button" class="btn btn-primary" id="saveUserDetails">De\u011Fi\u015Fiklikleri Kaydet</button> </div> </div> </div> </div> ',
            ' <script>(function(){',
            "\n      document.addEventListener('DOMContentLoaded', () => {\n        try {\n          const userData = JSON.parse(users);\n          const userDetailsData = JSON.parse(usersDetails);\n          const userDetailModal = document.getElementById('userDetailModal');\n          const userDetailForm = document.getElementById('userDetailForm');\n          const modalLoading = document.getElementById('modal-loading');\n          const modalError = document.getElementById('modal-error');\n          const deleteUserForm = document.getElementById('deleteUserForm');\n          const deleteUserIdInput = document.getElementById('deleteUserId');\n          const updateUserIdInput = document.getElementById('updateUserId');\n\n          console.log(\"userData say\u0131s\u0131:\", userData.length);\n\n          if (deleteSuccess) {\n            alert(`Kullan\u0131c\u0131 ${deletedUserId} ba\u015Far\u0131yla silindi`);\n          }\n          \n          if (updateSuccess) {\n            alert(`Kullan\u0131c\u0131 ${updatedUserId} ba\u015Far\u0131yla g\xFCncellendi`);\n          }\n\n          userDetailModal.addEventListener('show.bs.modal', (event) => {\n            userDetailForm.classList.add('d-none');\n            modalLoading.classList.remove('d-none');\n            modalError.classList.add('d-none');\n          \n            const button = event.relatedTarget;\n            const userId = button.getAttribute('data-user-id');\n            \n            try {\n              if (userDetailsData[userId]) {\n                const userData = userDetailsData[userId];\n                console.log(\"Sunucudan al\u0131nan kullan\u0131c\u0131 verisi:\", userData);\n\n                userDetailForm.querySelector('#firstName').value = userData.first_name || '';\n                userDetailForm.querySelector('#lastName').value = userData.last_name || '';\n                userDetailForm.querySelector('#email').value = userData.email || '';\n                userDetailForm.querySelector('#phoneCode').value = userData.phone_code || '';\n                userDetailForm.querySelector('#phone').value = userData.phone || '';\n                userDetailForm.querySelector('#gender').value = userData.gender || 'M';\n                userDetailForm.querySelector('#birthDate').value = userData.birth_date || '';\n                userDetailForm.querySelector('#dailyStepGoal').value = userData.daily_step_goal || '';\n                userDetailForm.querySelector('#status').value = userData.status || 1;\n                \n                updateUserIdInput.value = userId;\n\n                modalLoading.classList.add('d-none');\n                userDetailForm.classList.remove('d-none');\n              } else {\n                throw new Error(`Kullan\u0131c\u0131 ID ${userId} i\xE7in detay bilgisi bulunamad\u0131.`);\n              }\n            } catch (error) {\n              console.error('Kullan\u0131c\u0131 detaylar\u0131 g\xF6sterilirken hata:', error);\n              modalLoading.classList.add('d-none');\n              modalError.classList.remove('d-none');\n              modalError.textContent = `Hata: ${error.message}`;\n            }\n          });\n\n          document.getElementById('saveUserDetails').addEventListener('click', () => {\n            userDetailForm.submit();\n          });\n\n          window.initPagination({\n            paginationId: 'pagination',\n            tableId: 'usersTable',\n            dataArray: userData,\n            itemsPerPage: usersPerPage,\n            totalPages: totalPages,\n            renderItemCallback: (user, index) => {\n              const row = document.createElement('tr');\n              row.className = 'align-middle';\n              \n              const indexCell = document.createElement('td');\n              indexCell.textContent = (index + 1) + '.';\n              row.appendChild(indexCell);\n              \n              const userCell = document.createElement('td');\n              const img = document.createElement('img');\n              img.src = user.profileImage;\n              img.alt = `${user.first_name} ${user.last_name}`;\n              img.className = 'rounded-circle img-size-32 me-2';\n              img.dataset.profileImage = user.profile_image;\n              img.onerror = function() { \n                this.onerror = null; \n                this.src = `${path}/assets/img/default-150x150.png`; \n              };\n              userCell.appendChild(img);\n              userCell.appendChild(document.createTextNode(\n                `${user.first_name} ${user.last_name} (${user.email})`\n              ));\n              row.appendChild(userCell);\n\n              const phoneCell = document.createElement('td');\n              const phoneP = document.createElement('p');\n              phoneP.textContent = `${user.phone_code || ''} ${user.phone || ''}`;\n              phoneCell.appendChild(phoneP);\n              row.appendChild(phoneCell);\n              \n              const birthDateCell = document.createElement('td');\n              const birthDateP = document.createElement('p');\n              birthDateP.textContent = user.birth_date || '';\n              birthDateCell.appendChild(birthDateP);\n              row.appendChild(birthDateCell);\n              \n              const actionsCell = document.createElement('td');\n\n              const editLink = document.createElement('a');\n              editLink.href = '#';\n              editLink.className = 'text-secondary me-2';\n              editLink.setAttribute('data-bs-toggle', 'modal');\n              editLink.setAttribute('data-bs-target', '#userDetailModal');\n              editLink.setAttribute('data-user-id', user.id);\n              const editIcon = document.createElement('i');\n              editIcon.className = 'bi bi-pencil';\n              editLink.appendChild(editIcon);\n              \n              const removeLink = document.createElement('a');\n              removeLink.href = '#';\n              removeLink.className = 'text-secondary me-2 delete-user';\n              removeLink.setAttribute('data-user-id', user.id);\n              const removeIcon = document.createElement('i');\n              removeIcon.className = 'bi bi-eraser';\n              removeLink.appendChild(removeIcon);\n              \n              actionsCell.appendChild(editLink);\n              actionsCell.appendChild(removeLink);\n              row.appendChild(actionsCell);\n              \n              return row;\n            },\n            afterPageChangeCallback: () => {\n              document.querySelectorAll('.delete-user').forEach(button => {\n                button.addEventListener('click', function(e) {\n                  e.preventDefault();\n                  const userId = this.getAttribute('data-user-id');\n                  \n                  if (confirm('Bu kullan\u0131c\u0131y\u0131 silmek istedi\u011Finize emin misiniz?')) {\n                    deleteUserIdInput.value = userId;\n                    deleteUserForm.submit();\n                  }\n                });\n              });\n            }\n          });\n        } catch (error) {\n          console.error('Sayfalama beti\u011Finde hata:', error);\n        }\n      });\n    })();<\/script> </body> </html>",
          ],
          [
            '<html lang="tr"> <head>',
            '',
            '</head> <body class="layout-fixed sidebar-expand-lg bg-body-tertiary"> <div class="app-wrapper"> ',
            ' ',
            ' <main class="app-main"> <div class="app-content-header"> <div class="container-fluid"> <div class="row"> <div class="col-sm-6"> <h3 class="mb-0">Kullan\u0131c\u0131 Y\xF6netimi</h3> </div> <div class="col-sm-6"> <ol class="breadcrumb float-sm-end"> <li class="breadcrumb-item"><a href="#">Ana Sayfa</a></li> <li class="breadcrumb-item active" aria-current="page">Kullan\u0131c\u0131 Y\xF6netimi</li> </ol> </div> </div> </div> </div> <div class="app-content"> <div class="container-fluid"> <div class="row"> <div class="col-12"> <div class="card mb-4"> <div class="card-header"> <h3 class="card-title">Kullan\u0131c\u0131lar</h3> </div> <div class="card-body p-0"> <table class="table table-striped" id="usersTable"> <thead> <tr> <th style="width: 10px">#</th> <th>Kullan\u0131c\u0131</th> <th>Telefon</th> <th>Do\u011Fum Tarihi</th> <th>D\xFCzenle/Sil</th> </tr> </thead> <tbody> ',
            ' </tbody> </table> </div> <div class="card-footer clearfix"> ',
            ' </div> </div> </div> </div> </div> </div> </main> ',
            ' </div> <form id="deleteUserForm" method="POST" style="display: none;"> <input type="hidden" name="action" value="delete"> <input type="hidden" name="userId" id="deleteUserId"> </form> <div class="modal fade" id="userDetailModal" tabindex="-1" aria-labelledby="userDetailModalLabel" aria-hidden="true"> <div class="modal-dialog modal-lg"> <div class="modal-content"> <div class="modal-header"> <h5 class="modal-title" id="userDetailModalLabel">Kullan\u0131c\u0131 Detaylar\u0131</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button> </div> <div class="modal-body"> <div id="modal-loading" class="text-center"> <div class="spinner-border text-primary" role="status"> <span class="visually-hidden">Y\xFCkleniyor...</span> </div> <p class="mt-2">Kullan\u0131c\u0131 verileri y\xFCkleniyor...</p> </div> <div id="modal-error" class="alert alert-danger d-none" role="alert">\nKullan\u0131c\u0131 verileri y\xFCklenirken hata olu\u015Ftu. L\xFCtfen tekrar deneyin.\n</div> <form id="userDetailForm" class="d-none" method="POST"> <input type="hidden" name="action" value="update"> <input type="hidden" name="userId" id="updateUserId"> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">Ad</label> <input type="text" class="form-control" id="firstName" name="first_name"> </div> <div class="col-md-6"> <label class="form-label">Soyad</label> <input type="text" class="form-control" id="lastName" name="last_name"> </div> </div> <div class="row mb-3"> <div class="col-md-12"> <label class="form-label">E-posta</label> <input type="email" class="form-control" id="email" name="email"> </div> </div> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">Telefon Kodu</label> <input type="text" class="form-control" id="phoneCode" name="phone_code"> </div> <div class="col-md-6"> <label class="form-label">Telefon</label> <input type="text" class="form-control" id="phone" name="phone"> </div> </div> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">Cinsiyet</label> <select class="form-select" id="gender" name="gender"> <option value="M">Erkek</option> <option value="F">Kad\u0131n</option> </select> </div> <div class="col-md-6"> <label class="form-label">Do\u011Fum Tarihi</label> <input type="date" class="form-control" id="birthDate" name="birth_date"> </div> </div> <div class="row mb-3"> <div class="col-md-6"> <label class="form-label">G\xFCnl\xFCk Ad\u0131m Hedefi</label> <input type="number" class="form-control" id="dailyStepGoal" name="daily_step_goal"> </div> <div class="col-md-6"> <label class="form-label">Durum</label> <select class="form-select" id="status" name="status"> <option value="1">Aktif</option> <option value="0">Pasif</option> </select> </div> </div> </form> </div> <div class="modal-footer"> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button> <button type="button" class="btn btn-primary" id="saveUserDetails">De\u011Fi\u015Fiklikleri Kaydet</button> </div> </div> </div> </div> ',
            ' <script>(function(){',
            "\n      document.addEventListener('DOMContentLoaded', () => {\n        try {\n          const userData = JSON.parse(users);\n          const userDetailsData = JSON.parse(usersDetails);\n          const userDetailModal = document.getElementById('userDetailModal');\n          const userDetailForm = document.getElementById('userDetailForm');\n          const modalLoading = document.getElementById('modal-loading');\n          const modalError = document.getElementById('modal-error');\n          const deleteUserForm = document.getElementById('deleteUserForm');\n          const deleteUserIdInput = document.getElementById('deleteUserId');\n          const updateUserIdInput = document.getElementById('updateUserId');\n\n          console.log(\"userData say\u0131s\u0131:\", userData.length);\n\n          if (deleteSuccess) {\n            alert(\\`Kullan\u0131c\u0131 \\${deletedUserId} ba\u015Far\u0131yla silindi\\`);\n          }\n          \n          if (updateSuccess) {\n            alert(\\`Kullan\u0131c\u0131 \\${updatedUserId} ba\u015Far\u0131yla g\xFCncellendi\\`);\n          }\n\n          userDetailModal.addEventListener('show.bs.modal', (event) => {\n            userDetailForm.classList.add('d-none');\n            modalLoading.classList.remove('d-none');\n            modalError.classList.add('d-none');\n          \n            const button = event.relatedTarget;\n            const userId = button.getAttribute('data-user-id');\n            \n            try {\n              if (userDetailsData[userId]) {\n                const userData = userDetailsData[userId];\n                console.log(\"Sunucudan al\u0131nan kullan\u0131c\u0131 verisi:\", userData);\n\n                userDetailForm.querySelector('#firstName').value = userData.first_name || '';\n                userDetailForm.querySelector('#lastName').value = userData.last_name || '';\n                userDetailForm.querySelector('#email').value = userData.email || '';\n                userDetailForm.querySelector('#phoneCode').value = userData.phone_code || '';\n                userDetailForm.querySelector('#phone').value = userData.phone || '';\n                userDetailForm.querySelector('#gender').value = userData.gender || 'M';\n                userDetailForm.querySelector('#birthDate').value = userData.birth_date || '';\n                userDetailForm.querySelector('#dailyStepGoal').value = userData.daily_step_goal || '';\n                userDetailForm.querySelector('#status').value = userData.status || 1;\n                \n                updateUserIdInput.value = userId;\n\n                modalLoading.classList.add('d-none');\n                userDetailForm.classList.remove('d-none');\n              } else {\n                throw new Error(\\`Kullan\u0131c\u0131 ID \\${userId} i\xE7in detay bilgisi bulunamad\u0131.\\`);\n              }\n            } catch (error) {\n              console.error('Kullan\u0131c\u0131 detaylar\u0131 g\xF6sterilirken hata:', error);\n              modalLoading.classList.add('d-none');\n              modalError.classList.remove('d-none');\n              modalError.textContent = \\`Hata: \\${error.message}\\`;\n            }\n          });\n\n          document.getElementById('saveUserDetails').addEventListener('click', () => {\n            userDetailForm.submit();\n          });\n\n          window.initPagination({\n            paginationId: 'pagination',\n            tableId: 'usersTable',\n            dataArray: userData,\n            itemsPerPage: usersPerPage,\n            totalPages: totalPages,\n            renderItemCallback: (user, index) => {\n              const row = document.createElement('tr');\n              row.className = 'align-middle';\n              \n              const indexCell = document.createElement('td');\n              indexCell.textContent = (index + 1) + '.';\n              row.appendChild(indexCell);\n              \n              const userCell = document.createElement('td');\n              const img = document.createElement('img');\n              img.src = user.profileImage;\n              img.alt = \\`\\${user.first_name} \\${user.last_name}\\`;\n              img.className = 'rounded-circle img-size-32 me-2';\n              img.dataset.profileImage = user.profile_image;\n              img.onerror = function() { \n                this.onerror = null; \n                this.src = \\`\\${path}/assets/img/default-150x150.png\\`; \n              };\n              userCell.appendChild(img);\n              userCell.appendChild(document.createTextNode(\n                \\`\\${user.first_name} \\${user.last_name} (\\${user.email})\\`\n              ));\n              row.appendChild(userCell);\n\n              const phoneCell = document.createElement('td');\n              const phoneP = document.createElement('p');\n              phoneP.textContent = \\`\\${user.phone_code || ''} \\${user.phone || ''}\\`;\n              phoneCell.appendChild(phoneP);\n              row.appendChild(phoneCell);\n              \n              const birthDateCell = document.createElement('td');\n              const birthDateP = document.createElement('p');\n              birthDateP.textContent = user.birth_date || '';\n              birthDateCell.appendChild(birthDateP);\n              row.appendChild(birthDateCell);\n              \n              const actionsCell = document.createElement('td');\n\n              const editLink = document.createElement('a');\n              editLink.href = '#';\n              editLink.className = 'text-secondary me-2';\n              editLink.setAttribute('data-bs-toggle', 'modal');\n              editLink.setAttribute('data-bs-target', '#userDetailModal');\n              editLink.setAttribute('data-user-id', user.id);\n              const editIcon = document.createElement('i');\n              editIcon.className = 'bi bi-pencil';\n              editLink.appendChild(editIcon);\n              \n              const removeLink = document.createElement('a');\n              removeLink.href = '#';\n              removeLink.className = 'text-secondary me-2 delete-user';\n              removeLink.setAttribute('data-user-id', user.id);\n              const removeIcon = document.createElement('i');\n              removeIcon.className = 'bi bi-eraser';\n              removeLink.appendChild(removeIcon);\n              \n              actionsCell.appendChild(editLink);\n              actionsCell.appendChild(removeLink);\n              row.appendChild(actionsCell);\n              \n              return row;\n            },\n            afterPageChangeCallback: () => {\n              document.querySelectorAll('.delete-user').forEach(button => {\n                button.addEventListener('click', function(e) {\n                  e.preventDefault();\n                  const userId = this.getAttribute('data-user-id');\n                  \n                  if (confirm('Bu kullan\u0131c\u0131y\u0131 silmek istedi\u011Finize emin misiniz?')) {\n                    deleteUserIdInput.value = userId;\n                    deleteUserForm.submit();\n                  }\n                });\n              });\n            }\n          });\n        } catch (error) {\n          console.error('Sayfalama beti\u011Finde hata:', error);\n        }\n      });\n    })();<\/script> </body> </html>",
          ],
        )),
      renderComponent($$result, 'Head', $$Head, { title: title, path: path }),
      renderHead(),
      renderComponent($$result, 'Topbar', $$Topbar, { path: path }),
      renderComponent($$result, 'Sidenav', $$Sidenav, {
        path: path,
        mainPage: mainPage,
        page: page,
      }),
      usersWithImages.slice(0, usersPerPage).map(
        (
          user,
          index,
        ) => renderTemplate`<tr class="align-middle"> <td>${index + 1}.</td> <td> <img${addAttribute(user.profile_image, 'src')}${addAttribute(`${user.first_name} ${user.last_name}`, 'alt')} class="rounded-circle img-size-32 me-2"${addAttribute(`this.onerror=null; this.src='${path}/assets/img/default-150x150.png'`, 'onerror')}${addAttribute(user.profile_image, 'data-profile-image')}> ${user.first_name} ${user.last_name} (${user.email})
</td> <td> <p>${user.phone_code} ${user.phone}</p> </td> <td> <p>${user.birth_date}</p> </td> <td> <a href="#" class="text-secondary me-2" data-bs-toggle="modal" data-bs-target="#userDetailModal"${addAttribute(user.id, 'data-user-id')}> <i class="bi bi-pencil"></i> </a> <a href="#" class="text-secondary me-2 delete-user"${addAttribute(user.id, 'data-user-id')}> <i class="bi bi-eraser"></i> </a> </td> </tr>`,
      ),
      renderComponent($$result, 'Pagination', $$Pagination, {
        id: 'pagination',
        currentPage: currentPage,
        totalPages: totalPages,
        size: 'sm',
      }),
      renderComponent($$result, 'Footer', $$Footer, {}),
      renderComponent($$result, 'Scripts', $$Scripts, { path: path }),
      defineScriptVars({
        users: JSON.stringify(usersWithImages),
        usersPerPage,
        totalPages,
        usersDetails: JSON.stringify(usersDetails),
        path,
        deleteSuccess,
        deletedUserId,
        updateSuccess,
        updatedUserId,
      }),
    );
  },
  '/Users/jin/Developments/work/ea/AdminLTE/src/pages/user-management/index.astro',
  undefined,
);

const $$file = '/Users/jin/Developments/work/ea/AdminLTE/src/pages/user-management/index.astro';
const $$url = '/user-management';

const _page = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      default: $$Index,
      file: $$file,
      prerender,
      url: $$url,
    },
    Symbol.toStringTag,
    { value: 'Module' },
  ),
);

const page = () => _page;

export { page };
