// src/utils/imageUtils.js
export const getUserProfileImage = (user) => {
  const baseUrl = 'https://s3.eu-central-1.amazonaws.com/adimsayar/'; // 기본 URL
  const defaultAvatar = `${baseUrl}profile/default_avatar.png`; // 기본 아바타 이미지 URL

  if (user.profile_image) {
    // 프로필 이미지가 있는 경우
    if (user.profile_image.startsWith('http')) {
      // 이미지가 이미 완전한 URL인 경우
      return user.profile_image;
    } else {
      // 상대 경로인 경우
      return `${baseUrl}${user.profile_image}`;
    }
  } else {
    // 프로필 이미지가 없는 경우 기본 아바타 사용
    return defaultAvatar;
  }
};
