// api/endpoints/notifications.js
import api from "@/app/lib/axios";

export const fetchNotifications = async () => {
  try {
    const response = await api.get("/notifications/");
    return response.data;
  } catch (error) {
    throw error;
  }
};

export const markNotificationAsRead = async (notification_id) => {
  const response = await api.post("/notifications/mark-read", {
    notification_id,
  });
  return response.data;
};

// 알림 삭제 엔드포인트 함수 추가
export const deleteNotification = async (notificationId) => {
  try {
    const response = await api.post('/notifications/soft-delete', {
      notification_id: notificationId
    });
    return response.data;
  } catch (error) {
    console.error('Error deleting notification:', error);
    throw error;
  }
};
