import api from "@/app/lib/axios";

/**
 * 주간 포인트(걸음수 포인트) 데이터를 조회합니다.
 * 백엔드 엔드포인트: GET /points/weekly
 */
export const getWeeklyPoints = async (token) => {
  const response = await api.get("/points/weekly", {
    headers: { Authorization: `Bearer ${token}` },
  });
  return response.data;
};

/**
 * 월간 포인트(걸음수 포인트) 데이터를 조회합니다.
 * 백엔드 엔드포인트: GET /points/monthly
 */
export const getMonthlyPoints = async (token) => {
  const response = await api.get("/points/monthly", {
    headers: { Authorization: `Bearer ${token}` },
  });
  return response.data;
};
