import api from "@/app/lib/axios";
import { getImageUrl } from "@/app/utils/imageUtils";

export const getProducts = async () => {
  const response = await api.get("/products");
  const data = response.data;
  return data.map((product) => ({
    ...product,
    image_url: getImageUrl(product.image_url || product.thumbnail),
  }));
};

export const getProductDetail = async (productId) => {
  try {
    const response = await api.get(`/products/${productId}`);
    const product = response.data;

    // Log the raw API response to debug
    console.log(
      `API Response for product ${productId}:`,
      JSON.stringify(product, null, 2)
    );

    // Make sure we don't lose any fields, especially specifications
    if (product.specifications) {
      console.log(
        "Product has specifications in API response:",
        product.specifications.sizes
          ? Object.keys(product.specifications.sizes).length + " sizes"
          : "no sizes"
      );
    } else {
      console.log("No specifications in API response");
    }

    // Create a complete product object preserving all fields
    const processedProduct = {
      ...product,
      image_url: getImageUrl(product.image_url || product.thumbnail),
    };

    // Log the processed product before returning
    console.log(
      "Processed product before return:",
      JSON.stringify(
        {
          id: processedProduct.id,
          name: processedProduct.name,
          hasSpecs: !!processedProduct.specifications,
          specSizes: processedProduct.specifications?.sizes
            ? Object.keys(processedProduct.specifications.sizes).length
            : 0,
        },
        null,
        2
      )
    );

    return processedProduct;
  } catch (error) {
    console.error(`Error fetching product ${productId}:`, error);
    throw error;
  }
};

export const getCategories = async () => {
  const response = await api.get("/categories");
  return response.data;
};
