// app/api/endpoints/users.js
import api from "@/app/lib/axios";
import { getImageUrl } from "@/app/utils/imageUtils";

/**
 * Fetch user profile by userId.
 * @param {string} userId - The ID of the user.
 * @returns {Promise<object>} - The user profile data.
 */
export const getUserProfile = async (userId) => {
  const response = await api.get(`/users/${userId}`);
  const profile = response.data;
  // Generate profile_pic URL using the utility function.
  profile.profile_pic = getImageUrl(profile.profile_image);
  return profile;
};

/**
 * Register a new user.
 * @param {object} userData - The user data and image object to be registered.
 * @returns {Promise<object>} - The registration result data.
 */
export const registerUser = async (userData) => {
  const payload = new FormData();
  payload.append("user_in", JSON.stringify(userData));

  if (
    userData.profileImage &&
    userData.profileImage.uri &&
    userData.profileImage.name
  ) {
    payload.append("profile_image", userData.profileImage);
  }

  return await api.post("/users/register", payload, {
    headers: { "Content-Type": "multipart/form-data" },
  });
};
