import React from "react";
import { View, Text, Image, TouchableOpacity } from "react-native";
import { Ionicons } from "@expo/vector-icons";
import { Colors, styles } from "@/assets/styles/App.styles";

export function ChatHeader({ friend, onBack }) {
  return (
    <View style={styles.ChatPageHeader}>
      <TouchableOpacity style={{ marginRight: 12 }} onPress={onBack}>
        <Ionicons name="arrow-back" size={27} color={Colors.white} />
      </TouchableOpacity>
      <View style={{ flex: 1, flexDirection: "row", alignItems: "center" }}>
        <Image
          source={{ uri: friend.avatar }}
          style={{ width: 40, height: 40, borderRadius: 20, marginRight: 10 }}
        />
        <View>
          <Text
            style={{
              color: Colors.white,
              fontSize: 18,
              fontFamily: "montbold",
            }}
          >
            {friend.name}
          </Text>
          <Text
            style={{
              color: Colors.white,
              fontSize: 12,
              fontFamily: "montregular",
            }}
          >
            {friend.online ? "Çevrimiçi" : "Çevrimdışı"}
          </Text>
        </View>
      </View>
    </View>
  );
}
