// app/components/ChatInput.js
import React from "react";
import {
  View,
  TextInput,
  TouchableOpacity,
  Platform,
  Image,
} from "react-native";
import { Ionicons } from "@expo/vector-icons";
import { Colors, styles } from "@/assets/styles/App.styles";

export function ChatInput({
  onSend,
  pickedImage,
  onPickImage,
  onClearPickedImage,
}) {
  const [message, setMessage] = React.useState("");

  const handleSend = () => {
    if (message.trim() || pickedImage) {
      onSend(message);
      setMessage("");
    }
  };

  return (
    <View style={[
      styles.chatInputContainer,
      Platform.OS === 'android' && {
        paddingBottom: 10,
        paddingTop: 10
      }
    ]}>
      <TouchableOpacity
        onPress={onPickImage}
        style={styles.chatInputActionButton}
      >
        {pickedImage ? (
          <TouchableOpacity onPress={onClearPickedImage}>
            <Image
              source={{ uri: pickedImage }}
              style={styles.chatInputPickedImage}
            />
          </TouchableOpacity>
        ) : (
          <Ionicons name="add-circle" size={24} color={Colors.primary} />
        )}
      </TouchableOpacity>

      <TextInput
        style={[
          styles.chatInputField,
          Platform.OS === 'android' && {
            paddingVertical: 8,
            marginBottom: 0
          }
        ]}
        placeholder="Mesaj yazın..."
        value={message}
        onChangeText={setMessage}
        multiline={true}
        maxLength={1000}
        returnKeyType="default"
        blurOnSubmit={false}
      />

      <TouchableOpacity
        onPress={handleSend}
        style={styles.chatInputSendButton}
        disabled={!message.trim() && !pickedImage}
      >
        <Ionicons
          name="send"
          size={24}
          color={
            !message.trim() && !pickedImage ? Colors.tertiary : Colors.primary
          }
        />
      </TouchableOpacity>
    </View>
  );
}
