import React from "react";
import { View, Text, StyleSheet, Image } from "react-native";
import { Colors } from "@/assets/styles/App.styles";

export const MessageBubble = ({ message, isOwn }) => {
  return (
    <View
      style={[
        styles.container,
        isOwn ? styles.ownMessageContainer : styles.otherMessageContainer,
      ]}
    >
      {!isOwn && (
        <Image source={{ uri: message.user.avatar }} style={styles.avatar} />
      )}
      <View
        style={[
          styles.bubbleContainer,
          isOwn ? styles.ownMessage : styles.otherMessage,
        ]}
      >
        <Text
          style={[
            styles.messageText,
            isOwn ? styles.ownMessageText : styles.otherMessageText,
          ]}
        >
          {message.text}
        </Text>
        <Text style={styles.timeText}>
          {new Date(message.createdAt).toLocaleTimeString([], {
            hour: "2-digit",
            minute: "2-digit",
          })}
        </Text>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flexDirection: "row",
    marginVertical: 4,
    marginHorizontal: 8,
    alignItems: "flex-end",
  },
  ownMessageContainer: {
    justifyContent: "flex-end",
  },
  otherMessageContainer: {
    justifyContent: "flex-start",
  },
  avatar: {
    width: 32,
    height: 32,
    borderRadius: 16,
    marginRight: 8,
  },
  bubbleContainer: {
    maxWidth: "70%",
    padding: 12,
    borderRadius: 16,
  },
  ownMessage: {
    backgroundColor: Colors.primary,
    borderBottomRightRadius: 4,
  },
  otherMessage: {
    backgroundColor: Colors.secondary,
    borderBottomLeftRadius: 4,
  },
  messageText: {
    fontSize: 16,
    marginBottom: 4,
  },
  ownMessageText: {
    color: Colors.white,
  },
  otherMessageText: {
    color: Colors.white,
  },
  timeText: {
    fontSize: 11,
    color: "rgba(255, 255, 255, 0.7)",
    alignSelf: "flex-end",
  },
});
