import React from "react";
import { View, Text, TouchableOpacity } from "react-native";
import {
  MaterialCommunityIcons,
  FontAwesome5,
  Ionicons,
} from "@expo/vector-icons";
import AsyncStorage from "@react-native-async-storage/async-storage";
import dayjs from "dayjs";
import { Colors } from "@/assets/styles/App.styles";
import useHealthStore from "@/app/store/healthStore";
import * as stepsEndpoints from "@/app/api/endpoints/steps";
import Toast from "@/app/components/common/ToastMessage";

// Helper functions for test mode (simplified versions)
const getDailyStepKey = () => {
  const userId = useHealthStore.getState().user?.id;
  return userId ? `DAILY_STEP_${userId}` : "DAILY_STEP";
};

const saveStepHistory = async (date, steps) => {
  // For test purposes, simply log the action
  console.log(`TestMode: Saving step history for ${date}: ${steps} steps`);
};

const TestMode = () => {
  return (
    <View
      style={{
        padding: 15,
        marginTop: 15,
        backgroundColor: "#f0f8ff",
        borderRadius: 10,
        marginHorizontal: 20,
        borderWidth: 1,
        borderColor: Colors.primary,
      }}
    >
      <Text
        style={{
          fontFamily: "montbold",
          fontSize: 16,
          color: Colors.primary,
          marginBottom: 10,
          textAlign: "center",
        }}
      >
        Test Modu (DEV)
      </Text>
      <View
        style={{
          flexDirection: "row",
          justifyContent: "space-between",
          marginBottom: 10,
        }}
      >
        {/* +50 Steps Button */}
        <TouchableOpacity
          style={{
            flex: 1,
            backgroundColor: "#8bc34a",
            padding: 10,
            borderRadius: 5,
            marginRight: 5,
            alignItems: "center",
          }}
          onPress={async () => {
            try {
              Toast(
                "Test",
                "+50 adım ekleniyor ve senkronize ediliyor...",
                "success"
              );
              const serverData = await stepsEndpoints.getCurrentSteps();
              const serverSteps = serverData.steps_count;
              const storedSteps =
                (await AsyncStorage.getItem(getDailyStepKey())) || "0";
              const localSteps = parseInt(storedSteps);
              console.log(
                `TestMode: Adding 50 steps - Server: ${serverSteps}, Local: ${localSteps}`
              );
              if (serverSteps !== localSteps) {
                await AsyncStorage.setItem(
                  getDailyStepKey(),
                  String(serverSteps)
                );
                useHealthStore.setState({
                  steps: serverSteps,
                  lastSyncedSteps: serverSteps,
                });
              }
              const newSteps = serverSteps + 50;
              useHealthStore.setState({ steps: newSteps });
              console.log("TestMode: Sending +50 steps to server");
              const response = await stepsEndpoints.accumulateSteps(50);
              if (response && response.steps_count) {
                const finalServerSteps = response.steps_count;
                await AsyncStorage.setItem(
                  getDailyStepKey(),
                  String(finalServerSteps)
                );
                useHealthStore.setState({
                  steps: finalServerSteps,
                  lastSyncedSteps: finalServerSteps,
                });
                await saveStepHistory(
                  dayjs().format("YYYY-MM-DD"),
                  finalServerSteps
                );
              }
              Toast(
                "Adım eklendi",
                "+50 adım eklendi ve senkronize edildi.",
                "success"
              );
            } catch (error) {
              Toast(
                "Hata",
                "Adım eklenirken hata oluştu: " + error.message,
                "danger"
              );
            }
          }}
        >
          <Text style={{ color: "white", fontFamily: "montmedium" }}>
            +50 Steps
          </Text>
        </TouchableOpacity>

        {/* +100 Steps Button */}
        <TouchableOpacity
          style={{
            flex: 1,
            backgroundColor: "#8bc34a",
            padding: 10,
            borderRadius: 5,
            marginHorizontal: 5,
            alignItems: "center",
          }}
          onPress={async () => {
            try {
              Toast(
                "Test",
                "+100 adım ekleniyor ve senkronize ediliyor...",
                "success"
              );
              // Similar logic for +100 steps, simplified for test mode
              const serverData = await stepsEndpoints.getCurrentSteps();
              const serverSteps = serverData.steps_count;
              const storedSteps =
                (await AsyncStorage.getItem(getDailyStepKey())) || "0";
              const localSteps = parseInt(storedSteps);
              console.log(
                `TestMode: Adding 100 steps - Server: ${serverSteps}, Local: ${localSteps}`
              );
              if (serverSteps !== localSteps) {
                await AsyncStorage.setItem(
                  getDailyStepKey(),
                  String(serverSteps)
                );
                useHealthStore.setState({
                  steps: serverSteps,
                  lastSyncedSteps: serverSteps,
                });
              }
              const newSteps = serverSteps + 100;
              useHealthStore.setState({ steps: newSteps });
              const response = await stepsEndpoints.accumulateSteps(100);
              if (response && response.steps_count) {
                const finalServerSteps = response.steps_count;
                await AsyncStorage.setItem(
                  getDailyStepKey(),
                  String(finalServerSteps)
                );
                useHealthStore.setState({
                  steps: finalServerSteps,
                  lastSyncedSteps: finalServerSteps,
                });
                await saveStepHistory(
                  dayjs().format("YYYY-MM-DD"),
                  finalServerSteps
                );
              }
              Toast(
                "Adım eklendi",
                "+100 adım eklendi ve senkronize edildi.",
                "success"
              );
            } catch (error) {
              Toast(
                "Hata",
                "Adım eklenirken hata oluştu: " + error.message,
                "danger"
              );
            }
          }}
        >
          <Text style={{ color: "white", fontFamily: "montmedium" }}>
            +100 Steps
          </Text>
        </TouchableOpacity>

        {/* +500 Steps Button */}
        <TouchableOpacity
          style={{
            flex: 1,
            backgroundColor: "#8bc34a",
            padding: 10,
            borderRadius: 5,
            marginLeft: 5,
            alignItems: "center",
          }}
          onPress={async () => {
            try {
              Toast(
                "Test",
                "+500 adım ekleniyor ve senkronize ediliyor...",
                "success"
              );
              const serverData = await stepsEndpoints.getCurrentSteps();
              const serverSteps = serverData.steps_count;
              const storedSteps =
                (await AsyncStorage.getItem(getDailyStepKey())) || "0";
              const localSteps = parseInt(storedSteps);
              console.log(
                `TestMode: Adding 500 steps - Server: ${serverSteps}, Local: ${localSteps}`
              );
              if (serverSteps !== localSteps) {
                await AsyncStorage.setItem(
                  getDailyStepKey(),
                  String(serverSteps)
                );
                useHealthStore.setState({
                  steps: serverSteps,
                  lastSyncedSteps: serverSteps,
                });
              }
              const newSteps = serverSteps + 500;
              useHealthStore.setState({ steps: newSteps });
              const response = await stepsEndpoints.accumulateSteps(500);
              if (response && response.steps_count) {
                const finalServerSteps = response.steps_count;
                await AsyncStorage.setItem(
                  getDailyStepKey(),
                  String(finalServerSteps)
                );
                useHealthStore.setState({
                  steps: finalServerSteps,
                  lastSyncedSteps: finalServerSteps,
                });
                await saveStepHistory(
                  dayjs().format("YYYY-MM-DD"),
                  finalServerSteps
                );
              }
              Toast(
                "Adım eklendi",
                "+500 adım eklendi ve senkronize edildi.",
                "success"
              );
            } catch (error) {
              Toast(
                "Hata",
                "Adım eklenirken hata oluştu: " + error.message,
                "danger"
              );
            }
          }}
        >
          <Text style={{ color: "white", fontFamily: "montmedium" }}>
            +500 Steps
          </Text>
        </TouchableOpacity>
      </View>

      {/* Force Sync Button */}
      <TouchableOpacity
        style={{
          backgroundColor: "#4caf50",
          padding: 12,
          borderRadius: 5,
          marginBottom: 10,
          alignItems: "center",
        }}
        onPress={async () => {
          try {
            Toast(
              "Senkronizasyon",
              "Adımlar senkronize ediliyor...",
              "success"
            );
            // For test mode, simply call syncSteps from healthStore
            await useHealthStore.getState().syncSteps();
            Toast(
              "Senkronizasyon Tamamlandı",
              "Adımlar senkronize edildi.",
              "success"
            );
          } catch (error) {
            Toast(
              "Senkronizasyon Hatası",
              "Senkronizasyon sırasında hata oluştu: " + error.message,
              "danger"
            );
          }
        }}
      >
        <Text style={{ color: "white", fontFamily: "montmedium" }}>
          Force Sync
        </Text>
      </TouchableOpacity>

      {/* Server Status Button */}
      <TouchableOpacity
        style={{
          backgroundColor: "#2196f3",
          padding: 12,
          borderRadius: 5,
          marginBottom: 10,
          alignItems: "center",
        }}
        onPress={async () => {
          try {
            Toast(
              "Sunucu Durumu Kontrol Ediliyor",
              "Lütfen bekleyin...",
              "info"
            );
            const serverData = await stepsEndpoints.getCurrentSteps();
            const serverSteps = serverData.steps_count;
            const storedSteps =
              (await AsyncStorage.getItem(getDailyStepKey())) || "0";
            const localSteps = parseInt(storedSteps);
            const difference = Math.abs(localSteps - serverSteps);
            const isLocalGreater = localSteps > serverSteps;
            const differenceText = isLocalGreater
              ? `Yerel değer ${difference} adım daha fazla`
              : `Sunucu değeri ${difference} adım daha fazla`;
            Toast(
              "Sunucu Durumu",
              `Sunucu: ${serverSteps} adım | Yerel: ${localSteps} adım | ${differenceText}`,
              "success"
            );
          } catch (error) {
            Toast(
              "Sunucu Hatası",
              "Sunucu durumu kontrol edilirken hata oluştu: " + error.message,
              "danger"
            );
          }
        }}
      >
        <Text style={{ color: "white", fontFamily: "montmedium" }}>
          Server Status
        </Text>
      </TouchableOpacity>
    </View>
  );
};

export default TestMode;
