import React from "react";
import { View, TouchableOpacity, StyleSheet, Text } from "react-native";
import {
  Feather,
  Ionicons,
  MaterialCommunityIcons,
  MaterialIcons,
} from "@expo/vector-icons";
import { styles, Colors } from "@/assets/styles/App.styles";
import { useNavigation, useRouter } from "expo-router";

const Toolbar = ({ selectedMenu }) => {
  const router = useRouter();
  return (
    <View style={styles.toolbarContainer}>
      <TouchableOpacity
        onPress={() => {
          if (selectedMenu !== 1) {
            console.log("Navigating to homepage.");
            router.push("pages/home/homepage");
          }
        }}
        style={[
          styles.toolbarButton,
          selectedMenu === 1 && styles.activeToolbarButton,
        ]}
      >
        <Feather
          name="home"
          size={24}
          color={selectedMenu === 1 ? Colors.white : Colors.tertiary}
        />
        <Text
          style={[
            styles.toolbarButtonText,
            selectedMenu === 1 && { color: Colors.white },
          ]}
        >
          Anasayfa
        </Text>
      </TouchableOpacity>
      {/* <TouchableOpacity onPress={() => router.push('home/searchPage')} style={[styles.toolbarButton, selectedMenu === 2 && styles.activeToolbarButton]}>
                <Feather name="search" size={24} color={selectedMenu === 2 ? Colors.white : Colors.tertiary} />
                <Text style={[styles.toolbarButtonText, selectedMenu === 2 && { color: Colors.white }]}>Ara</Text>
            </TouchableOpacity> */}
      {/*  <TouchableOpacity onPress={() => router.push('Appointments')} style={[styles.toolbarButton, selectedMenu === 3 && styles.activeToolbarButton]}>
                <Feather name="calendar" size={24} color={selectedMenu === 3 ? Colors.white : Colors.tertiary} />
                <Text style={[styles.toolbarButtonText, selectedMenu === 3 && { color: Colors.white }]}>Randevularım</Text>
            </TouchableOpacity> */}
      <TouchableOpacity
        onPress={() => {
          if (selectedMenu !== 2) {
            console.log("Navigating to shop.");
            router.push("pages/shop/shop");
          }
        }}
        style={[
          styles.toolbarButton,
          selectedMenu === 2 && styles.activeToolbarButton,
        ]}
      >
        <MaterialIcons
          name="storefront"
          size={24}
          color={selectedMenu === 2 ? Colors.white : Colors.tertiary}
        />
        <Text
          style={[
            styles.toolbarButtonText,
            selectedMenu === 2 && { color: Colors.white },
          ]}
        >
          Mağaza
        </Text>
      </TouchableOpacity>
      <TouchableOpacity
        onPress={() => {
          if (selectedMenu !== 3) {
            console.log("Navigating to friends.");
            router.push("pages/friends/friends");
          }
        }}
        style={[
          styles.toolbarButton,
          selectedMenu === 3 && styles.activeToolbarButton,
        ]}
      >
        <Ionicons
          name="people-outline"
          size={24}
          color={selectedMenu === 3 ? Colors.white : Colors.tertiary}
        />
        <Text
          style={[
            styles.toolbarButtonText,
            selectedMenu === 3 && { color: Colors.white },
          ]}
        >
          Arkadaşlar
        </Text>
      </TouchableOpacity>
      <TouchableOpacity
        onPress={() => {
          if (selectedMenu !== 4) {
            console.log("Navigating to profile.");
            router.push("pages/profile/profile");
          }
        }}
        style={[
          styles.toolbarButton,
          selectedMenu === 4 && styles.activeToolbarButton,
        ]}
      >
        <Feather
          name="user"
          size={24}
          color={selectedMenu === 4 ? Colors.white : Colors.tertiary}
        />

        <Text
          style={[
            styles.toolbarButtonText,
            selectedMenu === 4 && { color: Colors.white },
          ]}
        >
          Profil
        </Text>
      </TouchableOpacity>
    </View>
  );
};
export default Toolbar;
