// app/components/Topbar.js
import React from "react";
import { View, Text, TouchableOpacity } from "react-native";
import { Feather } from "@expo/vector-icons";
import { useNavigation } from "expo-router";
import { styles, Colors } from "@/assets/styles/App.styles";
import { useNotificationsQuery } from "@/app/hooks/queries/useNotifications";
import useNotificationStore from "@/app/store/notificationStore";
import { useShoppingCart } from "@/app/hooks/queries/useShoppingCart";

const Topbar = ({ title }) => {
  const navigation = useNavigation();
  // useShoppingCart 훅을 통해 장바구니 상태를 조회 (항목 개수)
  const { data: cartData } = useShoppingCart();
  const cartItemCount = cartData?.items?.length || 0;

  // 알림 관련 상태 업데이트
  useNotificationsQuery();
  const unreadCount = useNotificationStore((state) => state.getUnreadCount());

  return (
    <View style={styles.whiteTopbarContainer}>
      <TouchableOpacity
        style={styles.topbarMenuButton}
        onPress={() => navigation.navigate("components/notifications")}
      >
        <Feather name="bell" size={32} color={Colors.primary} />
        {unreadCount > 0 && (
          <View style={styles.NotificationCountContainer}>
            <Text style={styles.TopbarCountText}>{unreadCount}</Text>
          </View>
        )}
      </TouchableOpacity>

      <View style={styles.topbarLogoContainer}>
        {/*   <Image source={require('../../assets/images/iconcleansmall.png')} style={styles.topbarLogo} /> */}
        <Text style={styles.whiteTopbarTitle}>{title}</Text>
      </View>

      <TouchableOpacity
        activeOpacity={0.6}
        onPress={() => navigation.navigate("components/cart")}
        style={styles.topbarMenuButton}
      >
        <Feather name="shopping-cart" size={32} color={Colors.primary} />
        {cartItemCount > 0 && (
          <View style={styles.CartItemCountContainer}>
            <Text style={styles.TopbarCountText}>{cartItemCount}</Text>
          </View>
        )}
      </TouchableOpacity>
    </View>
  );
};
export default Topbar;
