import React from "react";
import {
  View,
  Text,
  ScrollView,
  TouchableOpacity,
  TextInput,
  ActivityIndicator,
  Switch,
} from "react-native";
import { Feather } from "@expo/vector-icons";
import { Colors, styles } from "@/assets/styles/App.styles";

// 터키 주요 도시 리스트

const AddressSection = ({
  addresses,
  isLoadingAddresses,
  selectedAddress,
  setSelectedAddress,
  newAddressMode,
  setNewAddressMode,
  formData,
  setFormData,
}) => {
  return (
    <View style={styles.checkoutSection}>
      <View style={styles.checkoutSectionHeader}>
        <Feather name="map-pin" size={24} color={Colors.primary} />
        <Text style={styles.checkoutSectionTitle}>Teslimat Adresi</Text>
      </View>

      {isLoadingAddresses ? (
        <ActivityIndicator size="large" color={Colors.primary} />
      ) : (
        <>
          {addresses && addresses.length > 0 && (
            <View style={styles.addressListContainer}>
              <ScrollView
                horizontal
                showsHorizontalScrollIndicator={false}
                style={{ marginBottom: 10 }}
              >
                {addresses.map((address) => (
                  <TouchableOpacity
                    key={address.id}
                    style={[
                      styles.savedAddressCard,
                      selectedAddress?.id === address.id && !newAddressMode
                        ? {
                            borderColor: Colors.primary,
                            borderWidth: 2,
                          }
                        : {},
                    ]}
                    onPress={() => {
                      setSelectedAddress(address);
                      setNewAddressMode(false);
                    }}
                  >
                    <Text style={styles.savedAddressTitle}>
                      {address.title}
                    </Text>
                    <Text style={styles.savedAddressText}>
                      {address.recipient_name}
                    </Text>
                    <Text style={styles.savedAddressText}>
                      {address.address_line1}
                    </Text>
                    {address.address_line2 && (
                      <Text style={styles.savedAddressText}>
                        {address.address_line2}
                      </Text>
                    )}
                    <Text style={styles.savedAddressText}>
                      {address.city}, {address.country}
                    </Text>
                    <Text style={styles.savedAddressText}>{address.phone}</Text>
                  </TouchableOpacity>
                ))}
              </ScrollView>
            </View>
          )}

          {/* Button to add new address */}
          <TouchableOpacity
            style={[
              styles.checkoutSectionHeader,
              {
                marginTop: 15,
                padding: 10,
                backgroundColor: Colors.lightGray,
                borderRadius: 8,
              },
            ]}
            onPress={() => {
              console.log("Setting newAddressMode to true");
              setNewAddressMode(true);
              setSelectedAddress(null);
              setFormData({
                addressTitle: "",
                fullName: "",
                phone: "",
                city: "",
                fullAddress: "",
                postalCode: "",
                saveAddress: true,
              });
            }}
          >
            <Feather name="plus-circle" size={20} color={Colors.primary} />
            <Text style={[styles.checkoutSectionTitle, { fontSize: 14 }]}>
              Yeni Adres Ekle
            </Text>
          </TouchableOpacity>
        </>
      )}

      {/* New Address Form */}
      {newAddressMode && (
        <View
          style={[
            styles.checkoutForm,
            {
              gap: 15,
              marginTop: 15,
              padding: 15,
              backgroundColor: Colors.white,
              borderRadius: 8,
            },
          ]}
        >
          <Text
            style={{
              fontSize: 16,
              fontWeight: "bold",
              color: Colors.primary,
              marginBottom: 10,
            }}
          >
            Yeni Adres Bilgileri
          </Text>
          <TextInput
            style={[
              styles.checkoutInput,
              {
                color: Colors.textDark,
                borderWidth: 1,
                borderColor: "#ddd",
                backgroundColor: "#f9f9f9",
              },
            ]}
            placeholder="Adres Başlığı (Ev, İş vb.)"
            placeholderTextColor="#666"
            value={formData.addressTitle}
            onChangeText={(text) =>
              setFormData({ ...formData, addressTitle: text })
            }
          />
          <TextInput
            style={[
              styles.checkoutInput,
              {
                color: Colors.textDark,
                borderWidth: 1,
                borderColor: "#ddd",
                backgroundColor: "#f9f9f9",
              },
            ]}
            placeholder="Ad Soyad"
            placeholderTextColor="#666"
            value={formData.fullName}
            onChangeText={(text) =>
              setFormData({ ...formData, fullName: text })
            }
          />
          <TextInput
            style={[
              styles.checkoutInput,
              {
                color: Colors.textDark,
                borderWidth: 1,
                borderColor: "#ddd",
                backgroundColor: "#f9f9f9",
              },
            ]}
            placeholder="Telefon Numarası"
            placeholderTextColor="#666"
            value={formData.phone}
            onChangeText={(text) => setFormData({ ...formData, phone: text })}
            keyboardType="phone-pad"
          />
          <TextInput
            style={[
              styles.checkoutInput,
              {
                color: Colors.textDark,
                borderWidth: 1,
                borderColor: "#ddd",
                backgroundColor: "#f9f9f9",
              },
            ]}
            placeholder="Şehir"
            placeholderTextColor="#666"
            value={formData.city}
            onChangeText={(text) => setFormData({ ...formData, city: text })}
          />
          <TextInput
            style={[
              styles.checkoutInput,
              {
                color: Colors.textDark,
                borderWidth: 1,
                borderColor: "#ddd",
                backgroundColor: "#f9f9f9",
              },
            ]}
            placeholder="Posta Kodu"
            placeholderTextColor="#666"
            value={formData.postalCode}
            onChangeText={(text) =>
              setFormData({ ...formData, postalCode: text })
            }
            keyboardType="number-pad"
          />

          <TextInput
            style={[
              styles.checkoutInput,
              styles.checkoutTextArea,
              {
                color: Colors.textDark,
                borderWidth: 1,
                borderColor: "#ddd",
                backgroundColor: "#f9f9f9",
              },
            ]}
            placeholder="Açık Adres (Mahalle, Cadde, Sokak, Bina No, Daire No)"
            placeholderTextColor="#666"
            value={formData.fullAddress}
            onChangeText={(text) =>
              setFormData({ ...formData, fullAddress: text })
            }
            multiline
            numberOfLines={3}
          />

          <View style={styles.switchContainer}>
            <Text style={styles.switchLabel}>Adresi Kaydet</Text>
            <Switch
              value={formData.saveAddress}
              onValueChange={(value) =>
                setFormData({ ...formData, saveAddress: value })
              }
              trackColor={{
                false: Colors.lightGray,
                true: Colors.primary,
              }}
              thumbColor={formData.saveAddress ? Colors.white : "#f4f3f4"}
            />
          </View>
        </View>
      )}
    </View>
  );
};

export default AddressSection;
