// app/components/common/IconButton.js
export const IconButton = ({
  icon,
  title,
  onPress,
  color = Colors.primary,
  style,
  textStyle,
}) => (
  <TouchableOpacity
    onPress={onPress}
    activeOpacity={0.6}
    style={[styles.iconButton, style]}
  >
    <Feather name={icon} size={20} color={color} />
    <Text style={[styles.iconButtonText, textStyle]}>{title}</Text>
  </TouchableOpacity>
);
