import { showMessage } from "react-native-flash-message";
import { Colors } from "@/assets/styles/App.styles";

//The type attribute set the type and color of your flash message, default options are "success" (green), "warning" (orange), "danger" (red), "info" (blue) and "default" (gray).

function Toast(
  title,
  description = "",
  type = "success",
  position = "top",
  duration = 1500,
  onPress = () => {}
) {
  return showMessage({
    message: title,
    icon: "auto",
    description,
    type,
    floating: false,
    position,
    duration,
    hideOnPress: true,
    onPress,
    backgroundColor: Colors.primary,
    style: {
      backgroundColor: type === "danger" ? "red" : Colors.primary,
    },
  });
}

export default Toast;
