import { useMutation, useQueryClient } from "@tanstack/react-query";
import api from "@/app/lib/axios";

const clickAdvertisement = async (adId) => {
  const response = await api.post("/advertisements/click", { ad_id: adId });
  return response.data;
};

export const useAdvertisementClick = () => {
  const queryClient = useQueryClient();

  return useMutation(clickAdvertisement, {
    onSuccess: () => {
      // Optionally, you can trigger a refetch of advertisement data
      queryClient.invalidateQueries(["advertisements"]);
    },
    onError: (error) => {
      console.error("Error clicking advertisement:", error);
    },
  });
};
