import { useMutation } from "@tanstack/react-query";
import api from "@/app/lib/axios";

export const useCheckout = () => {
  return useMutation({
    mutationFn: async (checkoutData) => {
      console.log("Sending checkout request:", JSON.stringify(checkoutData));

      // 백엔드 API 호출 시 장바구니 확인
      try {
        // 백엔드 장바구니 상태 확인
        const cartResponse = await api.get("/shopping-cart/");
        console.log("Backend cart before checkout:", cartResponse.data);

        if (
          !cartResponse.data ||
          !cartResponse.data.items ||
          cartResponse.data.items.length === 0
        ) {
          throw new Error(
            "장바구니가 비어 있습니다. 주문을 진행할 수 없습니다."
          );
        }

        // 백엔드에서 쇼핑카트 정보를 사용하므로 cart_items는 보내지 않음
        const response = await api.post("/orders/checkout", checkoutData);
        console.log("Checkout successful response:", response.data);
        return response.data;
      } catch (error) {
        console.error("Checkout error details:", error);
        if (error.response) {
          console.error("Error response status:", error.response.status);
          console.error("Error response data:", error.response.data);
        }
        throw error;
      }
    },
  });
};
