// hooks/mutations/useDeleteNotification.js
import { useMutation, useQueryClient } from "@tanstack/react-query";
import { deleteNotification } from "@/app/api/endpoints/notifications";

export const useDeleteNotification = () => {
  const queryClient = useQueryClient();

  return useMutation({
    mutationFn: deleteNotification,
    onSuccess: () => {
      // 삭제 성공 시 알림 목록 갱신
      queryClient.invalidateQueries({
        queryKey: ["notifications"],
        exact: false,
      });
    },
    onError: (error) => {
      console.error("Error deleting notification:", error);
    },
  });
};
