import { useMutation, useQueryClient } from "@tanstack/react-query";
import {
  acceptFriendship,
  rejectFriendship,
  requestFriendship,
} from "@/app/api/endpoints/friends";
import Toast from "@/app/components/common/ToastMessage";
import useAuthStore from "@/app/store/authStore";

export const useAcceptFriendship = () => {
  const queryClient = useQueryClient();
  const { token } = useAuthStore();

  return useMutation({
    mutationFn: (id) => acceptFriendship(id, token),
    onSuccess: () => {
      Toast("Başarılı", "Arkadaşlık isteği kabul edildi", "success");
      queryClient.invalidateQueries(["friendships"]);
    },
    onError: (error) => {
      console.error("수락 API 호출 중 에러:", error);
      Toast("Hata", "Arkadaşlık isteği kabul edilemedi", "danger");
    },
  });
};

export const useRejectFriendship = () => {
  const queryClient = useQueryClient();
  const { token } = useAuthStore();

  return useMutation({
    mutationFn: (id) => rejectFriendship(id, token),
    onSuccess: () => {
      Toast("Başarılı", "Arkadaşlık isteği reddedildi", "success");
      queryClient.invalidateQueries(["friendships"]);
    },
    onError: () => {
      Toast("Hata", "Arkadaşlık isteği reddedilemedi", "danger");
    },
  });
};

export const useRequestFriendship = () => {
  const queryClient = useQueryClient();
  const { token } = useAuthStore();

  return useMutation({
    mutationFn: (id) => requestFriendship(id, token),
    onSuccess: () => {
      Toast("Başarılı", "Arkadaşlık isteği gönderildi", "success");
      queryClient.invalidateQueries(["friendships"]);
    },
    onError: () => {
      Toast("Hata", "Arkadaşlık isteği gönderilemedi", "danger");
    },
  });
};
