import { useMutation, useQueryClient } from "@tanstack/react-query";
import api from "@/app/lib/axios";
import useAuthStore from "@/app/store/authStore";

// 백엔드 엔드포인트를 호출하여 읽음 처리하는 함수
export const markMessagesRead = async ({ sender_id, token }) => {
  const response = await api.post(
    `/messages/read?sender_id=${sender_id}`,
    {},
    {
      headers: { Authorization: `Bearer ${token}` },
    }
  );
  return response.data;
};

export const useMarkMessagesReadMutation = () => {
  const { token } = useAuthStore();
  const queryClient = useQueryClient();
  return useMutation({
    mutationFn: (sender_id) => markMessagesRead({ sender_id, token }),
    onSuccess: (data, sender_id) => {
      // 여기서 "conversation", friendId와 일치하도록 invalidateQueries 개선
      queryClient.invalidateQueries(["conversation", sender_id]);
    },
  });
};
