// hooks/mutations/useMarkNotificationRead.js
import { useMutation, useQueryClient } from "@tanstack/react-query";
import { markNotificationAsRead } from "@/app/api/endpoints/notifications";

export const useMarkNotificationRead = () => {
  const queryClient = useQueryClient();

  return useMutation({
    mutationFn: markNotificationAsRead,
    onSuccess: () => {
      queryClient.invalidateQueries({
        queryKey: ["notifications"],
        exact: false,
      });
    },
    onError: (error) => {
      console.error("Error marking notification as read:", error);
    },
  });
};
