// app/hooks/mutations/usePointGame.js
import { useMutation } from "@tanstack/react-query";
import api from "@/app/lib/axios";

const playPointGame = async (result_point) => {
  try {
    console.log("playPointGame called with result_point:", result_point);
    const response = await api.post("points/point-game", { result_point });
    console.log("playPointGame response:", response.data);
    return response.data;
  } catch (error) {
    throw error;
  }
};

export const usePointGame = () => {
  return useMutation({
    mutationFn: playPointGame,
    onSuccess: (data) => {
      console.log("Point game played successfully:", data);
    },
    onError: (error) => {},
  });
};
