import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";

export const useAddresses = () => {
  return useQuery({
    queryKey: ["addresses"],
    queryFn: async () => {
      console.log("Fetching addresses...");
      try {
        // axios.js에서 baseURL에 이미 api/v1이 포함됨
        const response = await api.get("/addresses/");
        console.log("Addresses response:", response.data);
        return response.data;
      } catch (error) {
        console.error(
          "Error fetching addresses:",
          error.message,
          error.response?.data
        );
        throw error;
      }
    },
    staleTime: 60000, // 1 minute
    refetchOnWindowFocus: false,
  });
};

// default export 추가
export default useAddresses;
