import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";

const fetchAdvertisements = async () => {
  const response = await api.get("/advertisements");
  return response.data;
};

export const useAdvertisements = () => {
  return useQuery({
    queryKey: ["advertisements"],
    queryFn: fetchAdvertisements,
    refetchOnMount: "always",
    staleTime: 60000,
    onError: (error) => console.error("Error fetching advertisements:", error),
  });
};

// default export 추가
export default useAdvertisements;
