// app/hooks/queries/useConversation.js
import { useQuery } from "@tanstack/react-query";
import { getConversation } from "@/app/api/endpoints/messages";
import useAuthStore from "@/app/store/authStore";

export const useConversation = (friendId) => {
  const { token } = useAuthStore();
  return useQuery({
    queryKey: ["conversation", friendId],
    queryFn: () => getConversation(friendId, token),
    enabled: !!token && !!friendId,
    initialData: [],
    staleTime: 0, // Always consider data stale
    refetchOnMount: "always", // Always refetch when mounted
    refetchOnWindowFocus: true, // Refetch when window is focused
  });
};

// default export 추가
export default useConversation;
