// app/hooks/queries/useFriends.js
import { useQuery } from "@tanstack/react-query";
import { getFriendships, getMessageThreads } from "@/app/api/endpoints/friends";
import useAuthStore from "@/app/store/authStore";

export const useFriendships = () => {
  const { token } = useAuthStore();
  return useQuery({
    queryKey: ["friendships"],
    queryFn: () => getFriendships(token),
    enabled: !!token,
    initialData: [],
    staleTime: 0,
    refetchOnMount: "always",
    refetchOnWindowFocus: true,
  });
};

export const useMessageThreads = () => {
  const { token } = useAuthStore();
  return useQuery({
    queryKey: ["messageThreads"],
    queryFn: () => getMessageThreads(token),
    enabled: !!token,
    initialData: [],
    staleTime: 0,
    refetchOnMount: "always",
    refetchOnWindowFocus: true,
  });
};

// default export 추가
export default useFriendships;
