// hooks/queries/useNotifications.js
import { useQuery } from "@tanstack/react-query";
import useNotificationStore from "@/app/store/notificationStore";
import useAuthStore from "@/app/store/authStore";

export function useNotificationsQuery() {
  const token = useAuthStore((state) => state.token);
  const fetchNotifications = useNotificationStore(
    (state) => state.fetchNotifications
  );

  return useQuery({
    queryKey: ["notifications", token],
    queryFn: fetchNotifications,
    enabled: Boolean(token),
  });
}

// default export 추가
export default useNotificationsQuery;
