import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";

const fetchOrders = async () => {
  const response = await api.get("/orders/");
  return response.data;
};

const useOrders = () => {
  return useQuery({
    queryKey: ["orders"],
    queryFn: fetchOrders,
    // You can add other react-query options if needed
  });
};

export default useOrders;
