import { useQuery } from "@tanstack/react-query";
import { getWeeklyPoints, getMonthlyPoints } from "@/app/api/endpoints/points";
import useAuthStore from "@/app/store/authStore";

/**
 * 주간 포인트 데이터를 가져오는 쿼리 훅
 */
export const useWeeklyPoints = () => {
  const { token } = useAuthStore();
  return useQuery({
    queryKey: ["weeklyPoints"],
    queryFn: () => getWeeklyPoints(token),
    enabled: !!token,
    initialData: [],
  });
};

/**
 * 월간 포인트 데이터를 가져오는 쿼리 훅
 */
export const useMonthlyPoints = () => {
  const { token } = useAuthStore();
  return useQuery({
    queryKey: ["monthlyPoints"],
    queryFn: () => getMonthlyPoints(token),
    enabled: !!token,
    initialData: [],
  });
};
