import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";

const fetchPointsTransactions = async () => {
  // /points/transaction 엔드포인트를 호출하면
  // 예: [{"transaction_type":"referral_bonus", "amount":100, ...}, ...] 형태의 데이터를 반환합니다.
  const response = await api.get("/points/transaction");
  return response.data;
};

export const usePointsTransactions = () => {
  return useQuery({
    queryKey: ["pointsTransactions"],
    queryFn: fetchPointsTransactions,
    refetchOnMount: "always",
    staleTime: 10000,
    onError: (error) =>
      console.error("Error fetching points transactions:", error),
  });
};

// default export 추가
export default usePointsTransactions;
