import { useQuery } from "@tanstack/react-query";
import {
  getProducts,
  getProductDetail,
  getCategories,
} from "@/app/api/endpoints/products";

export const useProducts = () => {
  return useQuery({
    queryKey: ["products"],
    queryFn: getProducts,
    staleTime: 1000 * 60 * 5, // 5분 동안 데이터를 신선한 상태로 유지
    cacheTime: 1000 * 60 * 30, // 30분 동안 캐시 유지
    retry: 1, // 실패 시 1번만 재시도
    onError: (error) => {
      console.error("Products fetch error:", error);
    },
  });
};

export const useProductDetail = (productId) => {
  return useQuery({
    queryKey: ["productDetail", productId],
    queryFn: () => getProductDetail(productId),
    staleTime: 1000 * 60 * 5,
    cacheTime: 1000 * 60 * 30,
    retry: 1,
    enabled: !!productId, // productId가 있을 때만 쿼리 실행
    onError: (error) => {
      console.error(`Product detail fetch error for ID ${productId}:`, error);
    },
  });
};

export const useCategories = () => {
  return useQuery({
    queryKey: ["categories"],
    queryFn: getCategories,
    staleTime: 1000 * 60 * 10, // 카테고리는 더 오래 캐시
    cacheTime: 1000 * 60 * 60,
    retry: 1,
    onError: (error) => {
      console.error("Categories fetch error:", error);
    },
  });
};
