import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";

export const fetchReferralCodes = async () => {
  const response = await api.get("/users/referral-codes");
  return response.data;
};

export const useReferralCodes = () => {
  return useQuery({
    queryKey: ["referralCodes"],
    queryFn: fetchReferralCodes,
  });
};

// default export 추가
export default useReferralCodes;
