import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";

const fetchReferralCount = async () => {
  const response = await api.get("/referrals/count");
  return response.data;
};

export const useReferralCount = () => {
  return useQuery({
    queryKey: ["referralCount"],
    queryFn: fetchReferralCount,
    enabled: true,
    refetchOnMount: "always",
    staleTime: 5000,
    onError: (error) => console.error("Error fetching referral count:", error),
  });
};

// default export 추가
export default useReferralCount;
