import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";
import useAuthStore from "@/app/store/authStore";

export const getUnreadMessages = async (token) => {
  try {
    const response = await api.get("/messages/unread", {
      headers: { Authorization: `Bearer ${token}` },
    });
    return response.data || [];
  } catch (error) {
    if (error.response && error.response.status === 404) {
      return [];
    }
    throw error;
  }
};

export const useUnreadMessages = () => {
  const { token } = useAuthStore();
  return useQuery({
    queryKey: ["unreadMessages"],
    queryFn: () => getUnreadMessages(token),
    enabled: !!token,
    initialData: [],
  });
};

// default export 추가
export default useUnreadMessages;
