import { useQuery } from "@tanstack/react-query";
import api from "@/app/lib/axios";
import useAuthStore from "@/app/store/authStore";

/**
 * 주어진 userId에 대해 사용자 프로필 데이터를 조회합니다.
 * 엔드포인트 예시: GET /users/{userId}
 */
export const getUserProfileById = async (userId, token) => {
  const response = await api.get(`/users/${userId}`, {
    headers: { Authorization: `Bearer ${token}` },
  });
  return response.data;
};

/**
 * userId를 파라미터로 받아 프로필 정보를 가져오는 커스텀 훅입니다.
 */
export const useUserProfileById = (userId) => {
  const { token } = useAuthStore();
  return useQuery({
    queryKey: ["userProfile", userId],
    queryFn: () => getUserProfileById(userId, token),
    enabled: !!userId && !!token,
  });
};

// default export 추가
export default useUserProfileById;
