import React, { useState } from "react";
import {
  View,
  Text,
  ScrollView,
  TouchableOpacity,
  Dimensions,
} from "react-native";
import { LinearGradient } from "expo-linear-gradient";
import { Colors } from "@/assets/styles/App.styles";
import { MaterialCommunityIcons, FontAwesome5 } from "@expo/vector-icons";
import Toolbar from "@/app/components/Toolbar";
import Topbar from "@/app/components/Topbar";
import { useRouter } from "expo-router";
import WheelOfFortune from "@/app/components/WheelOfFortune";
import useHealthStore from "@/app/store/healthStore";
import Toast from "@/app/components/common/ToastMessage";
import { usePointGame } from "@/app/hooks/mutations/usePointGame";

const ConvertStepsToPoints = () => {
  const router = useRouter();
  const screenWidth = Dimensions.get("window").width;
  const { steps } = useHealthStore();
  const [selectedMultiplier, setSelectedMultiplier] = useState(null);

  // usePointGame hook
  const pointGameMutation = usePointGame();

  const handleMultipliedConversion = () => {
    if (!selectedMultiplier) {
      console.log("No multiplier selected");
      return;
    }
    const convertedPoint = Math.round(steps * parseFloat(selectedMultiplier));
    console.log(
      "handleMultipliedConversion: calling mutation with convertedPoint:",
      convertedPoint
    );
    pointGameMutation.mutate(convertedPoint, {
      onSuccess: (data) => {
        Toast(
          "Başarılı",
          "Oyun başarıyla tamamlandı, puanınız normal olarak eklendi.",
          "success"
        );
      },
      onError: (error) => {
        Toast("Hata", "Günde sadece 1 kez oynayabilirsiniz.", "danger");
      },
    });
  };

  const handleDirectConversion = () => {
    pointGameMutation.mutate(steps, {
      onSuccess: (data) => {
        Toast(
          "Başarılı",
          "Oyun başarıyla tamamlandı, puanınız normal olarak eklendi.",
          "success"
        );
      },
      onError: (error) => {
        Toast("Hata", "Günde sadece 1 kez oynayabilirsiniz.", "danger");
      },
    });
  };

  const handleSpinComplete = (multiplier) => {
    setSelectedMultiplier(multiplier);
    console.log(`Converting steps with multiplier: ${multiplier}`);
  };

  return (
    <View style={{ flex: 1, backgroundColor: Colors.white }}>
      <Topbar title="Adım Dönüştürme" />

      <ScrollView
        contentContainerStyle={{ paddingBottom: 50 }}
        showsVerticalScrollIndicator={false}
      >
        <LinearGradient
          colors={[
            Colors.gradientLight[0],
            Colors.gradientLight[1],
            Colors.gradientLight[2],
          ]}
          style={{
            padding: 20,
            borderBottomLeftRadius: 30,
            borderBottomRightRadius: 30,
            paddingBottom: 40,
          }}
        >
          <View
            style={{
              width: "100%",
              alignItems: "center",
              justifyContent: "center",
              flexDirection: "row",
              gap: 10,
            }}
          >
            <FontAwesome5 name="walking" size={24} color={Colors.primary} />
            <Text
              style={{
                fontFamily: "montbold",
                fontSize: 20,
                color: Colors.primary,
                textAlign: "center",
              }}
            >
              Günlük Adımınız:
              <Text style={{ textDecorationLine: "underline", fontSize: 22 }}>
                {steps}
              </Text>
            </Text>
          </View>

          <View style={{ alignItems: "center", marginTop: 40 }}>
            <WheelOfFortune onSpinComplete={handleSpinComplete} />
          </View>

          <View style={{ marginTop: 30, alignItems: "center" }}>
            <Text
              style={{
                fontFamily: "montbold",
                fontSize: 16,
                color: Colors.primary,
                textAlign: "center",
              }}
            >
              Çarpanlı dönüştürürseniz alacağınız puan:
              {selectedMultiplier ? (
                <Text style={{ fontSize: 18, textDecorationLine: "underline" }}>
                  {Math.round(steps * parseFloat(selectedMultiplier))}
                </Text>
              ) : (
                <Text style={{ fontSize: 14, fontStyle: "italic" }}>
                  Çarkı çevirerek çarpanı seçin
                </Text>
              )}
            </Text>
          </View>

          <View style={{ marginTop: 30 }}>
            <TouchableOpacity
              onPress={handleMultipliedConversion}
              style={{
                backgroundColor: Colors.primary,
                padding: 20,
                borderRadius: 15,
                flexDirection: "row",
                alignItems: "center",
                justifyContent: "center",
                marginBottom: 15,
                shadowColor: Colors.tertiary,
                shadowOffset: { width: 0, height: 2 },
                shadowOpacity: 0.1,
                shadowRadius: 4,
                elevation: 3,
              }}
            >
              <FontAwesome5
                name="dice"
                size={24}
                color={Colors.white}
                style={{ marginRight: 10 }}
              />
              <Text
                style={{
                  fontFamily: "montbold",
                  fontSize: 18,
                  color: Colors.white,
                }}
              >
                Çarpanlı Dönüştür
              </Text>
            </TouchableOpacity>

            <TouchableOpacity
              onPress={handleDirectConversion}
              style={{
                backgroundColor: Colors.white,
                padding: 20,
                borderRadius: 15,
                flexDirection: "row",
                alignItems: "center",
                justifyContent: "center",
                borderWidth: 2,
                borderColor: Colors.primary,
              }}
            >
              <MaterialCommunityIcons
                name="swap-horizontal"
                size={24}
                color={Colors.primary}
                style={{ marginRight: 10 }}
              />
              <Text
                style={{
                  fontFamily: "montbold",
                  fontSize: 18,
                  color: Colors.primary,
                }}
              >
                Çarpansız Dönüştür
              </Text>
            </TouchableOpacity>
          </View>
        </LinearGradient>

        <View style={{ padding: 20 }}>
          <Text
            style={{
              fontFamily: "montbold",
              fontSize: 18,
              color: Colors.secondary,
              marginBottom: 15,
            }}
          >
            Nasıl Çalışır?
          </Text>

          <View
            style={{
              backgroundColor: Colors.white,
              padding: 20,
              borderRadius: 15,
              shadowColor: Colors.tertiary,
              shadowOffset: { width: 0, height: 2 },
              shadowOpacity: 0.1,
              shadowRadius: 4,
              elevation: 3,
            }}
          >
            <Text
              style={{
                fontFamily: "montmedium",
                fontSize: 14,
                color: Colors.tertiary,
                lineHeight: 22,
              }}
            >
              <Text style={{ fontFamily: "montbold", color: Colors.primary }}>
                Çarpanlı Dönüştürme:
              </Text>
              Adımlarınızı çark çevirerek bonus çarpanlarla birlikte puana
              dönüştürün.{"\n\n"}
              <Text style={{ fontFamily: "montbold", color: Colors.primary }}>
                Çarpansız Dönüştürme:
              </Text>
              Adımlarınızı direkt olarak puana dönüştürün.
            </Text>
          </View>
        </View>
      </ScrollView>
      <Toolbar />
    </View>
  );
};

export default ConvertStepsToPoints;
