import React from "react";
import { View, Text, ScrollView, ActivityIndicator } from "react-native";
import {
  Feather,
  FontAwesome5,
  MaterialCommunityIcons,
} from "@expo/vector-icons";
import { Colors, styles } from "@/assets/styles/App.styles";
import Toolbar from "@/app/components/Toolbar";
import Topbar from "@/app/components/Topbar";
import { usePointsTransactions } from "@/app/hooks/queries/usePointsTransactions";
import { useUserPoints } from "@/app/hooks/queries/useUserPoints";

const WalletScreen = () => {
  // usePointsTransactions 훅을 사용하여 거래내역 데이터 fetch
  const {
    data: transactions,
    isLoading: transactionsLoading,
    error: transactionsError,
  } = usePointsTransactions();
  const {
    data: userPoints,
    isLoading: pointsLoading,
    error: pointsError,
  } = useUserPoints();

  if (transactionsLoading || pointsLoading) {
    return (
      <View style={{ flex: 1, justifyContent: "center", alignItems: "center" }}>
        <ActivityIndicator size="large" color={Colors.primary} />
      </View>
    );
  }

  if (transactionsError || pointsError) {
    return (
      <View style={{ flex: 1, justifyContent: "center", alignItems: "center" }}>
        <Text>Error loading data</Text>
      </View>
    );
  }

  return (
    <View style={styles.MainContainer}>
      <Topbar title="Cüzdan" />

      <ScrollView style={{ flex: 1, width: "100%" }}>
        <View style={{ padding: 20 }}>
          <View
            style={{
              backgroundColor: Colors.white,
              borderRadius: 15,
              padding: 20,
              marginBottom: 20,
              shadowColor: Colors.tertiary,
              shadowOffset: { width: 0, height: 2 },
              shadowOpacity: 0.1,
              shadowRadius: 4,
              elevation: 3,
            }}
          >
            <Text
              style={{
                fontSize: 16,
                fontFamily: "montmedium",
                color: Colors.tertiary,
                marginBottom: 10,
              }}
            >
              Toplam Adım Puan
            </Text>

            <Text
              style={{
                fontSize: 32,
                fontFamily: "montbold",
                color: Colors.primary,
              }}
            >
              {userPoints?.total_points ?? 0}
            </Text>
          </View>

          <Text
            style={{
              fontSize: 18,
              fontFamily: "montbold",
              color: Colors.tertiary,
              marginBottom: 15,
            }}
          >
            Puan Geçmişi
          </Text>

          {transactions.map((item, index) => (
            <View
              key={index}
              style={{
                backgroundColor: Colors.white,
                borderRadius: 10,
                padding: 15,
                marginBottom: 10,
                flexDirection: "row",
                alignItems: "center",
                shadowColor: Colors.tertiary,
                shadowOffset: { width: 0, height: 2 },
                shadowOpacity: 0.1,
                shadowRadius: 4,
                elevation: 3,
              }}
            >
              <FontAwesome5
                style={{ transform: [{ rotate: "270deg" }] }}
                name="shoe-prints"
                size={24}
                color={Colors.primary}
              />

              <View style={{ flex: 1, marginLeft: 15 }}>
                <Text
                  style={{
                    fontSize: 16,
                    fontFamily: "montmedium",
                    color: Colors.tertiary,
                  }}
                >
                  {item.description}
                </Text>

                <Text
                  style={{
                    fontSize: 12,
                    fontFamily: "montregular",
                    color: Colors.secondary,
                    marginTop: 5,
                  }}
                >
                  {new Date(item.created_at).toLocaleDateString("tr-TR")}
                </Text>
              </View>

              <Text
                style={{
                  fontSize: 16,
                  fontFamily: "montbold",
                  color: item.amount >= 0 ? Colors.primary : Colors.danger,
                }}
              >
                {item.amount >= 0 ? "+" : ""}
                {item.amount}
              </Text>
            </View>
          ))}
        </View>
      </ScrollView>
      <Toolbar />
    </View>
  );
};

export default WalletScreen;
