// app/login/loginScreen.js
import React, { useEffect, useState } from "react";
import {
  View,
  Text,
  TouchableOpacity,
  Image,
  KeyboardAvoidingView,
  Platform,
  ScrollView,
} from "react-native";
import { TextInput } from "react-native-paper";
import { LinearGradient } from "expo-linear-gradient";
import { Colors } from "@/assets/styles/App.styles";
import { useRouter } from "expo-router";
import { FontAwesome5, MaterialCommunityIcons } from "@expo/vector-icons";
import { Select } from "native-base";

import PhoneInput, {
  getCountriesByCallingCode,
  getCountryByCca2,
} from "react-native-international-phone-number";
import Toast from "@/app/components/common/ToastMessage";
import useAuthStore from "@/app/store/authStore";
import { useMutation } from "@tanstack/react-query";
import AsyncStorage from "@react-native-async-storage/async-storage";

export default function LoginScreen() {
  const [email, setEmail] = useState("");
  const [password, setPassword] = useState("");
  const [country, setCountry] = useState("+90");
  const [showPassword, setShowPassword] = useState(false);
  const router = useRouter();

  /*  const [countryName, setCountryName] = useState('');
 
     const [phoneNumber, setPhoneNumber] = useState('');
 
     const handlePhoneNumberChange = (phoneNumber) => {
         setPhoneNumber(phoneNumber);
     };
 
     const handleCountryChange = (selectedCountry) => {
         setCountry(selectedCountry);
     };
 
     useEffect(() => {
         const countries = getCountriesByCallingCode(country);
         console.log(JSON.stringify(countries, null, 2) + "countries");
 
         if (countries && countries.length > 0) {  // Check if array exists and has items
             setCountryName(countries[0].name.tr);  // Access first item in array
         }
     }, [country]); */

  const { mutate: login, isLoading } = useMutation({
    mutationFn: async () => {
      return await useAuthStore.getState().login(email, password);
    },
    onSuccess: async (success) => {
      if (success) {
        // 로그인 성공 후 토큰이 저장되었는지 확인
        const storedToken = await AsyncStorage.getItem("token");
        console.log("Stored token after login:", storedToken);

        Toast("Başarı", "Giriş başarılı", "success");
        router.replace("pages/home/homepage");
      } else {
        Toast("Hata", "E-posta veya şifre geçersiz", "danger");
      }
    },
    onError: (error) => {
      Toast("Hata", error.message || "Giriş hatası", "danger");
    },
  });

  const handleLogin = () => {
    if (!email || !password) {
      Toast("Hata", "Lütfen e-posta ve şifre girin", "danger");
      return;
    }
    login();
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.OS === "ios" ? "padding" : "height"}
      style={{ flex: 1 }}
    >
      <ScrollView
        showsVerticalScrollIndicator={false}
        keyboardShouldPersistTaps="handled"
        contentContainerStyle={{ flexGrow: 1 }}
      >
        <View
          style={{
            flex: 1,
            paddingHorizontal: 20,
            justifyContent: "center",
          }}
        >
          <View style={{ alignItems: "center", marginBottom: 20 }}>
            <Image
              source={require("@/assets/images/icon.png")}
              style={{
                width: 135,
                height: 135,
                borderRadius: 10,
                tintColor: Colors.primary,
              }}
              resizeMode="cover"
            />
            <Text
              style={{
                fontFamily: "montbold",
                fontSize: 28,
                color: Colors.primary,
                textAlign: "center",
              }}
            >
              Hoşgeldiniz!
            </Text>
            <Text
              style={{
                fontFamily: "montregular",
                fontSize: 16,
                color: Colors.tertiary,
                textAlign: "center",
                marginTop: 8,
              }}
            >
              Adımlarınızı takip etmeye devam etmek için giriş yapın
            </Text>
          </View>

          <View style={{ gap: 16 }}>
            <TextInput
              mode="outlined"
              label="Email"
              value={email}
              onChangeText={setEmail}
              keyboardType="email-address"
              autoCapitalize="none"
              outlineStyle={{ borderRadius: 12 }}
              style={{ backgroundColor: Colors.white }}
              theme={{
                colors: { primary: Colors.primary },
              }}
            />

            <TextInput
              mode="outlined"
              label="Şifre"
              value={password}
              onChangeText={setPassword}
              secureTextEntry={!showPassword}
              outlineStyle={{ borderRadius: 12 }}
              style={{ backgroundColor: Colors.white }}
              theme={{
                colors: { primary: Colors.primary },
              }}
              right={
                <TextInput.Icon
                  icon={showPassword ? "eye-off" : "eye"}
                  onPress={() => setShowPassword(!showPassword)}
                />
              }
            />

            {/* <View style={{ width: "100%", flexDirection: "row", alignItems: "center", justifyContent: "space-between", marginTop: 5, borderColor: "grey" }}>
                            <FontAwesome5 style={{ position: "absolute", left: 20 }} name="globe" size={20} color={Colors.primary} />

                            <Select
                                flex={1}
                                paddingLeft={55}
                                borderRadius={10}
                                fontFamily="montmedium"
                                fontSize={15}
                                color={"black"}
                                placeholderTextColor={Colors.tertiary}
                                selectedValue={country}
                                onValueChange={(itemValue) => setCountry(itemValue)}
                                placeholder="Ülke Seçiniz"
                                borderColor={"grey"}
                            >
                                <Select.Item label="Ülke Seçiniz" value="" />
                                <Select.Item label="Türkiye" value="TR" />
                                <Select.Item label="Amerika Birleşik Devletleri" value="US" />
                                <Select.Item label="Birleşik Krallık" value="GB" />
                                <Select.Item label="Almanya" value="DE" />
                                <Select.Item label="Fransa" value="FR" />
                                <Select.Item label="İtalya" value="IT" />
                                <Select.Item label="İspanya" value="ES" />
                                <Select.Item label="Hollanda" value="NL" />
                                <Select.Item label="İsveç" value="SE" />
                                <Select.Item label="Kanada" value="CA" />
                            </Select>
                        </View> */}

            {/*  <View style={{ width: "100%", height: 50 }}>
                            <PhoneInput
                                value={countryName}
                                onChangePhoneNumber={handlePhoneNumberChange}
                                selectedCountry={country}
                                onChangeSelectedCountry={handleCountryChange}
                                defaultCountry='TR'
                                language='tr'
                                placeholder=''
                                editable={false}
                                defaultValue={countryName}
                            />

                        </View> */}

            {/*   <View style={{ width: "100%", flexDirection: "row", alignItems: "center", justifyContent: "space-between" }}>
                            <FontAwesome5 style={{ position: "absolute", left: 20 }} name="globe" size={20} color={Colors.primary} />

                            <Select
                                flex={1}
                                paddingLeft={55}
                                fontFamily="montmedium"
                                fontSize={15}
                                color={"black"}
                                placeholderTextColor={Colors.tertiary}
                                selectedValue={country}
                                onValueChange={(itemValue) => setCountry(itemValue)}
                                placeholder="Ülke"
                                borderColor={Colors.secondary}
                            >
                                <Select.Item label="Türkiye" value="TR" />
                                <Select.Item label="Amerika Birleşik Devletleri" value="US" />
                                <Select.Item label="Birleşik Krallık" value="GB" />
                                <Select.Item label="Almanya" value="DE" />
                                <Select.Item label="Fransa" value="FR" />
                                <Select.Item label="İtalya" value="IT" />
                                <Select.Item label="İspanya" value="ES" />
                                <Select.Item label="Hollanda" value="NL" />
                                <Select.Item label="İsveç" value="SE" />
                                <Select.Item label="Kanada" value="CA" />
                            </Select>
                        </View> */}

            <TouchableOpacity
              onPress={() => router.push("pages/login/forgotPassword")}
              style={{ alignSelf: "flex-end" }}
            >
              <Text
                style={{
                  color: Colors.primary,
                  fontFamily: "montmedium",
                  fontSize: 14,
                }}
              >
                Şifrenizi mi unuttunuz?
              </Text>
            </TouchableOpacity>

            <TouchableOpacity
              onPress={handleLogin}
              disabled={isLoading}
              style={{
                backgroundColor: Colors.primary,
                padding: 16,
                borderRadius: 12,
                alignItems: "center",
                marginTop: 8,
                opacity: isLoading ? 0.7 : 1,
              }}
            >
              <Text
                style={{
                  color: Colors.white,
                  fontFamily: "montbold",
                  fontSize: 16,
                }}
              >
                {isLoading ? "Logging in..." : "Login"}
              </Text>
            </TouchableOpacity>

            <View
              style={{
                flexDirection: "row",
                alignItems: "center",
                justifyContent: "center",
                marginTop: 16,
              }}
            >
              <Text
                style={{
                  fontFamily: "montregular",
                  color: Colors.tertiary,
                }}
              >
                Hesabınız yok mu?{" "}
              </Text>

              <TouchableOpacity
                onPress={() => router.push("pages/login/register")}
              >
                <Text
                  style={{
                    color: Colors.primary,
                    fontFamily: "montbold",
                  }}
                >
                  Kayıt Ol
                </Text>
              </TouchableOpacity>
            </View>
          </View>
        </View>
      </ScrollView>
    </KeyboardAvoidingView>
  );
}
