// app/profile/components/AdWatch.js
import React from "react";
import { View, Text, TouchableOpacity, Linking } from "react-native";
import { MaterialCommunityIcons } from "@expo/vector-icons";
import { styles, Colors } from "@/assets/styles/App.styles";
import { useMutation, useQueryClient } from "@tanstack/react-query";
import api from "@/app/lib/axios";
import Toast from "@/app/components/common/ToastMessage";

const clickAdvertisement = async (adId) => {
  const response = await api.post("/advertisements/click", { ad_id: adId });
  return response.data;
};

export const useAdvertisementClick = () => {
  const queryClient = useQueryClient();

  return useMutation({
    mutationFn: clickAdvertisement,
    onSuccess: () => {
      queryClient.invalidateQueries(["advertisements"]);
    },
    onError: (error) => {
      if (
        error?.response?.data?.detail ===
        "Advertisement already clicked by this user"
      ) {
        Toast("Uyarı", "Bu reklamı zaten izlediniz", "danger");
      } else {
        console.error("Error clicking advertisement:", error);
      }
    },
  });
};

export const AdWatch = ({ ad }) => {
  const { mutate: recordAdClick, isLoading } = useAdvertisementClick();

  const handlePress = () => {
    if (ad?.ad_url) {
      console.log("adClick - ad_url:", ad.ad_url);
      recordAdClick(ad.id, {
        onSuccess: () => {
          Linking.openURL(ad.ad_url)
            .then(() => console.log("adClick - request success"))
            .catch((error) =>
              console.error("adClick - request failed:", error)
            );
        },
      });
    }
  };

  return (
    <View style={styles.AdWatchContainer}>
      <Text style={styles.adWatchText}>{ad.ad_video_points} Adım Puan</Text>
      <TouchableOpacity
        style={styles.adWatchButton}
        onPress={handlePress}
        disabled={isLoading}
      >
        <MaterialCommunityIcons
          name="television-play"
          size={28}
          color={Colors.white}
        />
      </TouchableOpacity>
    </View>
  );
};
