// app/profile/components/ProfileHeader.js
import React from "react";
import { View, Text, Image } from "react-native";
import { styles } from "@/assets/styles/App.styles";

export const ProfileHeader = ({ user }) => {
  return (
    <View style={styles.profilePageHeaderContainer}>
      <Image
        source={{ uri: user.profile_pic }}
        style={styles.profilePageAvatar}
        onError={(e) => {
          console.error("Failed to load profile image", e.nativeEvent.error);
        }}
      />
      <Text style={styles.profilePageName}>
        {user.first_name} {user.last_name}
      </Text>
    </View>
  );
};
